/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.floating.frames.DockingFrame;
import org.flexdock.docking.state.DockingState;
import org.flexdock.docking.state.FloatManager;
import org.flexdock.docking.state.FloatingGroup;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.event.EventManager;
import org.flexdock.perspective.LayoutSequence;
import org.flexdock.perspective.PerspectiveManager;
import org.flexdock.perspective.RestorationManager;
import org.flexdock.perspective.event.LayoutEvent;
import org.flexdock.perspective.event.LayoutListener;
import org.flexdock.perspective.event.RegistrationEvent;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.RootWindow;
import org.flexdock.util.SwingUtility;

public class Layout
implements Cloneable,
FloatManager,
Serializable {
    private HashMap dockingInfo;
    private Hashtable floatingGroups;
    private LayoutNode restorationLayout;
    private transient ArrayList layoutListeners;

    public Layout() {
        this(new HashMap(), new ArrayList(), new Hashtable());
    }

    private Layout(HashMap info, ArrayList listeners, Hashtable floatGroups) {
        this.dockingInfo = info;
        this.layoutListeners = listeners;
        this.floatingGroups = floatGroups;
    }

    private ArrayList getLayoutListeners() {
        if (this.layoutListeners == null) {
            this.layoutListeners = new ArrayList();
        }
        return this.layoutListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LayoutListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.getLayoutListeners();
            synchronized (arrayList) {
                this.getLayoutListeners().add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LayoutListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.getLayoutListeners();
            synchronized (arrayList) {
                this.getLayoutListeners().remove(listener);
            }
        }
    }

    public LayoutListener[] getListeners() {
        return this.getLayoutListeners().toArray(new LayoutListener[0]);
    }

    public void add(Dockable dockable) {
        String key = dockable == null ? null : dockable.getPersistentId();
        this.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String dockableId) {
        if (dockableId == null) {
            return;
        }
        DockingState info = null;
        HashMap hashMap = this.dockingInfo;
        synchronized (hashMap) {
            if (this.dockingInfo.containsKey(dockableId)) {
                return;
            }
            info = new DockingState(dockableId);
            this.dockingInfo.put(dockableId, info);
        }
        EventManager.dispatch(new RegistrationEvent((Object)info, (Object)this, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockingState remove(String dockableId) {
        if (dockableId == null) {
            return null;
        }
        DockingState info = null;
        HashMap hashMap = this.dockingInfo;
        synchronized (hashMap) {
            info = (DockingState)this.dockingInfo.remove(dockableId);
        }
        if (info != null) {
            EventManager.dispatch(new RegistrationEvent((Object)info, (Object)this, false));
        }
        return info;
    }

    public boolean contains(Dockable dockable) {
        return dockable == null ? false : this.contains(dockable.getPersistentId());
    }

    public boolean contains(String dockable) {
        return dockable == null ? false : this.dockingInfo.containsKey(dockable);
    }

    public Dockable getDockable(String id) {
        if (this.dockingInfo.containsKey(id)) {
            return DockingManager.getDockable(id);
        }
        return null;
    }

    public Dockable[] getDockables() {
        ArrayList<Dockable> list = new ArrayList<Dockable>(this.dockingInfo.size());
        for (String dockingId : this.dockingInfo.keySet()) {
            Dockable d = DockingManager.getDockable(dockingId);
            if (d == null) continue;
            list.add(d);
        }
        return list.toArray(new Dockable[0]);
    }

    public DockingState getDockingState(String dockableId) {
        return this.getDockingState(dockableId, false);
    }

    public DockingState getDockingState(Dockable dockable) {
        return this.getDockingState(dockable, false);
    }

    public DockingState getDockingState(Dockable dockable, boolean load) {
        if (dockable == null) {
            return null;
        }
        return this.getDockingState(dockable.getPersistentId(), load);
    }

    public DockingState getDockingState(String dockableId, boolean load) {
        Dockable dockable;
        if (dockableId == null) {
            return null;
        }
        if (load && (dockable = DockingManager.getDockable(dockableId)) != null) {
            this.isMaintained(dockable);
        }
        Object obj = this.dockingInfo.get(dockableId);
        return (DockingState)obj;
    }

    public void setDockingState(String dockableId, DockingState dockingState) {
        if (dockableId == null || dockingState == null) {
            return;
        }
        this.dockingInfo.put(dockableId, dockingState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(DockingPort dockingPort) {
        Component comp = (Component)((Object)dockingPort);
        if (comp == null || !this.isInitialized()) {
            return;
        }
        PerspectiveManager.clear(dockingPort);
        boolean listening = PerspectiveManager.isDockingStateListening();
        PerspectiveManager.setDockingStateListening(false);
        try {
            dockingPort.importLayout(this.restorationLayout);
        }
        finally {
            PerspectiveManager.setDockingStateListening(listening);
        }
        Dockable[] dockables = this.getDockables();
        ArrayList<Dockable> deferredMinimizedDockables = new ArrayList<Dockable>();
        boolean deferMinimized = SwingUtility.getActiveWindow() == null;
        boolean restoreFloatOnLoad = PerspectiveManager.isRestoreFloatingOnLoad();
        for (int i = 0; i < dockables.length; ++i) {
            Dockable dockable = dockables[i];
            if (DockingUtility.isMinimized(dockable)) {
                if (deferMinimized) {
                    deferredMinimizedDockables.add(dockable);
                    continue;
                }
                RestorationManager.getInstance().restore(dockable);
                continue;
            }
            if (!restoreFloatOnLoad || !DockingUtility.isFloating(dockable)) continue;
            RestorationManager.getInstance().restore(dockable);
        }
        this.restoreDeferredMinimizedDockables(deferredMinimizedDockables);
        LayoutEvent evt = new LayoutEvent(this, null, null, 0);
        EventManager.dispatch(evt);
    }

    private void restoreDeferredMinimizedDockables(final ArrayList deferred) {
        if (deferred == null || deferred.size() == 0) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Layout.this.restoreMinimizedDockables(deferred);
            }
        });
    }

    private void restoreMinimizedDockables(ArrayList dockables) {
        if (SwingUtility.getActiveWindow() == null) {
            this.restoreDeferredMinimizedDockables(dockables);
            return;
        }
        for (Dockable dockable : dockables) {
            RestorationManager.getInstance().restore(dockable);
        }
    }

    private boolean isMaintained(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        if (!this.contains(dockable)) {
            this.add(dockable);
        }
        return true;
    }

    public void hide(Dockable dockable) {
        if (!this.isMaintained(dockable)) {
            return;
        }
        boolean hidden = false;
        if (DockingManager.isDocked(dockable)) {
            hidden = DockingManager.undock(dockable);
        } else if (DockingUtility.isMinimized(dockable)) {
            hidden = DockingManager.getMinimizeManager().close(dockable);
        }
        if (hidden) {
            LayoutEvent evt = new LayoutEvent(this, null, dockable.getPersistentId(), 2);
            EventManager.dispatch(evt);
        }
    }

    public void show(Dockable dockable, DockingPort dockingPort) {
        if (!this.isMaintained(dockable) || DockingManager.isDocked(dockable)) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Layout layout = this;
        synchronized (layout) {
            LayoutNode restoreNode;
            ArrayList listeners = (ArrayList)this.getLayoutListeners().clone();
            HashMap infoMap = (HashMap)this.dockingInfo.clone();
            for (String key : this.dockingInfo.keySet()) {
                DockingState info = this.getDockingState(key);
                infoMap.put(key, info.clone());
            }
            Hashtable floatTable = (Hashtable)this.floatingGroups.clone();
            for (Object key : this.floatingGroups.keySet()) {
                FloatingGroup group = (FloatingGroup)this.floatingGroups.get(key);
                floatTable.put(key, group.clone());
            }
            Layout clone = new Layout(infoMap, listeners, floatTable);
            clone.restorationLayout = restoreNode = this.restorationLayout == null ? null : (LayoutNode)this.restorationLayout.clone();
            return clone;
        }
    }

    private DockingFrame getDockingFrame(Dockable dockable, Component frameOwner) {
        DockingFrame frame;
        FloatingGroup group = this.getGroup(dockable);
        if (group == null) {
            group = new FloatingGroup(this.getFloatingGroup(dockable));
        }
        if ((frame = group.getFrame()) == null) {
            frame = DockingFrame.create(frameOwner, group.getName());
            group.setFrame(frame);
            this.floatingGroups.put(group.getName(), group);
        }
        return frame;
    }

    public DockingFrame floatDockable(Dockable dockable, Component frameOwner, Rectangle screenBounds) {
        if (dockable == null || screenBounds == null) {
            return null;
        }
        DockingFrame frame = this.getDockingFrame(dockable, frameOwner);
        if (screenBounds != null) {
            frame.setBounds(screenBounds);
        }
        DockingManager.undock(dockable);
        frame.addDockable(dockable);
        if (!frame.isVisible()) {
            frame.setVisible(true);
        }
        return frame;
    }

    public DockingFrame floatDockable(Dockable dockable, Component frameOwner) {
        Rectangle bounds;
        FloatingGroup group = this.getGroup(dockable);
        Rectangle rectangle = bounds = group == null ? null : group.getBounds();
        if (bounds == null) {
            bounds = dockable.getComponent().isValid() ? dockable.getComponent().getBounds() : new Rectangle(0, 0, 200, 200);
            Rectangle ownerBounds = frameOwner instanceof DockingFrame ? ((DockingFrame)frameOwner).getOwner().getBounds() : RootWindow.getRootContainer(frameOwner).getRootContainer().getBounds();
            int x = ownerBounds.x + ownerBounds.width / 2 - bounds.width / 2;
            int y = ownerBounds.y + ownerBounds.height / 2 - bounds.height / 2;
            bounds.setLocation(x, y);
        }
        return this.floatDockable(dockable, frameOwner, bounds);
    }

    public FloatingGroup getGroup(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        String groupId = this.getFloatingGroup(dockable);
        return this.getGroup(groupId);
    }

    public String[] getFloatingGroupIds() {
        return this.floatingGroups.keySet().toArray(new String[0]);
    }

    public FloatingGroup getGroup(String groupId) {
        return groupId == null ? null : (FloatingGroup)this.floatingGroups.get(groupId);
    }

    public void addFloatingGroup(FloatingGroup floatingGroup) {
        if (floatingGroup == null) {
            return;
        }
        this.floatingGroups.put(floatingGroup.getName(), floatingGroup);
    }

    public void addToGroup(Dockable dockable, String groupId) {
        this.removeFromGroup(dockable);
        FloatingGroup group = this.getGroup(groupId);
        if (dockable != null && group != null) {
            group.addDockable(dockable.getPersistentId());
            this.setFloatingGroup(dockable, group.getName());
        }
    }

    public void removeFromGroup(Dockable dockable) {
        FloatingGroup group = this.getGroup(dockable);
        if (dockable != null) {
            if (group != null) {
                group.removeDockable(dockable.getPersistentId());
            }
            this.setFloatingGroup(dockable, null);
        }
        if (group != null && group.getDockableCount() == 0) {
            this.floatingGroups.remove(group.getName());
            group.destroy();
        }
    }

    private String getFloatingGroup(Dockable dockable) {
        DockingState info = this.getDockingState(dockable, false);
        return info.getFloatingGroup();
    }

    private void setFloatingGroup(Dockable dockable, String group) {
        DockingState info = this.getDockingState(dockable, false);
        info.setFloatingGroup(group);
    }

    public boolean isInitialized() {
        return this.restorationLayout != null;
    }

    public LayoutNode getRestorationLayout() {
        return this.restorationLayout;
    }

    public void setRestorationLayout(LayoutNode restorationLayout) {
        this.restorationLayout = restorationLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(LayoutSequence sequence) {
        List states = sequence.getDockingStates();
        HashMap hashMap = this.dockingInfo;
        synchronized (hashMap) {
            for (DockingState info : states) {
                this.dockingInfo.put(info.getDockableId(), info);
            }
        }
    }
}

