/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeNode;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.DockingStrategy;
import org.flexdock.docking.RegionChecker;
import org.flexdock.docking.activation.ActiveDockableTracker;
import org.flexdock.docking.defaults.BorderManager;
import org.flexdock.docking.defaults.DefaultRegionChecker;
import org.flexdock.docking.defaults.DockablePropertyChangeHandler;
import org.flexdock.docking.defaults.DockingSplitPane;
import org.flexdock.docking.defaults.StandardBorderManager;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.event.DockingListener;
import org.flexdock.docking.event.TabbedDragListener;
import org.flexdock.docking.event.hierarchy.DockingPortTracker;
import org.flexdock.docking.props.DockingPortPropertySet;
import org.flexdock.docking.props.PropertyChangeListenerFactory;
import org.flexdock.docking.props.PropertyManager;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.docking.state.tree.DockableNode;
import org.flexdock.docking.state.tree.DockingPortNode;
import org.flexdock.docking.state.tree.SplitNode;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.LookAndFeelSettings;
import org.flexdock.util.SwingUtility;
import org.flexdock.util.UUID;

public class DefaultDockingPort
extends JPanel
implements DockingPort,
DockingConstants {
    private static final WeakHashMap COMPONENT_TITLES = new WeakHashMap();
    protected ArrayList dockingListeners;
    private Component dockedComponent;
    private BorderManager borderManager;
    private String persistentId;
    private boolean tabsAsDragSource;
    private boolean rootPort;
    private BufferedImage dragImage;
    private Timer timer;
    private Object lock = new Object();
    private MaximizationInstallInfo maximizationInstallInfo;
    private MaximizationReleaseInfo maximizationReleaseInfo;

    public DefaultDockingPort() {
        this(UUID.randomUUID().toString());
    }

    public DefaultDockingPort(String id) {
        this.setPersistentId(id);
        this.dockingListeners = new ArrayList(2);
        this.addDockingListener(this);
        DockingPortPropertySet props = this.getDockingProperties();
        props.setRegionChecker(new DefaultRegionChecker());
        this.addHierarchyListener(DockingPortTracker.getInstance());
        this.rootPort = true;
        this.setLayout(this.createLayout());
        this.setBorderManager(this.createBorderManager());
    }

    protected LayoutManager createLayout() {
        return new PortLayout();
    }

    protected BorderManager createBorderManager() {
        return new StandardBorderManager(new EmptyBorder(0, 0, 0, 0));
    }

    public Component add(Component comp) {
        return this.setComponent(comp);
    }

    public Component add(Component comp, int index) {
        return this.setComponent(comp);
    }

    public void add(Component comp, Object constraints) {
        this.setComponent(comp);
    }

    public void add(Component comp, Object constraints, int index) {
        this.setComponent(comp);
    }

    public Component add(String name, Component comp) {
        return this.setComponent(comp);
    }

    private void addCmp(DockingPort port, Component c) {
        if (port instanceof Container) {
            ((Container)((Object)port)).add(c);
        }
    }

    private void dockCmp(DockingPort port, Component c) {
        port.dock(c, "CENTER");
    }

    public boolean isDockingAllowed(Component comp, String region) {
        if (comp == null || !this.isValidDockingRegion(region)) {
            return false;
        }
        if (!this.isParentDockingPort(comp)) {
            return true;
        }
        Component docked = this.getDockedComponent();
        if (!(docked instanceof JTabbedPane)) {
            return false;
        }
        JTabbedPane tabs = (JTabbedPane)docked;
        return tabs.getTabCount() >= 2;
    }

    final void evaluateDockingBorderStatus() {
        if (this.borderManager == null) {
            return;
        }
        Component docked = this.getDockedComponent();
        if (docked == null) {
            this.borderManager.managePortNullChild(this);
        } else if (docked instanceof JSplitPane) {
            this.borderManager.managePortSplitChild(this);
        } else if (docked instanceof JTabbedPane) {
            this.borderManager.managePortTabbedChild(this);
        } else {
            this.borderManager.managePortSimpleChild(this);
        }
    }

    public String getRegion(Point location) {
        if (location == null) {
            return "UNKNOWN";
        }
        RegionChecker regionChecker = this.getRegionChecker();
        Dockable d = this.getDockableAt(location);
        Component regionTest = this;
        if (d != null) {
            regionTest = d.getComponent();
            location = SwingUtilities.convertPoint(this, location, regionTest);
        }
        return regionChecker.getRegion(regionTest, location);
    }

    public RegionChecker getRegionChecker() {
        return this.getDockingProperties().getRegionChecker();
    }

    public Dockable getDockableAt(Point location) {
        if (location == null) {
            return null;
        }
        Component docked = this.getDockedComponent();
        if (docked == null || docked instanceof JSplitPane) {
            return null;
        }
        if (docked instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)docked;
            Component c = tabs.getComponentAt(location.x, location.y);
            return c instanceof Dockable ? (Dockable)((Object)c) : DockingManager.getDockable(c);
        }
        return DockingManager.getDockable(docked);
    }

    public Component getComponent(String region) {
        Component docked = this.getDockedComponent();
        if (docked == null) {
            return null;
        }
        if (docked instanceof JTabbedPane) {
            if (!"CENTER".equals(region)) {
                return null;
            }
            JTabbedPane tabs = (JTabbedPane)docked;
            return tabs.getSelectedComponent();
        }
        if (docked instanceof JSplitPane) {
            Component c;
            boolean horizontal;
            if ("CENTER".equals(region)) {
                return null;
            }
            JSplitPane split = (JSplitPane)docked;
            boolean bl = horizontal = split.getOrientation() == 1;
            if (horizontal ? "NORTH".equals(region) || "SOUTH".equals(region) : "EAST".equals(region) || "WEST".equals(region)) {
                return null;
            }
            boolean left = "NORTH".equals(region) || "WEST".equals(region);
            Component component = c = left ? split.getLeftComponent() : split.getRightComponent();
            if (!(c instanceof DockingPort)) {
                return null;
            }
            return ((DockingPort)((Object)c)).getDockedComponent();
        }
        return "CENTER".equals(region) ? docked : null;
    }

    public Dockable getDockable(String region) {
        Component c = this.getComponent(region);
        return DockingManager.getDockable(c);
    }

    protected JTabbedPane createTabbedPane() {
        Insets oldInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        int tabPlacement = this.getInitTabPlacement();
        int edgeInset = LookAndFeelSettings.getTabEdgeInset(tabPlacement);
        Insets newInsets = new Insets(0, 0, 0, 0);
        switch (tabPlacement) {
            case 1: {
                newInsets.top = edgeInset >= 0 ? edgeInset : oldInsets.top;
                break;
            }
            case 2: {
                newInsets.left = edgeInset >= 0 ? edgeInset : oldInsets.left;
                break;
            }
            case 3: {
                newInsets.bottom = edgeInset >= 0 ? edgeInset : oldInsets.bottom;
                break;
            }
            case 4: {
                newInsets.right = edgeInset >= 0 ? edgeInset : oldInsets.right;
            }
        }
        UIManager.put("TabbedPane.contentBorderInsets", newInsets);
        JTabbedPane pane = new JTabbedPane();
        pane.setTabPlacement(tabPlacement);
        UIManager.put("TabbedPane.contentBorderInsets", oldInsets);
        TabbedDragListener tdl = new TabbedDragListener();
        pane.addMouseListener(tdl);
        pane.addMouseMotionListener(tdl);
        return pane;
    }

    protected void updateTab(Dockable dockable) {
        JTabbedPane tabs;
        int index;
        Component docked = this.getDockedComponent();
        if (docked instanceof JTabbedPane && (index = (tabs = (JTabbedPane)docked).indexOfComponent(dockable.getComponent())) > -1) {
            tabs.setIconAt(index, dockable.getDockingProperties().getTabIcon());
            tabs.setTitleAt(index, dockable.getDockingProperties().getDockableDesc());
        }
    }

    public DockingStrategy getDockingStrategy() {
        return DockingManager.getDockingStrategy(this);
    }

    public void clear() {
        this.removeAll();
    }

    public boolean dock(Component comp, String region) {
        if (comp == null || region == null) {
            return false;
        }
        Dockable dockable = DockingManager.getDockable(comp);
        if (dockable == null) {
            dockable = DockingManager.registerDockable(comp);
        }
        return this.dock(dockable, region);
    }

    public boolean dock(Dockable dockable, String region) {
        boolean success;
        if (dockable == null) {
            return false;
        }
        Component comp = dockable.getComponent();
        if (comp == null || !this.isDockingAllowed(comp, region)) {
            return false;
        }
        Component docked = this.getDockedComponent();
        if (comp == docked) {
            return false;
        }
        if (docked == null) {
            region = "CENTER";
        }
        String tabTitle = DockingUtility.getTabText(dockable);
        COMPONENT_TITLES.put(comp, tabTitle);
        if (!this.isSingleTabAllowed() && docked == null) {
            this.setComponent(comp);
            this.evaluateDockingBorderStatus();
            return true;
        }
        boolean bl = success = "CENTER".equals(region) ? this.dockInCenterRegion(comp) : this.dockInOuterRegion(comp, region);
        if (success) {
            this.evaluateDockingBorderStatus();
            if (!"CENTER".equals(region)) {
                this.resetSplitDividerLocation();
            }
        }
        return success;
    }

    private void resetSplitDividerLocation() {
        Component c = this.getDockedComponent();
        if (c instanceof JSplitPane) {
            this.deferSplitDividerReset((JSplitPane)c);
        }
    }

    private void deferSplitDividerReset(final JSplitPane splitPane) {
        this.applySplitDividerLocation(splitPane);
        if (splitPane instanceof DockingSplitPane) {
            return;
        }
        int size = SwingUtility.getSplitPaneSize(splitPane);
        if (splitPane.isVisible() && size > 0 && EventQueue.isDispatchThread()) {
            this.applySplitDividerLocation(splitPane);
            splitPane.validate();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DefaultDockingPort.this.deferSplitDividerReset(splitPane);
            }
        });
    }

    private void applySplitDividerLocation(JSplitPane splitPane) {
        DockingStrategy strategy = DockingManager.getDockingStrategy(this);
        int loc = strategy.getInitialDividerLocation(this, splitPane);
        splitPane.setDividerLocation(loc);
    }

    private boolean dockInCenterRegion(Component comp) {
        Component docked = this.getDockedComponent();
        JTabbedPane tabs = null;
        if (docked instanceof JTabbedPane) {
            tabs = (JTabbedPane)docked;
            this.addTab(tabs, comp);
            tabs.revalidate();
            tabs.setSelectedIndex(tabs.getTabCount() - 1);
            return true;
        }
        tabs = this.createTabbedPane();
        if (tabs == null) {
            return false;
        }
        if (docked != null) {
            this.remove(docked);
            this.addTab(tabs, docked);
        }
        this.addTab(tabs, comp);
        this.setComponent(tabs);
        tabs.setSelectedIndex(tabs.getTabCount() - 1);
        return true;
    }

    private void addTab(JTabbedPane tabs, Component comp) {
        String tabText = this.getValidTabTitle(tabs, comp);
        tabs.add(comp, tabText);
        Dockable d = DockingManager.getDockable(comp);
        if (d == null) {
            return;
        }
        Icon icon = d.getDockingProperties().getTabIcon();
        int indx = tabs.getTabCount() - 1;
        tabs.setIconAt(indx, icon);
    }

    private boolean dockInOuterRegion(Component comp, String region) {
        Dimension halfSize = this.getSize();
        halfSize.width /= 2;
        halfSize.height /= 2;
        Component docked = this.getDockedComponent();
        this.remove(docked);
        DockingStrategy strategy = this.getDockingStrategy();
        DockingPort oldContent = strategy.createDockingPort(this);
        DockingPort newContent = strategy.createDockingPort(this);
        this.addCmp(oldContent, docked);
        this.dockCmp(newContent, comp);
        JSplitPane newDockedContent = strategy.createSplitPane(this, region);
        DockingPort[] ports = this.putPortsInOrder(oldContent, newContent, region);
        if (ports[0] instanceof JComponent) {
            ((JComponent)((Object)ports[0])).setMinimumSize(new Dimension(0, 0));
        }
        if (ports[1] instanceof JComponent) {
            ((JComponent)((Object)ports[1])).setMinimumSize(new Dimension(0, 0));
        }
        if (ports[0] instanceof Component) {
            newDockedContent.setLeftComponent((Component)((Object)ports[0]));
        }
        if (ports[1] instanceof Component) {
            newDockedContent.setRightComponent((Component)((Object)ports[1]));
        }
        double ratio = 0.5;
        if (docked instanceof Dockable && newDockedContent instanceof DockingSplitPane) {
            Float siblingRatio = ((Dockable)((Object)docked)).getDockingProperties().getSiblingSize(region);
            if (siblingRatio != null) {
                ratio = siblingRatio.doubleValue();
            }
            ((DockingSplitPane)newDockedContent).setInitialDividerRatio(ratio);
        }
        newDockedContent.setDividerLocation(ratio);
        this.setComponent(newDockedContent);
        if (this.isShowing()) {
            return true;
        }
        double proportion = strategy.getDividerProportion(this, newDockedContent);
        SwingUtility.putClientProperty((Component)((Object)oldContent), "DefaultDockingStrategy.PREFERRED_PROPORTION", new Float(proportion));
        SwingUtility.putClientProperty((Component)((Object)newContent), "DefaultDockingStrategy.PREFERRED_PROPORTION", new Float(1.0 - proportion));
        return true;
    }

    public Component getDockedComponent() {
        return this.dockedComponent;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String id) {
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        this.persistentId = id;
        DockingPortTracker.updateIndex(this);
    }

    private String getValidTabTitle(JTabbedPane tabs, Component comp) {
        String title = (String)COMPONENT_TITLES.get(comp);
        if (title == null || title.trim().length() == 0) {
            title = "null";
        }
        int tc = tabs.getTabCount();
        int occurrances = 0;
        HashSet<String> titles = new HashSet<String>();
        String tmp = null;
        for (int i = 0; i < tc; ++i) {
            tmp = tabs.getTitleAt(i).toLowerCase();
            titles.add(tmp);
            if (!tmp.startsWith(title.toLowerCase())) continue;
            ++occurrances;
        }
        if (titles.contains(title) && occurrances > 0) {
            title = title + occurrances;
        }
        COMPONENT_TITLES.put(comp, title);
        return title;
    }

    public boolean isSingleTabAllowed() {
        return this.getDockingProperties().isSingleTabsAllowed();
    }

    public void setSingleTabAllowed(boolean allowed) {
        this.getDockingProperties().setSingleTabsAllowed(allowed);
    }

    public boolean isParentDockingPort(Component comp) {
        if (comp == null) {
            return false;
        }
        Container parent = comp.getParent();
        if (parent == null) {
            return false;
        }
        if (parent == this) {
            return true;
        }
        return parent == this.getDockedComponent();
    }

    protected boolean isValidDockingRegion(String region) {
        return DockingManager.isValidDockingRegion(region);
    }

    private boolean isSingleComponentDocked() {
        Component c = this.getDockedComponent();
        if (c == null) {
            return false;
        }
        if (c instanceof JSplitPane) {
            return false;
        }
        if (c instanceof JTabbedPane) {
            return ((JTabbedPane)c).getTabCount() == 1;
        }
        return true;
    }

    protected Dockable getCenterDockable() {
        if (!this.isSingleComponentDocked()) {
            return null;
        }
        Component c = this.getDockedComponent();
        if (c instanceof JTabbedPane) {
            c = ((JTabbedPane)c).getComponent(0);
        }
        return DockingManager.getDockable(c);
    }

    private DockingPort[] putPortsInOrder(DockingPort oldPort, DockingPort newPort, String region) {
        if ("NORTH".equals(region) || "WEST".equals(region)) {
            return new DockingPort[]{newPort, oldPort};
        }
        return new DockingPort[]{oldPort, newPort};
    }

    private void reevaluateContainerTree() {
        this.reevaluateDockingWrapper();
        this.reevaluateTabbedPane();
        this.evaluateDockingBorderStatus();
    }

    private void reevaluateDockingWrapper() {
        Container grandParent;
        Component docked = this.getDockedComponent();
        Container parent = this.getParent();
        Container container = grandParent = parent == null ? null : parent.getParent();
        if (docked == null && parent instanceof JSplitPane && grandParent instanceof DefaultDockingPort) {
            parent.remove(this);
            ((DefaultDockingPort)grandParent).reevaluateContainerTree();
        } else if (docked instanceof JSplitPane) {
            JSplitPane wrapper = (JSplitPane)docked;
            Component left = wrapper.getLeftComponent();
            Component right = wrapper.getRightComponent();
            if (left != null && right != null) {
                return;
            }
            if (left == right) {
                this.removeAll();
                return;
            }
            Component comp = left == null ? right : left;
            wrapper.remove(comp);
            if (wrapper instanceof DockingSplitPane) {
                ((DockingSplitPane)wrapper).cleanup();
            }
            super.remove(wrapper);
            if (comp instanceof DefaultDockingPort) {
                comp = ((DefaultDockingPort)comp).getDockedComponent();
            }
            if (comp != null) {
                this.setComponent(comp);
            }
        }
    }

    private void reevaluateTabbedPane() {
        Container parent;
        Container grandParent;
        int minTabs;
        Component docked = this.getDockedComponent();
        if (!(docked instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabs = (JTabbedPane)docked;
        int tabCount = tabs.getTabCount();
        int n = minTabs = this.isSingleTabAllowed() ? 0 : 1;
        if (tabCount > minTabs) {
            return;
        }
        Component comp = tabCount == 1 ? tabs.getComponentAt(0) : null;
        this.removeAll();
        if (comp != null) {
            this.setComponent(comp);
        }
        Container container = grandParent = (parent = this.getParent()) == null ? null : parent.getParent();
        if (comp == null && parent instanceof JSplitPane && grandParent instanceof DefaultDockingPort) {
            parent.remove(this);
            ((DefaultDockingPort)grandParent).reevaluateContainerTree();
        }
    }

    public void remove(int index) {
        Component docked = this.getDockedComponent();
        Component comp = this.getComponent(index);
        super.remove(index);
        if (docked == comp) {
            this.dockedComponent = null;
        }
    }

    public void removeAll() {
        super.removeAll();
        this.dockedComponent = null;
    }

    public void setBorderManager(BorderManager mgr) {
        this.borderManager = mgr;
    }

    public BorderManager getBorderManager() {
        return this.borderManager;
    }

    private Component setComponent(Component c) {
        if (this.getDockedComponent() != null) {
            this.removeAll();
        }
        this.dockedComponent = c;
        Component ret = super.add(this.dockedComponent);
        this.doLayout();
        return ret;
    }

    public boolean undock(Component comp) {
        if (!this.isParentDockingPort(comp)) {
            return false;
        }
        comp.getParent().remove(comp);
        this.reevaluateContainerTree();
        return true;
    }

    public Set getDockables() {
        return this.getDockableSet(-1, 0, null);
    }

    protected Set getDockableSet(int depth, int level, Class desiredClass) {
        Component c = this.getDockedComponent();
        if (c instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)c;
            int len = tabs.getTabCount();
            HashSet<Object> set = new HashSet<Object>(len);
            for (int i = 0; i < len; ++i) {
                c = tabs.getComponentAt(i);
                if (!this.isValidDockableChild(c, desiredClass)) continue;
                if (c instanceof Dockable) {
                    set.add(c);
                    continue;
                }
                set.add(DockingManager.getDockable(c));
            }
            return set;
        }
        HashSet<Object> set = new HashSet<Object>(1);
        if (c instanceof JSplitPane && (depth < 0 || level <= depth)) {
            JSplitPane pane = (JSplitPane)c;
            Component sub1 = pane.getLeftComponent();
            Component sub2 = pane.getRightComponent();
            if (sub1 instanceof DefaultDockingPort) {
                set.addAll(((DefaultDockingPort)sub1).getDockableSet(depth, level + 1, desiredClass));
            }
            if (sub2 instanceof DefaultDockingPort) {
                set.addAll(((DefaultDockingPort)sub2).getDockableSet(depth, level + 1, desiredClass));
            }
        }
        if (this.isValidDockableChild(c, desiredClass)) {
            if (c instanceof Dockable) {
                set.add(c);
            } else {
                set.add(DockingManager.getDockable(c));
            }
        }
        return set;
    }

    protected boolean isValidDockableChild(Component c, Class desiredClass) {
        return desiredClass == null ? DockingManager.getDockable(c) != null : desiredClass.isAssignableFrom(c.getClass());
    }

    public void addDockingListener(DockingListener listener) {
        if (listener != null) {
            this.dockingListeners.add(listener);
        }
    }

    public DockingListener[] getDockingListeners() {
        return this.dockingListeners.toArray(new DockingListener[0]);
    }

    public void removeDockingListener(DockingListener listener) {
        if (listener != null) {
            this.dockingListeners.remove(listener);
        }
    }

    public void dockingCanceled(DockingEvent evt) {
    }

    public void dockingComplete(DockingEvent evt) {
        Dockable dockable = evt.getDockable();
        if (dockable == null || !this.isShowing() || evt.getNewDockingPort() != this) {
            return;
        }
        ActiveDockableTracker.requestDockableActivation(dockable.getComponent());
    }

    public void dragStarted(DockingEvent evt) {
    }

    public void dropStarted(DockingEvent evt) {
    }

    public void undockingComplete(DockingEvent evt) {
    }

    public void undockingStarted(DockingEvent evt) {
    }

    public DockingPortPropertySet getDockingProperties() {
        return PropertyManager.getDockingPortPropertySet(this);
    }

    public void setTabsAsDragSource(boolean enabled) {
        this.tabsAsDragSource = enabled;
    }

    public boolean isTabsAsDragSource() {
        return this.tabsAsDragSource;
    }

    protected int getInitTabPlacement() {
        return this.getDockingProperties().getTabPlacement();
    }

    public boolean isRoot() {
        return this.rootPort;
    }

    public void setRoot(boolean root) {
        this.rootPort = root;
    }

    public void setDragInProgress(boolean inProgress) {
        if (inProgress && this.dragImage != null) {
            return;
        }
        if (!inProgress && this.dragImage == null) {
            return;
        }
        this.dragImage = inProgress ? SwingUtility.createImage(this) : null;
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.dragImage == null) {
            super.paint(g);
            return;
        }
        g.drawImage(this.dragImage, 0, 0, this);
    }

    public LayoutNode exportLayout() {
        return DockingManager.getLayoutManager().createLayout(this);
    }

    public void importLayout(LayoutNode node) {
        if (!(node instanceof DockingPortNode)) {
            return;
        }
        node.setUserObject(this);
        ArrayList splitPaneResizeList = new ArrayList();
        this.constructLayout(node, splitPaneResizeList);
        this.deferSplitPaneValidation(splitPaneResizeList);
        this.revalidate();
    }

    private void constructLayout(LayoutNode node, ArrayList splitPaneResizeList) {
        Object obj = node.getUserObject();
        if (node instanceof SplitNode) {
            splitPaneResizeList.add(node);
        }
        Enumeration<? extends TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            LayoutNode child = (LayoutNode)en.nextElement();
            this.constructLayout(child, splitPaneResizeList);
        }
        if (node instanceof SplitNode) {
            this.reconstruct((SplitNode)node);
        } else if (node instanceof DockingPortNode) {
            this.reconstruct((DockingPortNode)node);
        }
    }

    private void reconstruct(DockingPortNode node) {
        DefaultDockingPort port = (DefaultDockingPort)node.getDockingPort();
        if (node.isSplit()) {
            SplitNode child = (SplitNode)node.getChildAt(0);
            JSplitPane split = child.getSplitPane();
            port.setComponent(split);
            port.evaluateDockingBorderStatus();
            return;
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            LayoutNode child = (LayoutNode)en.nextElement();
            if (!(child instanceof DockableNode)) continue;
            Dockable dockable = ((DockableNode)child).getDockable();
            port.dock(dockable, "CENTER");
        }
    }

    private void reconstruct(SplitNode node) {
        JSplitPane split = node.getSplitPane();
        Component left = node.getLeftComponent();
        Component right = node.getRightComponent();
        split.setLeftComponent(left);
        split.setRightComponent(right);
    }

    private void deferSplitPaneValidation(ArrayList splitNodes) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImportedSplitPaneValidation(ArrayList splitNodes) {
        Object object = this.lock;
        synchronized (object) {
            int size;
            int len = splitNodes.size();
            if (len == 0) {
                this.timer.stop();
                this.timer = null;
                return;
            }
            SplitNode node = (SplitNode)splitNodes.get(0);
            JSplitPane split = node.getSplitPane();
            int n = size = split.getOrientation() == 1 ? split.getWidth() : split.getHeight();
            if (!split.isValid() || size == 0) {
                if (!split.isValid()) {
                    split.validate();
                }
                return;
            }
            this.timer.stop();
            this.timer = null;
            for (int i = 0; i < len; ++i) {
                node = (SplitNode)splitNodes.get(i);
                split = node.getSplitPane();
                size = split.getOrientation() == 1 ? split.getWidth() : split.getHeight();
                float percent = node.getPercentage();
                split.setDividerLocation(percent);
                DockingPort port = DockingUtility.getParentDockingPort(split);
                if (port instanceof DefaultDockingPort) {
                    ((DefaultDockingPort)port).evaluateDockingBorderStatus();
                }
                split.validate();
            }
        }
    }

    public void installMaximizedDockable(Dockable dockable) {
        if (this.maximizationInstallInfo != null) {
            throw new IllegalStateException("Already maximized");
        }
        this.maximizationInstallInfo = new MaximizationInstallInfo(this.getDockedComponent(), this.getBorder());
        Component newComponent = dockable.getComponent();
        this.setComponent(newComponent);
        this.evaluateDockingBorderStatus();
        this.revalidate();
    }

    public void uninstallMaximizedDockable() {
        if (this.maximizationInstallInfo == null) {
            throw new IllegalStateException("No dockable maximized.");
        }
        this.setComponent(this.maximizationInstallInfo.getContent());
        this.setBorder(this.maximizationInstallInfo.getBorder());
        this.maximizationInstallInfo = null;
        this.revalidate();
    }

    public void releaseForMaximization(Dockable dockable) {
        if (this.maximizationReleaseInfo != null) {
            throw new IllegalStateException("Already released a Dockable for maximization.");
        }
        Component comp = dockable.getComponent();
        Border border = null;
        if (comp instanceof JComponent) {
            border = ((JComponent)comp).getBorder();
        }
        this.maximizationReleaseInfo = new MaximizationReleaseInfo(comp, border);
        Component docked = this.getDockedComponent();
        if (docked == null) {
            throw new IllegalStateException("DefaultDockingPort is empty.");
        }
        if (docked instanceof JSplitPane) {
            throw new IllegalStateException("DefaultDockingPort does not directly contain a Dockable");
        }
        if (docked instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)docked;
            this.maximizationReleaseInfo.setTabIndex(this.getTabIndex(tabs, comp));
            tabs.remove(comp);
        } else {
            if (comp != docked) {
                throw new IllegalStateException("Dockable requesting maximization is not the one docked in this DefaultDockingPort.");
            }
            this.remove(comp);
        }
    }

    private int getTabIndex(JTabbedPane tabs, Component comp) {
        int tabCount = tabs.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (tabs.getComponentAt(i) != comp) continue;
            return i;
        }
        return -1;
    }

    public void returnFromMaximization() {
        Component comp = this.maximizationReleaseInfo.getContent();
        if (comp instanceof JComponent) {
            ((JComponent)comp).setBorder(this.maximizationReleaseInfo.getBorder());
        }
        int tabIndex = this.maximizationReleaseInfo.getTabIndex();
        this.maximizationReleaseInfo = null;
        Component docked = this.getDockedComponent();
        if (docked != null && docked instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)docked;
            tabs.add(comp, this.getValidTabTitle(tabs, comp), tabIndex);
            tabs.setSelectedIndex(tabIndex);
        } else {
            this.setComponent(comp);
        }
        this.revalidate();
    }

    static {
        PropertyChangeListenerFactory.addFactory(new DockablePropertyChangeHandler.Factory());
    }

    private static class MaximizationReleaseInfo
    extends MaximizationInstallInfo {
        private int tabIndex;

        public MaximizationReleaseInfo(Component content, Border border) {
            super(content, border);
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public void setTabIndex(int tabIndex) {
            this.tabIndex = tabIndex;
        }
    }

    private static class MaximizationInstallInfo {
        private final Component content;
        private final Border border;

        public MaximizationInstallInfo(Component content, Border border) {
            this.content = content;
            this.border = border;
        }

        public Border getBorder() {
            return this.border;
        }

        public Component getContent() {
            return this.content;
        }
    }

    protected class PortLayout
    implements LayoutManager2,
    Serializable {
        protected PortLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets i = DefaultDockingPort.this.getInsets();
            Dimension dd = DefaultDockingPort.this.dockedComponent != null ? DefaultDockingPort.this.dockedComponent.getPreferredSize() : parent.getSize();
            return new Dimension(dd.width + i.left + i.right, dd.height + i.top + i.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets i = DefaultDockingPort.this.getInsets();
            Dimension dd = DefaultDockingPort.this.dockedComponent != null ? DefaultDockingPort.this.dockedComponent.getMinimumSize() : parent.getSize();
            return new Dimension(dd.width + i.left + i.right, dd.height + i.top + i.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            Insets i = DefaultDockingPort.this.getInsets();
            Dimension dd = DefaultDockingPort.this.dockedComponent != null ? DefaultDockingPort.this.dockedComponent.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - i.top - i.bottom);
            return new Dimension(dd.width + i.left + i.right, dd.height + i.top + i.bottom);
        }

        public void layoutContainer(Container parent) {
            Rectangle b = DefaultDockingPort.this.getBounds();
            Insets i = DefaultDockingPort.this.getInsets();
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (DefaultDockingPort.this.dockedComponent != null) {
                DefaultDockingPort.this.dockedComponent.setBounds(i.left, i.top, w, h);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }
}

