/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.console.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.scilab.modules.console.ConsoleConfiguration;
import org.scilab.modules.console.ConsoleOptions;
import org.scilab.modules.console.utils.ScilabSpecialTextUtilities;

public final class ScilabLaTeXViewer
extends JPanel {
    private static final int INSET = 3;
    private static final Rectangle NULLRECT = new Rectangle(0, 0, 0, 0);
    private static int defaultSize = 15;
    private static Icon icon;
    private static int width;
    private static int height;
    private static ScilabLaTeXViewer viewer;

    private ScilabLaTeXViewer() {
        super(false);
        ScilabLaTeXViewer.setDefaultSize(ConsoleOptions.getLaTeXFont().size);
    }

    public static void configurationChanged(ConsoleConfiguration.Conf conf) {
        if (conf.latex) {
            ScilabLaTeXViewer.setDefaultSize(ConsoleOptions.getLaTeXFont().size);
        }
    }

    public static void setDefaultSize(int n) {
        defaultSize = n;
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width + 6, height + 6);
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.drawRect(0, 0, width + 6 - 1, height + 6 - 1);
        icon.paintIcon(this, graphics, 3, 3);
    }

    public static void removeLaTeXViewer(JTextComponent jTextComponent) {
        if (icon != null) {
            icon = null;
            viewer.setVisible(false);
            jTextComponent.remove(viewer);
            jTextComponent.repaint();
        }
    }

    public static void displayExpressionIfVisible(JTextComponent jTextComponent, int n, String string, int n2, int n3) {
        if (viewer.isVisible()) {
            ScilabLaTeXViewer.displayExpression(jTextComponent, n, string, n2, n3);
        }
    }

    public static int displayExpression(JTextComponent jTextComponent, int n, String string, int n2, int n3) {
        int n4;
        int n5;
        Rectangle rectangle;
        Rectangle rectangle2;
        String string2 = string;
        if (string.startsWith("$") || string.startsWith("\"$") || string.startsWith("'$")) {
            int n6 = 1;
            if (string.charAt(0) != '$') {
                n6 = 2;
            }
            string2 = string.substring(n6, string.length() - n6);
        }
        if ((icon = ScilabSpecialTextUtilities.compilePartialLaTeXExpression(string2, defaultSize)) == null) {
            return 0;
        }
        width = icon.getIconWidth();
        height = icon.getIconHeight();
        viewer.setSize(width + 6, height + 6);
        jTextComponent.add(viewer);
        try {
            rectangle2 = jTextComponent.modelToView(n2);
            rectangle = jTextComponent.modelToView(n3);
        }
        catch (BadLocationException badLocationException) {
            rectangle2 = NULLRECT;
            rectangle = NULLRECT;
        }
        if (rectangle2.y == rectangle.y) {
            n5 = Math.max(1, (rectangle.x + rectangle2.x - width) / 2);
            n4 = rectangle2.y + rectangle2.height + 1;
            if (height + n4 > n) {
                n4 = rectangle2.y - 1 - height - 6;
            }
        } else if (rectangle2.y + rectangle2.height == rectangle.y) {
            n4 = rectangle.y + rectangle.height + 1;
            if (height + n4 > n) {
                n4 = rectangle2.y - 1 - height - 6;
                n5 = rectangle2.x;
            } else {
                n5 = rectangle.x;
            }
        } else {
            n5 = Math.max(1, (jTextComponent.getWidth() - width) / 2);
            n4 = rectangle.y + rectangle.height + 1;
            if (height + n4 > n) {
                n4 = rectangle2.y - 1 - height - 6;
            }
        }
        viewer.setLocation(n5, n4);
        viewer.setVisible(true);
        viewer.repaint();
        return height + 6;
    }

    static {
        viewer = new ScilabLaTeXViewer();
    }
}

