/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.rowheader;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class RowHeaderRenderer
extends JLabel
implements TableCellRenderer {
    private int index;
    private JTable table;
    private boolean rowModel;

    public RowHeaderRenderer(JTable jTable, boolean bl) {
        this.table = jTable;
        this.rowModel = bl;
        JTableHeader jTableHeader = jTable.getTableHeader();
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setHorizontalAlignment(0);
        this.setForeground(jTableHeader.getForeground());
        this.setBackground(jTableHeader.getBackground());
        this.setFont(jTableHeader.getFont());
        if (!bl) {
            this.setBorder(BorderFactory.createLineBorder(jTable.getGridColor().darker(), 1));
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        ListSelectionModel listSelectionModel = this.rowModel ? this.table.getSelectionModel() : this.table.getColumnModel().getSelectionModel();
        if (listSelectionModel.isSelectedIndex(this.index)) {
            Color color = UIManager.getColor("Table.selectionBackground");
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.setBackground(Color.getHSBColor(fArray[0], 1.0f, fArray[2]));
            this.setFont(jTableHeader.getFont().deriveFont(1));
            this.setForeground(UIManager.getColor("textHighlightText"));
        } else {
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
        }
        super.paintComponent(graphics);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.index = this.rowModel ? n : n2;
        this.setText(Integer.toString(this.index + 1));
        return this;
    }
}

