/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.rowheader;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class HeaderRenderer
extends JLabel
implements TableCellRenderer {
    private static final Insets INSETS = new Insets(1, 1, 1, 0);
    private int index;
    private JTable table;
    private boolean rowModel;
    private Font selectedFont;
    private Font unselectedFont;
    private Color selectedFgColor;
    private Color unselectedFgColor;
    private Color selectedBgColor;
    private Color unselectedBgColor;

    public HeaderRenderer(JTable jTable, boolean bl) {
        this.table = jTable;
        this.rowModel = bl;
        JTableHeader jTableHeader = jTable.getTableHeader();
        this.selectedFont = jTableHeader.getFont().deriveFont(1);
        this.unselectedFont = jTableHeader.getFont();
        this.selectedFgColor = UIManager.getColor("textHighlightText");
        this.unselectedFgColor = jTableHeader.getForeground();
        this.unselectedBgColor = jTableHeader.getBackground().darker();
        Color color = jTable.getSelectionBackground();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.selectedBgColor = Color.getHSBColor(fArray[0], fArray[1] * 2.0f, fArray[2]);
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setHorizontalAlignment(0);
        this.setForeground(this.unselectedFgColor);
        this.setBackground(this.unselectedBgColor);
        this.setFont(this.unselectedFont);
        if (!bl) {
            this.setBorder(new AbstractBorder(){

                @Override
                public Insets getBorderInsets(Component component) {
                    return INSETS;
                }

                @Override
                public Insets getBorderInsets(Component component, Insets insets) {
                    return INSETS;
                }

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(HeaderRenderer.this.table.getGridColor().darker());
                    graphics.drawLine(n, n2, n + n3, n2);
                    graphics.drawLine(n, n2, n, n2 + n4);
                }
            });
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        ListSelectionModel listSelectionModel = this.rowModel ? this.table.getSelectionModel() : this.table.getColumnModel().getSelectionModel();
        if (listSelectionModel.isSelectedIndex(this.index)) {
            this.setForeground(this.selectedFgColor);
            this.setBackground(this.selectedBgColor);
            this.setFont(this.selectedFont);
        } else {
            this.setForeground(this.unselectedFgColor);
            this.setBackground(this.unselectedBgColor);
            this.setFont(this.unselectedFont);
        }
        super.paintComponent(graphics);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.index = this.rowModel ? n : n2;
        this.setText(Integer.toString(this.index + 1));
        return this;
    }
}

