/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.graphicObject;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.CallBack;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.legend.Legend;
import org.scilab.modules.graphic_objects.uicontrol.frame.Frame;

public abstract class GraphicObject
implements Cloneable {
    public static final int USER_DATA_DEFAULT_SIZE = 0;
    private Integer identifier = 0;
    private Integer parent = 0;
    private List<Integer> children = new LinkedList<Integer>();
    private boolean visible = true;
    private boolean referenced = false;
    private boolean valid = true;
    private boolean hidden;
    private String tag = "";
    private CallBack callback = new CallBack("");
    private Integer selectedChild = 0;

    public GraphicObject clone() {
        GraphicObject graphicObject = null;
        try {
            graphicObject = (GraphicObject)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        graphicObject.setChildren(new LinkedList<Integer>());
        graphicObject.setParent(0);
        graphicObject.setSelectedChild(0);
        return graphicObject;
    }

    public abstract void accept(Visitor var1) throws ObjectRemovedException;

    public static Type getTypeFromName(int n) {
        switch (n) {
            case 0: {
                return Type.ARC;
            }
            case 1: {
                return Type.AXES;
            }
            case 2: {
                return Type.AXESMODEL;
            }
            case 3: {
                return Type.AXIS;
            }
            case 4: {
                return Type.CHAMP;
            }
            case 5: {
                return Type.COMPOUND;
            }
            case 6: {
                return Type.FAC3D;
            }
            case 7: {
                return Type.FEC;
            }
            case 8: {
                return Type.FIGURE;
            }
            case 9: {
                return Type.FIGUREMODEL;
            }
            case 10: {
                return Type.GRAYPLOT;
            }
            case 11: {
                return Type.LABEL;
            }
            case 12: {
                return Type.LEGEND;
            }
            case 13: {
                return Type.MATPLOT;
            }
            case 14: {
                return Type.PLOT3D;
            }
            case 15: {
                return Type.POLYLINE;
            }
            case 16: {
                return Type.RECTANGLE;
            }
            case 17: {
                return Type.SEGS;
            }
            case 18: {
                return Type.TEXT;
            }
            case 280: {
                return Type.CHECKBOX;
            }
            case 281: {
                return Type.EDIT;
            }
            case 282: {
                return Type.SPINNER;
            }
            case 283: {
                return Type.FRAME;
            }
            case 285: {
                return Type.IMAGE;
            }
            case 286: {
                return Type.LISTBOX;
            }
            case 287: {
                return Type.POPUPMENU;
            }
            case 288: {
                return Type.PUSHBUTTON;
            }
            case 289: {
                return Type.RADIOBUTTON;
            }
            case 290: {
                return Type.SLIDER;
            }
            case 291: {
                return Type.TABLE;
            }
            case 292: {
                return Type.UITEXT;
            }
            case 20: {
                return Type.UIMENU;
            }
            case 21: {
                return Type.UICONTEXTMENU;
            }
            case 335: {
                return Type.PROGRESSIONBAR;
            }
            case 334: {
                return Type.WAITBAR;
            }
            case 338: {
                return Type.DATATIP;
            }
            case 355: {
                return Type.LIGHT;
            }
            case 372: {
                return Type.TAB;
            }
            case 293: {
                return Type.LAYER;
            }
            case 386: {
                return Type.BORDER;
            }
            case 284: {
                return Type.FRAME_SCROLLABLE;
            }
            case 412: {
                return Type.BROWSER;
            }
        }
        return Type.UNKNOWNOBJECT;
    }

    public Object getPropertyFromName(int n) {
        switch (n) {
            case 24: {
                return GraphicObjectPropertyType.PARENT;
            }
            case 22: {
                return GraphicObjectPropertyType.CHILDREN;
            }
            case 23: {
                return GraphicObjectPropertyType.CHILDREN_COUNT;
            }
            case 28: {
                return GraphicObjectPropertyType.HIDDEN;
            }
            case 27: {
                return GraphicObjectPropertyType.VISIBLE;
            }
            case 78: {
                return GraphicObjectPropertyType.REFERENCED;
            }
            case 79: {
                return GraphicObjectPropertyType.VALID;
            }
            case 31: {
                return GraphicObjectPropertyType.PARENT_FIGURE;
            }
            case 32: {
                return GraphicObjectPropertyType.PARENT_AXES;
            }
            case 33: {
                return GraphicObjectPropertyType.HASLEGENDCHILD;
            }
            case 34: {
                return GraphicObjectPropertyType.LEGENDCHILD;
            }
            case 35: {
                return GraphicObjectPropertyType.SELECTEDCHILD;
            }
            case 29: {
                return GraphicObjectPropertyType.TYPE;
            }
            case 30: {
                return GraphicObjectPropertyType.DATA;
            }
            case 99: {
                return GraphicObjectPropertyType.TAG;
            }
            case 36: {
                return GraphicObjectPropertyType.CALLBACK;
            }
            case 37: {
                return GraphicObjectPropertyType.CALLBACKTYPE;
            }
        }
        return GraphicObjectPropertyType.UNKNOWNPROPERTY;
    }

    public Object getProperty(Object object) {
        if (!(object instanceof GraphicObjectPropertyType)) {
            return null;
        }
        GraphicObjectPropertyType graphicObjectPropertyType = (GraphicObjectPropertyType)((Object)object);
        switch (graphicObjectPropertyType) {
            case PARENT: {
                return this.getParent();
            }
            case CHILDREN: {
                return this.getChildren();
            }
            case CHILDREN_COUNT: {
                return this.children.size();
            }
            case VALID: {
                return this.isValid();
            }
            case HIDDEN: {
                return this.isHidden();
            }
            case VISIBLE: {
                return this.getVisible();
            }
            case PARENT_FIGURE: {
                return this.getParentFigure();
            }
            case PARENT_AXES: {
                return this.getParentAxes();
            }
            case HASLEGENDCHILD: {
                return this.getHasLegendChild();
            }
            case LEGENDCHILD: {
                return this.getLegendChild();
            }
            case SELECTEDCHILD: {
                return this.getSelectedChild();
            }
            case TYPE: {
                return this.getType();
            }
            case DATA: {
                return this.getIdentifier();
            }
            case TAG: {
                return this.getTag();
            }
            case CALLBACK: {
                return this.getCallbackString();
            }
            case CALLBACKTYPE: {
                return this.getCallbackType();
            }
            case UNKNOWNPROPERTY: {
                return null;
            }
        }
        return null;
    }

    public UpdateStatus setProperty(Object object, Object object2) {
        if (!(object instanceof GraphicObjectPropertyType)) {
            return UpdateStatus.Success;
        }
        GraphicObjectPropertyType graphicObjectPropertyType = (GraphicObjectPropertyType)((Object)object);
        switch (graphicObjectPropertyType) {
            case PARENT: {
                this.setParent((Integer)object2);
                break;
            }
            case CHILDREN: {
                this.setChildren((Integer[])object2);
                break;
            }
            case VALID: {
                this.setValid((Boolean)object2);
                break;
            }
            case HIDDEN: {
                this.setHidden((Boolean)object2);
                break;
            }
            case VISIBLE: {
                this.setVisible((Boolean)object2);
                break;
            }
            case SELECTEDCHILD: {
                this.setSelectedChild((Integer)object2);
                break;
            }
            case DATA: {
                return UpdateStatus.Success;
            }
            case TAG: {
                this.setTag((String)object2);
                break;
            }
            case CALLBACK: {
                this.setCallbackString((String)object2);
                break;
            }
            case CALLBACKTYPE: {
                this.setCallbackType((Integer)object2);
                break;
            }
            case UNKNOWNPROPERTY: {
                return UpdateStatus.Fail;
            }
            default: {
                return UpdateStatus.Success;
            }
        }
        return UpdateStatus.Success;
    }

    public Object getNullProperty(String string) {
        return null;
    }

    public Object getPropertyVoid(String string) {
        return null;
    }

    public void setPropertyVoid(String string, Object object) {
    }

    public Integer[] getChildren() {
        return this.children.toArray(new Integer[this.children.size()]);
    }

    public void addChild(Integer n) {
        this.children.add(0, n);
    }

    public void removeChild(Integer n) {
        this.children.remove(n);
    }

    private UpdateStatus setChildren(List<Integer> list) {
        this.children = list;
        return UpdateStatus.Success;
    }

    public UpdateStatus setChildren(Integer[] integerArray) {
        this.children = new LinkedList<Integer>(Arrays.asList(integerArray));
        return UpdateStatus.Success;
    }

    public Integer getIdentifier() {
        return this.identifier;
    }

    public UpdateStatus setIdentifier(Integer n) {
        this.identifier = n;
        return UpdateStatus.Success;
    }

    public Integer getParent() {
        return this.parent;
    }

    public UpdateStatus setParent(Integer n) {
        this.parent = n;
        return UpdateStatus.Success;
    }

    public String getTag() {
        return this.tag;
    }

    public UpdateStatus setTag(String string) {
        if (this.tag.equals(string)) {
            return UpdateStatus.NoChange;
        }
        this.tag = string;
        return UpdateStatus.Success;
    }

    public String getCallbackString() {
        return this.callback.getCommand();
    }

    public UpdateStatus setCallbackString(String string) {
        return this.callback.setCommand(string);
    }

    public Integer getCallbackType() {
        return this.callback.getCommandType();
    }

    public UpdateStatus setCallbackType(Integer n) {
        this.callback.setCommandType(n);
        return UpdateStatus.Success;
    }

    public Integer getParentFigure() {
        if (this instanceof Figure) {
            return this.getIdentifier();
        }
        if (this.getParent() != 0 && GraphicController.getController().getObjectFromId(this.getParent()) != null) {
            return GraphicController.getController().getObjectFromId(this.getParent()).getParentFigure();
        }
        return 0;
    }

    public Integer getParentFrameOrFigure() {
        if (this instanceof Figure || this instanceof Frame) {
            return this.getIdentifier();
        }
        if (this.getParent() != 0 && GraphicController.getController().getObjectFromId(this.getParent()) != null) {
            return GraphicController.getController().getObjectFromId(this.getParent()).getParentFrameOrFigure();
        }
        return 0;
    }

    public Integer getParentAxes() {
        if (this instanceof Axes) {
            return this.getIdentifier();
        }
        if (this.getParent() != 0 && GraphicController.getController().getObjectFromId(this.getParent()) != null) {
            return GraphicController.getController().getObjectFromId(this.getParent()).getParentAxes();
        }
        return 0;
    }

    public Boolean getHasLegendChild() {
        for (int i = 0; i < this.children.size(); ++i) {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(this.children.get(i));
            if (!(graphicObject instanceof Legend)) continue;
            return true;
        }
        return false;
    }

    public Integer getLegendChild() {
        for (int i = 0; i < this.children.size(); ++i) {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(this.children.get(i));
            if (!(graphicObject instanceof Legend)) continue;
            return graphicObject.getIdentifier();
        }
        return 0;
    }

    public Integer getSelectedChild() {
        return this.selectedChild;
    }

    public UpdateStatus setSelectedChild(Integer n) {
        this.selectedChild = n;
        return UpdateStatus.Success;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public UpdateStatus setVisible(Boolean bl) {
        if (this.visible == bl) {
            return UpdateStatus.NoChange;
        }
        this.visible = bl;
        return UpdateStatus.Success;
    }

    public abstract Integer getType();

    public Boolean isValid() {
        return this.valid;
    }

    public UpdateStatus setHidden(Boolean bl) {
        this.hidden = bl;
        return UpdateStatus.Success;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public UpdateStatus setValid(Boolean bl) {
        this.valid = bl;
        return UpdateStatus.Success;
    }

    public Boolean isReferenced() {
        return this.referenced;
    }

    public UpdateStatus setReferenced(Boolean bl) {
        this.referenced = bl;
        return UpdateStatus.Success;
    }

    public static enum UpdateStatus {
        Success,
        NoChange,
        Fail;

    }

    public static enum Type {
        ARC,
        AXES,
        AXESMODEL,
        AXIS,
        CHAMP,
        COMPOUND,
        FAC3D,
        FEC,
        FIGURE,
        FIGUREMODEL,
        GRAYPLOT,
        LABEL,
        LEGEND,
        MATPLOT,
        PLOT3D,
        POLYLINE,
        RECTANGLE,
        SEGS,
        TEXT,
        CHECKBOX,
        EDIT,
        SPINNER,
        FRAME,
        IMAGE,
        LISTBOX,
        POPUPMENU,
        PUSHBUTTON,
        RADIOBUTTON,
        CONSOLE,
        JAVACONSOLE,
        SLIDER,
        TABLE,
        UITEXT,
        UIMENU,
        UIMENUMODEL,
        PROGRESSIONBAR,
        WAITBAR,
        UICONTEXTMENU,
        DATATIP,
        LIGHT,
        TABGROUP,
        TAB,
        LAYER,
        BORDER,
        FRAME_SCROLLABLE,
        BROWSER,
        UNKNOWNOBJECT;

    }

    public static enum GraphicObjectPropertyType {
        PARENT,
        CHILDREN,
        CHILDREN_COUNT,
        HIDDEN,
        VISIBLE,
        TYPE,
        REFERENCED,
        VALID,
        DATA,
        PARENT_FIGURE,
        PARENT_AXES,
        HASLEGENDCHILD,
        LEGENDCHILD,
        SELECTEDCHILD,
        TAG,
        CALLBACK,
        CALLBACKTYPE,
        UNKNOWNPROPERTY;

    }
}

