/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.axes;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;

public class Camera {
    public static final double[] DEFAULT_ROTATION_ANGLES = new double[]{0.0, 270.0};
    private ViewType view;
    private boolean isoview;
    private boolean cubeScaling;
    private double[] rotationAngles;
    private double[] rotationAngles3d;

    public Camera() {
        this.view = ViewType.VIEW_2D;
        this.isoview = false;
        this.cubeScaling = false;
        this.rotationAngles = new double[2];
        this.rotationAngles3d = new double[2];
    }

    public Camera(Camera camera) {
        this.view = camera.view;
        this.isoview = camera.isoview;
        this.cubeScaling = camera.cubeScaling;
        this.rotationAngles = new double[2];
        this.rotationAngles[0] = camera.rotationAngles[0];
        this.rotationAngles[1] = camera.rotationAngles[1];
        this.rotationAngles3d = new double[2];
        this.rotationAngles3d[0] = camera.rotationAngles3d[0];
        this.rotationAngles3d[1] = camera.rotationAngles3d[1];
    }

    public boolean equals(Object object) {
        if (object instanceof Camera) {
            Camera camera = (Camera)object;
            return this.view == camera.view && this.isoview == camera.isoview && this.cubeScaling == camera.cubeScaling && this.rotationAngles[0] == camera.rotationAngles[0] && this.rotationAngles[1] == camera.rotationAngles[1] && this.rotationAngles3d[0] == camera.rotationAngles3d[0] && this.rotationAngles3d[1] == camera.rotationAngles3d[1];
        }
        return false;
    }

    public Boolean getCubeScaling() {
        return this.cubeScaling;
    }

    public GraphicObject.UpdateStatus setCubeScaling(Boolean bl) {
        if (this.cubeScaling != bl) {
            this.cubeScaling = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getIsoview() {
        return this.isoview;
    }

    public GraphicObject.UpdateStatus setIsoview(Boolean bl) {
        if (this.isoview != bl) {
            this.isoview = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getRotationAngles() {
        Double[] doubleArray = new Double[]{this.rotationAngles[0], this.rotationAngles[1]};
        return doubleArray;
    }

    public boolean setRotationAngles(Double[] doubleArray) {
        if (this.rotationAngles[0] != doubleArray[0] || this.rotationAngles[1] != doubleArray[1]) {
            if (doubleArray[0] == DEFAULT_ROTATION_ANGLES[0] && doubleArray[1] == DEFAULT_ROTATION_ANGLES[1]) {
                this.view = ViewType.VIEW_2D;
            } else if (this.view == ViewType.VIEW_2D) {
                this.view = ViewType.VIEW_3D;
            }
            this.rotationAngles[0] = doubleArray[0];
            this.rotationAngles[1] = doubleArray[1];
            return true;
        }
        return false;
    }

    public Double[] getRotationAngles3d() {
        Double[] doubleArray = new Double[]{this.rotationAngles3d[0], this.rotationAngles3d[1]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setRotationAngles3d(Double[] doubleArray) {
        if (this.rotationAngles3d[0] != doubleArray[0] || this.rotationAngles3d[1] != doubleArray[1]) {
            this.rotationAngles3d[0] = doubleArray[0];
            this.rotationAngles3d[1] = doubleArray[1];
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public ViewType getView() {
        return this.view;
    }

    public GraphicObject.UpdateStatus setView(ViewType viewType) {
        if (this.view != viewType) {
            if (viewType == ViewType.VIEW_2D) {
                this.rotationAngles3d[0] = this.rotationAngles[0];
                this.rotationAngles3d[1] = this.rotationAngles[1];
                this.rotationAngles[0] = DEFAULT_ROTATION_ANGLES[0];
                this.rotationAngles[1] = DEFAULT_ROTATION_ANGLES[1];
            } else if (viewType == ViewType.VIEW_3D && this.view == ViewType.VIEW_2D) {
                this.rotationAngles[0] = this.rotationAngles3d[0];
                this.rotationAngles[1] = this.rotationAngles3d[1];
            }
            this.view = viewType;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public static enum ViewType {
        VIEW_2D,
        VIEW_3D;


        public static ViewType intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return VIEW_2D;
                }
                case 1: {
                    return VIEW_3D;
                }
            }
            return null;
        }
    }

    public static enum CameraProperty {
        VIEW,
        ISOVIEW,
        CUBESCALING,
        ROTATIONANGLES,
        ROTATIONANGLES3D;

    }
}

