/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_export;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class ExportBitmap {
    private static final int MAX_ATTEMPT = 100;
    private static final int SLEEP_TIME = 10;

    public static final int writeFile(BufferedImage bufferedImage, String string, File file) {
        int n = 1;
        if (file.isFile() && file.canWrite()) {
            for (int i = 0; i < 100 && n != 0; ++i) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    boolean bl = ImageIO.write((RenderedImage)bufferedImage, string, fileOutputStream);
                    if (!bl) {
                        return 5;
                    }
                    fileOutputStream.close();
                    n = 0;
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                catch (IOException iOException) {
                    return n;
                }
            }
        }
        return n;
    }

    public static int writeJPEG(BufferedImage bufferedImage, float f, File file) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpeg");
        if (!iterator.hasNext()) {
            return 5;
        }
        ImageWriter imageWriter = iterator.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(f);
        FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
        imageWriter.setOutput(fileImageOutputStream);
        try {
            imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        }
        catch (IOException iOException) {
            return 5;
        }
        imageWriter.dispose();
        fileImageOutputStream.close();
        return 0;
    }
}

