/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.using_directives.custom;

import com.virtuslab.using_directives.custom.Scanner;
import com.virtuslab.using_directives.custom.TokenData;
import com.virtuslab.using_directives.custom.Tokens;
import com.virtuslab.using_directives.custom.utils.Source;
import com.virtuslab.using_directives.custom.utils.TokenUtils;
import com.virtuslab.using_directives.custom.utils.ast.BooleanLiteral;
import com.virtuslab.using_directives.custom.utils.ast.EmptyLiteral;
import com.virtuslab.using_directives.custom.utils.ast.StringLiteral;
import com.virtuslab.using_directives.custom.utils.ast.UsingDef;
import com.virtuslab.using_directives.custom.utils.ast.UsingDefs;
import com.virtuslab.using_directives.custom.utils.ast.UsingPrimitive;
import com.virtuslab.using_directives.custom.utils.ast.UsingValue;
import com.virtuslab.using_directives.custom.utils.ast.UsingValues;
import com.virtuslab.using_directives.reporter.Reporter;
import java.util.ArrayList;
import java.util.function.Supplier;

public class Parser {
    private Source source;
    private final Reporter reporter;
    Scanner in;

    public Parser(Source source, Reporter reporter) {
        this.reporter = reporter;
        this.source = source;
        this.in = new Scanner(source, 0, reporter);
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    private void error(String msg, int offset) {
        this.reporter.error(this.source.getPositionFromOffset(offset), msg);
    }

    private void error(String msg) {
        this.error(msg, this.offset(this.in.td.offset));
    }

    private int offset(int off) {
        return this.source.translateOffset(off);
    }

    public void accept(Tokens token) {
        if (this.in.td.token == token) {
            this.in.nextToken();
        } else {
            this.error(String.format("Expected token %s but found %s", token.str, this.in.td.token.str));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T enclosed(Tokens token, Supplier<T> callback) {
        this.accept(token);
        try {
            T t = callback.get();
            return t;
        }
        finally {
            this.accept(TokenUtils.tokenFromInt(token.ordinal() + 1));
        }
    }

    public <T> T inBracesOrIndented(Supplier<T> callback) {
        switch (this.in.td.token) {
            case INDENT: {
                return this.enclosed(Tokens.INDENT, callback);
            }
            case LBRACE: {
                return this.enclosed(Tokens.LBRACE, callback);
            }
        }
        this.error(String.format("Expected indent or braces but found %s", this.in.td.token.str));
        return callback.get();
    }

    public void newLineOptWhenFollowedBy(Tokens token) {
        if (this.in.td.token == Tokens.NEWLINE && this.in.next.token == token) {
            this.in.nextToken();
        }
    }

    public UsingDefs parse() {
        UsingDefs t = this.usingDirectives();
        return t;
    }

    UsingDefs usingDirectives() {
        ArrayList<UsingDef> usingTrees = new ArrayList<UsingDef>();
        int codeOffset = 0;
        UsingDef ud = this.usingDirective();
        int offset = this.offset(this.in.td.offset);
        while (ud != null) {
            usingTrees.add(ud);
            codeOffset = this.offset(this.in.td.lastOffset);
            TokenData tokenData = this.in.td;
            if (tokenData.isNewLine()) {
                this.in.nextToken();
            }
            if (tokenData.token != Tokens.EOF && !tokenData.isAfterLineEnd()) {
                this.error(String.format("Expected new line after the using directive, in the line; but found %s", tokenData.toTokenInfoString()));
                ud = null;
                continue;
            }
            ud = this.usingDirective();
        }
        return new UsingDefs(usingTrees, codeOffset, this.offset(this.in.td.offset), this.source.getPositionFromOffset(offset));
    }

    UsingDef usingDirective() {
        if (TokenUtils.isValidUsingDirectiveStart(this.in.td.token)) {
            this.in.nextToken();
            int offset = this.offset(this.in.td.offset);
            String key = this.key();
            if (key == null) {
                return null;
            }
            UsingValue value = this.value(offset + key.length());
            if (value == null) {
                return null;
            }
            return new UsingDef(key, value, this.source.getPositionFromOffset(offset));
        }
        return null;
    }

    String key() {
        if (this.in.td.token == Tokens.IDENTIFIER) {
            String key = this.in.td.name;
            this.in.nextToken();
            if (this.in.td.token == Tokens.DOT) {
                this.in.nextToken();
                return key + "." + this.key();
            }
            return key;
        }
        this.error(String.format("Expected identifier but found %s", this.in.td.token.str));
        return null;
    }

    UsingValue value(int keyEnd) {
        int offset = this.offset(this.in.td.offset);
        boolean isAfterLineEnd = this.in.td.isAfterLineEnd();
        UsingPrimitive p = this.primitive(keyEnd);
        if (p == null) {
            this.error(String.format("Invalid primitive: %s", this.in.td.token.str));
            return null;
        }
        if (isAfterLineEnd) {
            return new EmptyLiteral(this.source.getPositionFromOffset(keyEnd));
        }
        if (this.in.td.token != Tokens.EOF && !this.in.td.isAfterLineEnd()) {
            UsingValue rest;
            int commaIndex = this.in.td.offset;
            if (this.in.td.token == Tokens.COMMA) {
                this.in.nextToken();
            }
            if ((rest = this.value(commaIndex)) == null) {
                return null;
            }
            if (rest instanceof UsingPrimitive) {
                ArrayList<UsingPrimitive> res = new ArrayList<UsingPrimitive>();
                res.add(p);
                if (!(rest instanceof EmptyLiteral)) {
                    res.add((UsingPrimitive)rest);
                }
                return new UsingValues(res, this.source.getPositionFromOffset(offset));
            }
            ((UsingValues)rest).getValues().add(0, p);
            return rest;
        }
        return p;
    }

    UsingPrimitive primitive(int keyEnd) {
        int offset = this.offset(this.in.td.offset);
        UsingPrimitive res = null;
        if (this.in.td.token == Tokens.STRINGLIT) {
            res = new StringLiteral(this.in.td.strVal, this.source.getPositionFromOffset(offset), true);
            this.in.nextToken();
        } else if (this.in.td.token == Tokens.IDENTIFIER) {
            res = new StringLiteral(this.in.td.name, this.source.getPositionFromOffset(offset), false);
            this.in.nextToken();
        } else if (this.in.td.token == Tokens.TRUE) {
            res = new BooleanLiteral(true, this.source.getPositionFromOffset(offset));
            this.in.nextToken();
        } else if (this.in.td.token == Tokens.FALSE) {
            res = new BooleanLiteral(false, this.source.getPositionFromOffset(offset));
            this.in.nextToken();
        } else {
            res = this.in.td.token == Tokens.COMMA || this.in.td.token == Tokens.EOF || this.in.td.isAfterLineEnd() ? new EmptyLiteral(this.source.getPositionFromOffset(keyEnd)) : null;
        }
        return res;
    }
}

