/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.Path;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import scala.Function1;
import scala.runtime.LazyVals;
import scala.runtime.function.JProcedure1;

public class JarWriter {
    private static final VarHandle out$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(JarWriter.class, "out$lzy1", Object.class);
    private final File file;
    private final Manifest manifest;
    private volatile Object out$lzy1;

    public JarWriter(File file, Manifest manifest) {
        this.file = file;
        this.manifest = manifest;
    }

    public File file() {
        return this.file;
    }

    public Manifest manifest() {
        return this.manifest;
    }

    private JarOutputStream out() {
        Object object = this.out$lzy1;
        if (object instanceof JarOutputStream) {
            return (JarOutputStream)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JarOutputStream)this.out$lzyINIT1();
    }

    private Object out$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.out$lzy1) == null) {
                    if (!out$lzy1$lzyHandle.compareAndSet(this, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JarOutputStream jarOutputStream = null;
                    try {
                        jarOutputStream = new JarOutputStream(this.file().outputStream(this.file().outputStream$default$1()), this.manifest());
                        object2 = jarOutputStream == null ? LazyVals.NullValue$.MODULE$ : jarOutputStream;
                    }
                    finally {
                        if (!out$lzy1$lzyHandle.compareAndSet(this, LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.out$lzy1;
                            out$lzy1$lzyHandle.compareAndSet(this, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jarOutputStream;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    out$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DataOutputStream newOutputStream(String path) {
        JarEntry entry = new JarEntry(path);
        this.out().putNextEntry(entry);
        return new DataOutputStream(this.out());
    }

    public void writeAllFrom(Directory dir) {
        try {
            dir.list().foreach((Function1)(JProcedure1 & Serializable)x -> this.addEntry((Path)x, ""));
        }
        finally {
            this.out().close();
        }
    }

    public void addStream(JarEntry entry, InputStream in) {
        this.out().putNextEntry(entry);
        try {
            this.transfer(in, this.out());
        }
        finally {
            this.out().closeEntry();
        }
    }

    public void addFile(File file, String prefix) {
        JarEntry entry = new JarEntry(prefix + file.name());
        this.addStream(entry, file.inputStream());
    }

    public void addEntry(Path entry, String prefix) {
        if (entry.isFile()) {
            this.addFile(entry.toFile(), prefix);
            return;
        }
        this.addDirectory(entry.toDirectory(), prefix + entry.name() + "/");
    }

    public void addDirectory(Directory entry, String prefix) {
        entry.list().foreach((Function1)(JProcedure1 & Serializable)p -> this.addEntry((Path)p, prefix));
    }

    private void transfer(InputStream in, OutputStream out) {
        byte[] buf = new byte[10240];
        JarWriter.loop$1(in, buf, out);
    }

    public void close() {
        this.out().close();
    }

    private static final void loop$1(InputStream in$2, byte[] buf$1, OutputStream out$1) {
        while (true) {
            int n;
            if (-1 == (n = in$2.read(buf$1, 0, buf$1.length))) {
                in$2.close();
                return;
            }
            int n2 = n;
            out$1.write(buf$1, 0, n2);
        }
    }
}

