/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.concurrent;

import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.concurrent.BasicNode;
import scala.collection.concurrent.CNode;
import scala.collection.concurrent.INode;
import scala.collection.concurrent.KVNode;
import scala.collection.concurrent.LNode;
import scala.collection.concurrent.MainNode;
import scala.collection.concurrent.SNode;
import scala.collection.concurrent.TNode;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMapIterator$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;

public class TrieMapIterator<K, V>
extends AbstractIterator<Tuple2<K, V>> {
    private int level;
    private TrieMap<K, V> ct;
    private final BasicNode[][] stack;
    private final int[] stackpos;
    private int depth;
    private Iterator<Tuple2<K, V>> subiter;
    private KVNode<K, V> current;

    public static <K, V> boolean $lessinit$greater$default$3() {
        return TrieMapIterator$.MODULE$.$lessinit$greater$default$3();
    }

    public TrieMapIterator(int level, TrieMap<K, V> ct, boolean mustInit) {
        this.level = level;
        this.ct = ct;
        this.stack = new BasicNode[7][];
        this.stackpos = new int[7];
        this.depth = -1;
        this.subiter = null;
        this.current = null;
        if (mustInit) {
            this.initialize();
        }
    }

    public int level() {
        return this.level;
    }

    public void level_$eq(int x$1) {
        this.level = x$1;
    }

    private TrieMap<K, V> ct() {
        return this.ct;
    }

    private void ct_$eq(TrieMap<K, V> x$0) {
        this.ct = x$0;
    }

    private BasicNode[][] stack() {
        return this.stack;
    }

    private int[] stackpos() {
        return this.stackpos;
    }

    private int depth() {
        return this.depth;
    }

    private void depth_$eq(int x$0) {
        this.depth = x$0;
    }

    private Iterator<Tuple2<K, V>> subiter() {
        return this.subiter;
    }

    private void subiter_$eq(Iterator<Tuple2<K, V>> x$0) {
        this.subiter = x$0;
    }

    private KVNode<K, V> current() {
        return this.current;
    }

    private void current_$eq(KVNode<K, V> x$0) {
        this.current = x$0;
    }

    @Override
    public boolean hasNext() {
        return !(this.current() == null) || !(this.subiter() == null);
    }

    @Override
    public Tuple2<K, V> next() {
        if (!(this.subiter() == null)) {
            Tuple2<K, V> r = this.subiter().next();
            this.checkSubiter();
            return r;
        }
        if (!(this.current() == null)) {
            Tuple2<K, V> r = this.current().kvPair();
            this.advance();
            return r;
        }
        return (Tuple2)Iterator$.MODULE$.empty().next();
    }

    private void readin(INode<K, V> in) {
        MainNode<K, V> mainNode = in.gcasRead(this.ct());
        if (mainNode instanceof CNode) {
            CNode cNode;
            CNode cn = cNode = (CNode)mainNode;
            this.depth_$eq(this.depth() + 1);
            this.stack()[this.depth()] = cn.array();
            this.stackpos()[this.depth()] = -1;
            this.advance();
            return;
        }
        if (mainNode instanceof TNode) {
            TNode tNode;
            TNode tn = tNode = (TNode)mainNode;
            this.current_$eq(tn);
            return;
        }
        if (mainNode instanceof LNode) {
            LNode lNode;
            LNode ln = lNode = (LNode)mainNode;
            this.subiter_$eq(ln.entries().iterator());
            this.checkSubiter();
            return;
        }
        if (mainNode == null) {
            this.current_$eq(null);
            return;
        }
        MainNode<K, V> mainNode2 = mainNode;
        throw new MatchError(mainNode2);
    }

    private void checkSubiter() {
        Iterator<Tuple2<K, V>> x$proxy17 = this.subiter();
        if (x$proxy17 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        if (!x$proxy17.hasNext()) {
            this.subiter_$eq(null);
            this.advance();
            return;
        }
    }

    private void initialize() {
        if (!this.ct().isReadOnly()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        TrieMap<K, V> trieMap = this.ct();
        INode<K, V> r = trieMap.RDCSS_READ_ROOT(trieMap.RDCSS_READ_ROOT$default$1());
        this.readin(r);
    }

    public final void advance() {
        while (this.depth() >= 0) {
            int npos = this.stackpos()[this.depth()] + 1;
            if (npos < this.stack()[this.depth()].length) {
                this.stackpos()[this.depth()] = npos;
                BasicNode basicNode = this.stack()[this.depth()][npos];
                if (basicNode instanceof SNode) {
                    SNode sNode;
                    SNode sn = sNode = (SNode)basicNode;
                    this.current_$eq(sn);
                    return;
                }
                if (basicNode instanceof INode) {
                    INode iNode;
                    INode in = iNode = (INode)basicNode;
                    this.readin(in);
                    return;
                }
                BasicNode basicNode2 = basicNode;
                throw new MatchError(basicNode2);
            }
            this.depth_$eq(this.depth() - 1);
        }
        this.current_$eq(null);
    }

    public TrieMapIterator<K, V> newIterator(int _lev, TrieMap<K, V> _ct, boolean _mustInit) {
        return new TrieMapIterator<K, V>(_lev, _ct, _mustInit);
    }

    public void dupTo(TrieMapIterator<K, V> it) {
        it.level_$eq(this.level());
        super.ct_$eq(this.ct());
        super.depth_$eq(this.depth());
        super.current_$eq(this.current());
        Array$.MODULE$.copy(this.stack(), 0, super.stack(), 0, 7);
        Array$.MODULE$.copy(this.stackpos(), 0, super.stackpos(), 0, 7);
        if (this.subiter() == null) {
            super.subiter_$eq(null);
            return;
        }
        List lst = (List)this.subiter().to(IterableFactory$.MODULE$.toFactory(List$.MODULE$));
        this.subiter_$eq(lst.iterator());
        super.subiter_$eq(lst.iterator());
    }

    public Seq<Iterator<Tuple2<K, V>>> subdivide() {
        if (!(this.subiter() == null)) {
            TrieMapIterator<K, V> it = this.newIterator(this.level() + 1, this.ct(), false);
            super.depth_$eq(-1);
            super.subiter_$eq(this.subiter());
            super.current_$eq(null);
            this.subiter_$eq(null);
            this.advance();
            this.level_$eq(this.level() + 1);
            return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)it), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this), Nil$.MODULE$)));
        }
        if (this.depth() == -1) {
            this.level_$eq(this.level() + 1);
            return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)this), Nil$.MODULE$));
        }
        for (int d = 0; d <= this.depth(); ++d) {
            Tuple2<Object, Object> tuple2;
            Tuple2<Object, Object> $7$;
            int rem = this.stack()[d].length - 1 - this.stackpos()[d];
            if (rem <= 0) continue;
            Object object = Predef$.MODULE$.refArrayOps(this.stack()[d]);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(object, this.stackpos()[d] + 1));
            Tuple2<Object, Object> tuple22 = $7$ = (tuple2 = ArrayOps$.MODULE$.splitAt$extension(object2, rem / 2));
            BasicNode[] arr1 = (BasicNode[])tuple22._1();
            BasicNode[] arr2 = (BasicNode[])tuple22._2();
            this.stack()[d] = arr1;
            this.stackpos()[d] = -1;
            TrieMapIterator<K, V> it = this.newIterator(this.level() + 1, this.ct(), false);
            super.stack()[0] = arr2;
            super.stackpos()[0] = -1;
            super.depth_$eq(0);
            it.advance();
            this.level_$eq(this.level() + 1);
            return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)this), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)it), Nil$.MODULE$)));
        }
        this.level_$eq(this.level() + 1);
        return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)this), Nil$.MODULE$));
    }
}

