/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractIterable;
import scala.collection.AbstractIterator;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Integral;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface Iterator<A>
extends IterableOnce<A>,
IterableOnceOps<A, Iterator, Iterator<A>> {
    public static <A> Iterator<A> apply(Seq<A> seq) {
        return Iterator$.MODULE$.apply((Seq)seq);
    }

    public static /* synthetic */ Object apply(Seq seq) {
        return Iterator$.MODULE$.apply(seq);
    }

    public static <A> Iterator<A> continually(Function0<A> function0) {
        return Iterator$.MODULE$.continually(function0);
    }

    public static <T> Iterator<T> empty() {
        return Iterator$.MODULE$.empty();
    }

    public static <A> Iterator<A> fill(int n, Function0<A> function0) {
        return Iterator$.MODULE$.fill(n, (Function0)function0);
    }

    public static /* synthetic */ Object fill(int n, Function0 function0) {
        return Iterator$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return Iterator$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return Iterator$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return Iterator$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return Iterator$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static Iterator<Object> from(int n) {
        return Iterator$.MODULE$.from(n);
    }

    public static Iterator<Object> from(int n, int n2) {
        return Iterator$.MODULE$.from(n, n2);
    }

    public static <A> Iterator<A> from(IterableOnce<A> iterableOnce) {
        return Iterator$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static <A> Factory<A, Iterator<A>> iterableFactory() {
        return Iterator$.MODULE$.iterableFactory();
    }

    public static <T> Iterator<T> iterate(T t, Function1<T, T> function1) {
        return Iterator$.MODULE$.iterate(t, function1);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return Iterator$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, Iterator<A>> newBuilder() {
        return Iterator$.MODULE$.newBuilder();
    }

    public static Iterator<Object> range(int n, int n2) {
        return Iterator$.MODULE$.range(n, n2);
    }

    public static Iterator<Object> range(int n, int n2, int n3) {
        return Iterator$.MODULE$.range(n, n2, n3);
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return Iterator$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return Iterator$.MODULE$.range(object, object2, object3, integral);
    }

    public static <A> Iterator<A> single(A a) {
        return Iterator$.MODULE$.single(a);
    }

    public static <A> Iterator<A> tabulate(int n, Function1<Object, A> function1) {
        return Iterator$.MODULE$.tabulate(n, (Function1)function1);
    }

    public static /* synthetic */ Object tabulate(int n, Function1 function1) {
        return Iterator$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return Iterator$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return Iterator$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return Iterator$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return Iterator$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static <A, S> Iterator<A> unfold(S s, Function1<S, Option<Tuple2<A, S>>> function1) {
        return Iterator$.MODULE$.unfold((Object)s, (Function1)function1);
    }

    public static /* synthetic */ Object unfold(Object object, Function1 function1) {
        return Iterator$.MODULE$.unfold(object, function1);
    }

    public static void $init$(Iterator $this) {
    }

    public boolean hasNext();

    public static boolean hasDefiniteSize$(Iterator $this) {
        return $this.hasDefiniteSize();
    }

    @Override
    default public boolean hasDefiniteSize() {
        return this.isEmpty();
    }

    public A next() throws NoSuchElementException;

    public static Iterator iterator$(Iterator $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<A> iterator() {
        return this;
    }

    public static Option nextOption$(Iterator $this) {
        return $this.nextOption();
    }

    default public Option<A> nextOption() {
        if (this.hasNext()) {
            return Some$.MODULE$.apply(this.next());
        }
        return None$.MODULE$;
    }

    public static boolean contains$(Iterator $this, Object elem) {
        return $this.contains(elem);
    }

    default public boolean contains(Object elem) {
        return this.exists((Function1<Object, Boolean> & Serializable)_$1 -> BoxesRunTime.equals(_$1, elem));
    }

    public static BufferedIterator buffered$(Iterator $this) {
        return $this.buffered();
    }

    default public BufferedIterator<A> buffered() {
        return new BufferedIterator<A>(this){
            private Object hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                BufferedIterator.$init$(this);
                this.hdDefined = false;
            }

            public Option headOption() {
                return BufferedIterator.headOption$(this);
            }

            public BufferedIterator buffered() {
                return BufferedIterator.buffered$(this);
            }

            public Object head() {
                if (!this.hdDefined) {
                    this.hd = this.next();
                    this.hdDefined = true;
                }
                return this.hd;
            }

            public int knownSize() {
                int thisSize = this.$outer.knownSize();
                if (thisSize >= 0 && this.hdDefined) {
                    return thisSize + 1;
                }
                return thisSize;
            }

            public boolean hasNext() {
                return this.hdDefined || this.$outer.hasNext();
            }

            public Object next() {
                if (this.hdDefined) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return this.$outer.next();
            }
        };
    }

    public static Iterator padTo$(Iterator $this, int len, Object elem) {
        return $this.padTo(len, elem);
    }

    default public <B> Iterator<B> padTo(int len, B elem) {
        return new AbstractIterator<B>(len, elem, this){
            private final int len$1;
            private final Object elem$2;
            private int i;
            private final /* synthetic */ Iterator $outer;
            {
                this.len$1 = len$3;
                this.elem$2 = elem$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i = 0;
            }

            public int knownSize() {
                int thisSize = this.$outer.knownSize();
                if (thisSize < 0) {
                    return -1;
                }
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(thisSize), this.len$1 - this.i);
            }

            public Object next() {
                A b = this.$outer.hasNext() ? this.$outer.next() : (this.i < this.len$1 ? this.elem$2 : Iterator$.MODULE$.empty().next());
                ++this.i;
                return b;
            }

            public boolean hasNext() {
                return this.$outer.hasNext() || this.i < this.len$1;
            }
        };
    }

    public static Tuple2 partition$(Iterator $this, Function1 p) {
        return $this.partition(p);
    }

    default public Tuple2<Iterator<A>, Iterator<A>> partition(Function1<A, Object> p) {
        Tuple2<Iterator<A>, Iterator<A>> tuple2;
        Tuple2<Iterator<A>, Iterator<A>> $1$;
        Tuple2<Iterator<A>, Iterator<A>> tuple22 = $1$ = (tuple2 = this.duplicate());
        Iterator<A> a = tuple22._1();
        Iterator<A> b = tuple22._2();
        return Tuple2$.MODULE$.apply(a.filter(p), b.filterNot(p));
    }

    public static GroupedIterator grouped$(Iterator $this, int size) {
        return $this.grouped(size);
    }

    default public <B> GroupedIterator<B> grouped(int size) {
        return new GroupedIterator(this, this, size, size);
    }

    public static GroupedIterator sliding$(Iterator $this, int size, int step) {
        return $this.sliding(size, step);
    }

    default public <B> GroupedIterator<B> sliding(int size, int step) {
        return new GroupedIterator(this, this, size, step);
    }

    public static int sliding$default$2$(Iterator $this) {
        return $this.sliding$default$2();
    }

    default public int sliding$default$2() {
        return 1;
    }

    public static Iterator scanLeft$(Iterator $this, Object z, Function2 op) {
        return $this.scanLeft(z, op);
    }

    @Override
    default public <B> Iterator<B> scanLeft(B z, Function2<B, A, B> op) {
        return new AbstractIterator<B>(z, op, this){
            public Iterator scala$collection$Iterator$$anon$3$$current;
            private final /* synthetic */ Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.scala$collection$Iterator$$anon$3$$current = new AbstractIterator<B>(z$1, op$1, this){
                    private final Object z$2;
                    public final Function2 scala$collection$Iterator$$anon$4$$op$2;
                    private final /* synthetic */ $anon$3 $outer;
                    {
                        this.z$2 = z$4;
                        this.scala$collection$Iterator$$anon$4$$op$2 = op$3;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public int knownSize() {
                        int thisSize = this.$outer.scala$collection$Iterator$_$$anon$$$outer().knownSize();
                        if (thisSize < 0) {
                            return -1;
                        }
                        return thisSize + 1;
                    }

                    public boolean hasNext() {
                        return true;
                    }

                    public Object next() {
                        this.$outer.scala$collection$Iterator$$anon$3$$current = new AbstractIterator<B>(this.z$2, this){
                            private Object acc;
                            private final /* synthetic */ $anon$4 $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.acc = z$3;
                            }

                            public Object next() {
                                this.acc = this.$outer.scala$collection$Iterator$$anon$4$$op$2.apply(this.acc, this.$outer.scala$collection$Iterator$_$$anon$_$$anon$$$outer().scala$collection$Iterator$_$$anon$$$outer().next());
                                return this.acc;
                            }

                            public boolean hasNext() {
                                return this.$outer.scala$collection$Iterator$_$$anon$_$$anon$$$outer().scala$collection$Iterator$_$$anon$$$outer().hasNext();
                            }

                            public int knownSize() {
                                return this.$outer.scala$collection$Iterator$_$$anon$_$$anon$$$outer().scala$collection$Iterator$_$$anon$$$outer().knownSize();
                            }
                        };
                        return this.z$2;
                    }

                    public final /* synthetic */ $anon$3 scala$collection$Iterator$_$$anon$_$$anon$$$outer() {
                        return this.$outer;
                    }
                };
            }

            public int knownSize() {
                return this.scala$collection$Iterator$$anon$3$$current.knownSize();
            }

            public Object next() {
                return this.scala$collection$Iterator$$anon$3$$current.next();
            }

            public boolean hasNext() {
                return this.scala$collection$Iterator$$anon$3$$current.hasNext();
            }

            public final /* synthetic */ Iterator scala$collection$Iterator$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }

    public static Iterator scanRight$(Iterator $this, Object z, Function2 op) {
        return $this.scanRight(z, op);
    }

    default public <B> Iterator<B> scanRight(B z, Function2<A, B, B> op) {
        return ((IndexedSeqOps)((AbstractIterable)ArrayBuffer$.MODULE$.from((IterableOnce)this)).scanRight((Object)z, (Function2)op)).iterator();
    }

    public static int indexWhere$(Iterator $this, Function1 p, int from) {
        return $this.indexWhere(p, from);
    }

    default public int indexWhere(Function1<A, Object> p, int from) {
        int i = package$.MODULE$.max(from, 0);
        Iterator<A> dropped = this.drop(from);
        while (dropped.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(dropped.next()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexWhere$default$2$(Iterator $this) {
        return $this.indexWhere$default$2();
    }

    default public int indexWhere$default$2() {
        return 0;
    }

    public static int indexOf$(Iterator $this, Object elem) {
        return $this.indexOf(elem);
    }

    default public <B> int indexOf(B elem) {
        return this.indexOf(elem, 0);
    }

    public static int indexOf$(Iterator $this, Object elem, int from) {
        return $this.indexOf(elem, from);
    }

    default public <B> int indexOf(B elem, int from) {
        int i;
        for (i = 0; i < from && this.hasNext(); ++i) {
            this.next();
        }
        while (this.hasNext()) {
            if (BoxesRunTime.equals(this.next(), elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int length$(Iterator $this) {
        return $this.length();
    }

    default public int length() {
        return this.size();
    }

    public static boolean isEmpty$(Iterator $this) {
        return $this.isEmpty();
    }

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    public static Iterator filter$(Iterator $this, Function1 p) {
        return $this.filter(p);
    }

    @Override
    default public Iterator<A> filter(Function1<A, Object> p) {
        return this.filterImpl(p, false);
    }

    public static Iterator filterNot$(Iterator $this, Function1 p) {
        return $this.filterNot(p);
    }

    @Override
    default public Iterator<A> filterNot(Function1<A, Object> p) {
        return this.filterImpl(p, true);
    }

    public static Iterator filterImpl$(Iterator $this, Function1 p, boolean isFlipped) {
        return $this.filterImpl(p, isFlipped);
    }

    default public Iterator<A> filterImpl(Function1<A, Object> p, boolean isFlipped) {
        return new AbstractIterator<A>(p, isFlipped, this){
            private final Function1 p$1;
            private final boolean isFlipped$1;
            private Object hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;
            {
                this.p$1 = p$5;
                this.isFlipped$1 = isFlipped$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hdDefined = false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.hdDefined) return true;
                if (!this.$outer.hasNext()) {
                    return false;
                }
                this.hd = this.$outer.next();
                while (BoxesRunTime.unboxToBoolean(this.p$1.apply(this.hd)) == this.isFlipped$1) {
                    if (!this.$outer.hasNext()) {
                        return false;
                    }
                    this.hd = this.$outer.next();
                }
                this.hdDefined = true;
                if (!true) return false;
                return true;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return Iterator$.MODULE$.empty().next();
            }
        };
    }

    public static Iterator withFilter$(Iterator $this, Function1 p) {
        return $this.withFilter(p);
    }

    default public Iterator<A> withFilter(Function1<A, Object> p) {
        return this.filter(p);
    }

    public static Iterator collect$(Iterator $this, PartialFunction pf) {
        return $this.collect(pf);
    }

    @Override
    default public <B> Iterator<B> collect(PartialFunction<A, B> pf) {
        return new Function1<A, B>(pf, this){
            private final PartialFunction pf$1;
            private Object hd;
            private int status;
            private final /* synthetic */ Iterator $outer;
            {
                this.pf$1 = pf$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.status = 0;
            }

            public Function1 compose(Function1 g) {
                return Function1.compose$(this, g);
            }

            public Function1 andThen(Function1 g) {
                return Function1.andThen$(this, g);
            }

            public String toString() {
                return Function1.toString$(this);
            }

            public void apply$mcVI$sp(int x$0) {
                Function1.apply$mcVI$sp$(this, x$0);
            }

            public void apply$mcVJ$sp(long x$0) {
                Function1.apply$mcVJ$sp$(this, x$0);
            }

            public void apply$mcVF$sp(float x$0) {
                Function1.apply$mcVF$sp$(this, x$0);
            }

            public void apply$mcVD$sp(double x$0) {
                Function1.apply$mcVD$sp$(this, x$0);
            }

            public boolean apply$mcZI$sp(int x$0) {
                return Function1.apply$mcZI$sp$(this, x$0);
            }

            public boolean apply$mcZJ$sp(long x$0) {
                return Function1.apply$mcZJ$sp$(this, x$0);
            }

            public boolean apply$mcZF$sp(float x$0) {
                return Function1.apply$mcZF$sp$(this, x$0);
            }

            public boolean apply$mcZD$sp(double x$0) {
                return Function1.apply$mcZD$sp$(this, x$0);
            }

            public int apply$mcII$sp(int x$0) {
                return Function1.apply$mcII$sp$(this, x$0);
            }

            public int apply$mcIJ$sp(long x$0) {
                return Function1.apply$mcIJ$sp$(this, x$0);
            }

            public int apply$mcIF$sp(float x$0) {
                return Function1.apply$mcIF$sp$(this, x$0);
            }

            public int apply$mcID$sp(double x$0) {
                return Function1.apply$mcID$sp$(this, x$0);
            }

            public float apply$mcFI$sp(int x$0) {
                return Function1.apply$mcFI$sp$(this, x$0);
            }

            public float apply$mcFJ$sp(long x$0) {
                return Function1.apply$mcFJ$sp$(this, x$0);
            }

            public float apply$mcFF$sp(float x$0) {
                return Function1.apply$mcFF$sp$(this, x$0);
            }

            public float apply$mcFD$sp(double x$0) {
                return Function1.apply$mcFD$sp$(this, x$0);
            }

            public long apply$mcJI$sp(int x$0) {
                return Function1.apply$mcJI$sp$(this, x$0);
            }

            public long apply$mcJJ$sp(long x$0) {
                return Function1.apply$mcJJ$sp$(this, x$0);
            }

            public long apply$mcJF$sp(float x$0) {
                return Function1.apply$mcJF$sp$(this, x$0);
            }

            public long apply$mcJD$sp(double x$0) {
                return Function1.apply$mcJD$sp$(this, x$0);
            }

            public double apply$mcDI$sp(int x$0) {
                return Function1.apply$mcDI$sp$(this, x$0);
            }

            public double apply$mcDJ$sp(long x$0) {
                return Function1.apply$mcDJ$sp$(this, x$0);
            }

            public double apply$mcDF$sp(float x$0) {
                return Function1.apply$mcDF$sp$(this, x$0);
            }

            public double apply$mcDD$sp(double x$0) {
                return Function1.apply$mcDD$sp$(this, x$0);
            }

            public Object apply(Object value) {
                return Statics.pfMarker;
            }

            public boolean hasNext() {
                Object marker = Statics.pfMarker;
                while (this.status == 0) {
                    if (this.$outer.hasNext()) {
                        A x = this.$outer.next();
                        B1 v = this.pf$1.applyOrElse(x, this);
                        if (marker == v) continue;
                        this.hd = v;
                        this.status = 1;
                        continue;
                    }
                    this.status = -1;
                }
                return this.status == 1;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.status = 0;
                    return this.hd;
                }
                return Iterator$.MODULE$.empty().next();
            }
        };
    }

    public static Iterator distinct$(Iterator $this) {
        return $this.distinct();
    }

    default public Iterator<A> distinct() {
        return this.distinctBy((Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    public static Iterator distinctBy$(Iterator $this, Function1 f) {
        return $this.distinctBy(f);
    }

    default public <B> Iterator<A> distinctBy(Function1<A, B> f) {
        return new AbstractIterator<A>(f, this){
            private final Function1 f$1;
            private final HashSet traversedValues;
            private boolean nextElementDefined;
            private Object nextElement;
            private final /* synthetic */ Iterator $outer;
            {
                this.f$1 = f$8;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.traversedValues = HashSet$.MODULE$.empty();
                this.nextElementDefined = false;
            }

            public boolean hasNext() {
                boolean bl;
                block2: {
                    block1: {
                        while (!this.nextElementDefined) {
                            if (!this.$outer.hasNext()) break block1;
                            A a = this.$outer.next();
                            if (!this.traversedValues.add(this.f$1.apply(a))) continue;
                            this.nextElement = a;
                            this.nextElementDefined = true;
                            if (!true) break block1;
                        }
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return bl;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.nextElementDefined = false;
                    return this.nextElement;
                }
                return Iterator$.MODULE$.empty().next();
            }
        };
    }

    public static Iterator map$(Iterator $this, Function1 f) {
        return $this.map(f);
    }

    @Override
    default public <B> Iterator<B> map(Function1<A, B> f) {
        return new AbstractIterator<B>(f, this){
            private final Function1 f$2;
            private final /* synthetic */ Iterator $outer;
            {
                this.f$2 = f$9;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int knownSize() {
                return this.$outer.knownSize();
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public Object next() {
                return this.f$2.apply(this.$outer.next());
            }
        };
    }

    public static Iterator flatMap$(Iterator $this, Function1 f) {
        return $this.flatMap(f);
    }

    @Override
    default public <B> Iterator<B> flatMap(Function1<A, IterableOnce<B>> f) {
        return new AbstractIterator<B>(f, this){
            private final Function1 f$3;
            private Iterator cur;
            private int _hasNext;
            private final /* synthetic */ Iterator $outer;
            {
                this.f$3 = f$10;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.cur = Iterator$.MODULE$.empty();
                this._hasNext = -1;
            }

            public void nextCur() {
                this.cur = Iterator$.MODULE$.empty();
                this.cur = ((IterableOnce)this.f$3.apply(this.$outer.next())).iterator();
                this._hasNext = -1;
            }

            public boolean hasNext() {
                if (this._hasNext == -1) {
                    while (!this.cur.hasNext()) {
                        if (!this.$outer.hasNext()) {
                            this._hasNext = 0;
                            this.cur = Iterator$.MODULE$.empty();
                            return false;
                        }
                        this.nextCur();
                    }
                    this._hasNext = 1;
                    return true;
                }
                return this._hasNext == 1;
            }

            public Object next() {
                if (this.hasNext()) {
                    this._hasNext = -1;
                }
                return this.cur.next();
            }
        };
    }

    public static Iterator flatten$(Iterator $this, Function1 ev) {
        return $this.flatten(ev);
    }

    @Override
    default public <B> Iterator<B> flatten(Function1<A, IterableOnce<B>> ev) {
        return this.flatMap(ev);
    }

    public static Iterator concat$(Iterator $this, Function0 xs) {
        return $this.concat(xs);
    }

    default public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
        return new ConcatIterator(this).concat(xs);
    }

    public static Iterator $plus$plus$(Iterator $this, Function0 xs) {
        return $this.$plus$plus(xs);
    }

    default public <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
        return this.concat(xs);
    }

    public static Iterator take$(Iterator $this, int n) {
        return $this.take(n);
    }

    @Override
    default public Iterator<A> take(int n) {
        return this.sliceIterator(0, RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(n), 0));
    }

    public static Iterator takeWhile$(Iterator $this, Function1 p) {
        return $this.takeWhile(p);
    }

    @Override
    default public Iterator<A> takeWhile(Function1<A, Object> p) {
        return new AbstractIterator<A>(p, this){
            private final Function1 p$2;
            private Object hd;
            private boolean hdDefined;
            private Iterator tail;
            {
                this.p$2 = p$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.hdDefined = false;
                this.tail = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.hdDefined) return true;
                if (!this.tail.hasNext()) return false;
                this.hd = this.tail.next();
                if (BoxesRunTime.unboxToBoolean(this.p$2.apply(this.hd))) {
                    this.hdDefined = true;
                } else {
                    this.tail = Iterator$.MODULE$.empty();
                }
                if (!this.hdDefined) return false;
                return true;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return Iterator$.MODULE$.empty().next();
            }
        };
    }

    public static Iterator drop$(Iterator $this, int n) {
        return $this.drop(n);
    }

    @Override
    default public Iterator<A> drop(int n) {
        return this.sliceIterator(n, -1);
    }

    public static Iterator dropWhile$(Iterator $this, Function1 p) {
        return $this.dropWhile(p);
    }

    @Override
    default public Iterator<A> dropWhile(Function1<A, Object> p) {
        return new AbstractIterator<A>(p, this){
            private final Function1 p$3;
            private int status;
            private Object fst;
            private final /* synthetic */ Iterator $outer;
            {
                this.p$3 = p$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.status = -1;
            }

            public boolean hasNext() {
                if (this.status == 1) {
                    return this.$outer.hasNext();
                }
                if (this.status == 0) {
                    return true;
                }
                while (this.$outer.hasNext()) {
                    A a = this.$outer.next();
                    if (BoxesRunTime.unboxToBoolean(this.p$3.apply(a))) continue;
                    this.fst = a;
                    this.status = 0;
                    return true;
                }
                this.status = 1;
                return false;
            }

            public Object next() {
                if (this.hasNext()) {
                    if (this.status == 1) {
                        return this.$outer.next();
                    }
                    this.status = 1;
                    return this.fst;
                }
                return Iterator$.MODULE$.empty().next();
            }
        };
    }

    public static Tuple2 span$(Iterator $this, Function1 p) {
        return $this.span(p);
    }

    @Override
    default public Tuple2<Iterator<A>, Iterator<A>> span(Function1<A, Object> p) {
        public final class Scala_collection_Iterator$Leading$1
        extends AbstractIterator<A> {
            private final Function1 p$4;
            private Queue lookahead;
            private Object hd;
            private int status;
            private final /* synthetic */ Iterator $outer;

            public Scala_collection_Iterator$Leading$1(Function1 p$8, Iterator $outer) {
                this.p$4 = p$8;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.lookahead = null;
                this.status = 0;
            }

            private void store(Object a) {
                Queue x$proxy5;
                if (this.lookahead == null) {
                    this.lookahead = new Queue<A>(Queue$.MODULE$.$lessinit$greater$default$1());
                }
                if ((x$proxy5 = this.lookahead) == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy5.$plus$eq(a);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.status < 0) {
                    if (this.lookahead == null) {
                        return false;
                    }
                    boolean bl = false;
                    if (bl) return false;
                    boolean bl2 = true;
                    if (!bl2) return false;
                    Queue x$proxy8 = this.lookahead;
                    if (x$proxy8 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    if (!x$proxy8.nonEmpty()) return false;
                    return true;
                }
                if (this.status > 0) {
                    return true;
                }
                if (this.$outer.hasNext()) {
                    this.hd = this.$outer.next();
                    this.status = BoxesRunTime.unboxToBoolean(this.p$4.apply(this.hd)) ? 1 : -2;
                } else {
                    this.status = -1;
                }
                if (this.status <= 0) return false;
                return true;
            }

            public Object next() {
                if (this.hasNext()) {
                    if (this.status == 1) {
                        this.status = 0;
                        return this.hd;
                    }
                    Queue x$proxy9 = this.lookahead;
                    if (x$proxy9 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    return x$proxy9.dequeue();
                }
                return Iterator$.MODULE$.empty().next();
            }

            public boolean finish() {
                int n;
                block6: while (true) {
                    n = this.status;
                    switch (n) {
                        case -2: {
                            this.status = -1;
                            return true;
                        }
                        case -1: {
                            return false;
                        }
                        case 1: {
                            this.store(this.hd);
                            this.status = 0;
                            continue block6;
                        }
                        case 0: {
                            this.status = -1;
                            while (this.$outer.hasNext()) {
                                A a = this.$outer.next();
                                if (BoxesRunTime.unboxToBoolean(this.p$4.apply(a))) {
                                    this.store(a);
                                    continue;
                                }
                                this.hd = a;
                                return true;
                            }
                            return false;
                        }
                    }
                    break;
                }
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }

            public Object trailer() {
                return this.hd;
            }

            public final /* synthetic */ Iterator scala$collection$Iterator$_$Leading$$$outer() {
                return this.$outer;
            }
        }
        Scala_collection_Iterator$Leading$1 leading = new Scala_collection_Iterator$Leading$1(p, this);
        AbstractIterator trailing = new AbstractIterator<A>(leading, this){
            private Scala_collection_Iterator$Leading$1 myLeading;
            private int status;
            private final /* synthetic */ Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.myLeading = leading$1;
                this.status = -1;
            }

            public boolean hasNext() {
                while (true) {
                    int n = this.status;
                    switch (n) {
                        case 3: {
                            return false;
                        }
                        case 2: {
                            return true;
                        }
                        case 1: {
                            if (this.$outer.hasNext()) {
                                this.status = 2;
                                return true;
                            }
                            this.status = 3;
                            return false;
                        }
                        case 0: {
                            return true;
                        }
                    }
                    if (this.myLeading.finish()) {
                        this.status = 0;
                        return true;
                    }
                    this.status = 1;
                    this.myLeading = null;
                }
            }

            public Object next() {
                if (this.hasNext()) {
                    if (this.status == 0) {
                        this.status = 1;
                        Object res = this.myLeading.trailer();
                        this.myLeading = null;
                        return res;
                    }
                    this.status = 1;
                    return this.$outer.next();
                }
                return Iterator$.MODULE$.empty().next();
            }
        };
        return Tuple2$.MODULE$.apply(leading, trailing);
    }

    public static Iterator slice$(Iterator $this, int from, int until) {
        return $this.slice(from, until);
    }

    @Override
    default public Iterator<A> slice(int from, int until) {
        return this.sliceIterator(from, RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(until), 0));
    }

    public static Iterator sliceIterator$(Iterator $this, int from, int until) {
        return $this.sliceIterator(from, until);
    }

    default public Iterator<A> sliceIterator(int from, int until) {
        int rest;
        int lo = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(from), 0);
        int n = until < 0 ? -1 : (rest = until <= lo ? 0 : until - lo);
        if (rest == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new SliceIterator(this, lo, rest);
    }

    public static Iterator zip$(Iterator $this, IterableOnce that) {
        return $this.zip(that);
    }

    default public <B> Iterator<Tuple2<A, B>> zip(IterableOnce<B> that) {
        return new AbstractIterator<Tuple2<A, B>>(that, this){
            private final Iterator thatIterator;
            private final /* synthetic */ Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.thatIterator = that$1.iterator();
            }

            public Iterator thatIterator() {
                return this.thatIterator;
            }

            public int knownSize() {
                return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.$outer.knownSize()), this.thatIterator().knownSize());
            }

            public boolean hasNext() {
                return this.$outer.hasNext() && this.thatIterator().hasNext();
            }

            public Tuple2 next() {
                return Tuple2$.MODULE$.apply(this.$outer.next(), this.thatIterator().next());
            }
        };
    }

    public static Iterator zipAll$(Iterator $this, IterableOnce that, Object thisElem, Object thatElem) {
        return $this.zipAll(that, thisElem, thatElem);
    }

    default public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
        return new AbstractIterator<Tuple2<A1, B>>(that, thisElem, thatElem, this){
            private final Object thisElem$2;
            private final Object thatElem$2;
            private final Iterator thatIterator;
            private final /* synthetic */ Iterator $outer;
            {
                this.thisElem$2 = thisElem$1;
                this.thatElem$2 = thatElem$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.thatIterator = that$2.iterator();
            }

            public Iterator thatIterator() {
                return this.thatIterator;
            }

            public int knownSize() {
                int thisSize = this.$outer.knownSize();
                int thatSize = this.thatIterator().knownSize();
                if (thisSize < 0 || thatSize < 0) {
                    return -1;
                }
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(thisSize), thatSize);
            }

            public boolean hasNext() {
                return this.$outer.hasNext() || this.thatIterator().hasNext();
            }

            public Tuple2 next() {
                boolean next1 = this.$outer.hasNext();
                boolean next2 = this.thatIterator().hasNext();
                if (!next1 && !next2) {
                    throw new NoSuchElementException();
                }
                return Tuple2$.MODULE$.apply(next1 ? this.$outer.next() : this.thisElem$2, next2 ? this.thatIterator().next() : this.thatElem$2);
            }
        };
    }

    public static Iterator zipWithIndex$(Iterator $this) {
        return $this.zipWithIndex();
    }

    @Override
    default public Iterator<Tuple2<A, Object>> zipWithIndex() {
        return new AbstractIterator<Tuple2<A, Object>>(this){
            private int idx;
            private final /* synthetic */ Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.idx = 0;
            }

            public int idx() {
                return this.idx;
            }

            public void idx_$eq(int x$1) {
                this.idx = x$1;
            }

            public int knownSize() {
                return this.$outer.knownSize();
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public Tuple2 next() {
                Tuple2<A, Integer> ret = Tuple2$.MODULE$.apply(this.$outer.next(), BoxesRunTime.boxToInteger(this.idx()));
                this.idx_$eq(this.idx() + 1);
                return ret;
            }
        };
    }

    public static boolean sameElements$(Iterator $this, IterableOnce that) {
        return $this.sameElements(that);
    }

    default public <B> boolean sameElements(IterableOnce<B> that) {
        Iterator<B> those = that.iterator();
        while (this.hasNext()) {
            if (!those.hasNext()) {
                return false;
            }
            if (BoxesRunTime.equals(this.next(), those.next())) continue;
            return false;
        }
        return !those.hasNext();
    }

    public static Tuple2 duplicate$(Iterator $this) {
        return $this.duplicate();
    }

    default public Tuple2<Iterator<A>, Iterator<A>> duplicate() {
        Queue gap = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        ObjectRef<Object> ahead = ObjectRef.create(null);
        public class Scala_collection_Iterator$Partner$1
        extends AbstractIterator<A> {
            private final ObjectRef ahead$1;
            private final Queue gap$1;
            private final /* synthetic */ Iterator $outer;

            public Scala_collection_Iterator$Partner$1(ObjectRef ahead$2, Queue gap$2, Iterator $outer) {
                this.ahead$1 = ahead$2;
                this.gap$1 = gap$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int knownSize() {
                int n;
                Iterator iterator = this.$outer;
                synchronized (iterator) {
                    int thisSize = this.$outer.knownSize();
                    n = this == (Iterator)this.ahead$1.elem ? thisSize : (thisSize < 0 || this.gap$1.knownSize() < 0 ? -1 : thisSize + this.gap$1.knownSize());
                }
                return n;
            }

            public boolean hasNext() {
                boolean bl;
                Iterator iterator = this.$outer;
                synchronized (iterator) {
                    bl = !(this == (Iterator)this.ahead$1.elem) && !this.gap$1.isEmpty() || this.$outer.hasNext();
                }
                return bl;
            }

            public Object next() {
                A a;
                Iterator iterator = this.$outer;
                synchronized (iterator) {
                    A a2;
                    if (this.gap$1.isEmpty()) {
                        this.ahead$1.elem = this;
                    }
                    if (this == (Iterator)this.ahead$1.elem) {
                        A e = this.$outer.next();
                        this.gap$1.enqueue(e);
                        a2 = e;
                    } else {
                        a2 = this.gap$1.dequeue();
                    }
                    a = a2;
                }
                return a;
            }

            private boolean compareGap(Queue queue) {
                return this.gap$1 == queue;
            }

            public int hashCode() {
                return this.gap$1.hashCode();
            }

            public boolean equals(Object other) {
                Object object = other;
                if (object instanceof Scala_collection_Iterator$Partner$1) {
                    Scala_collection_Iterator$Partner$1 var3_3 = (Scala_collection_Iterator$Partner$1)object;
                    Scala_collection_Iterator$Partner$1 x = var3_3;
                    return x.compareGap(this.gap$1) && this.gap$1.isEmpty();
                }
                return super.equals(other);
            }

            public final /* synthetic */ Iterator scala$collection$Iterator$_$Partner$$$outer() {
                return this.$outer;
            }
        }
        return Tuple2$.MODULE$.apply(new Scala_collection_Iterator$Partner$1(ahead, gap, this), new Scala_collection_Iterator$Partner$1(ahead, gap, this));
    }

    public static Iterator patch$(Iterator $this, int from, Iterator patchElems, int replaced) {
        return $this.patch(from, patchElems, replaced);
    }

    default public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return new AbstractIterator<B>(from, replaced, patchElems, this){
            private final int replaced$2;
            private final Iterator patchElems$2;
            private Iterator origElems;
            private int state;
            {
                this.replaced$2 = replaced$1;
                this.patchElems$2 = patchElems$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.origElems = $outer;
                this.state = from$1 > 0 ? from$1 : 0;
            }

            private void switchToPatchIfNeeded() {
                if (this.state == 0) {
                    this.origElems = this.origElems.drop(this.replaced$2);
                    this.state = -1;
                    return;
                }
            }

            public boolean hasNext() {
                this.switchToPatchIfNeeded();
                return this.origElems.hasNext() || this.patchElems$2.hasNext();
            }

            public Object next() {
                this.switchToPatchIfNeeded();
                if (this.state < 0) {
                    if (this.patchElems$2.hasNext()) {
                        return this.patchElems$2.next();
                    }
                    return this.origElems.next();
                }
                if (this.origElems.hasNext()) {
                    --this.state;
                    return this.origElems.next();
                }
                this.state = -1;
                return this.patchElems$2.next();
            }
        };
    }

    public static Iterator tapEach$(Iterator $this, Function1 f) {
        return $this.tapEach(f);
    }

    @Override
    default public <U> Iterator<A> tapEach(Function1<A, U> f) {
        return new AbstractIterator<A>(f, this){
            private final Function1 f$4;
            private final /* synthetic */ Iterator $outer;
            {
                this.f$4 = f$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int knownSize() {
                return this.$outer.knownSize();
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public Object next() {
                A _next = this.$outer.next();
                this.f$4.apply(_next);
                return _next;
            }
        };
    }

    public static String toString$(Iterator $this) {
        return $this.toString();
    }

    default public String toString() {
        return "<iterator>";
    }

    public static Iterator seq$(Iterator $this) {
        return $this.seq();
    }

    default public Iterator<A> seq() {
        return this;
    }

    public static Object scala$collection$Iterator$GroupedIterator$$_$$lessinit$greater$$anonfun$1(int size$1, int step$1) {
        return StringOps$.MODULE$.format$extension("size=%d and step=%d, but both must be positive", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(size$1), BoxesRunTime.boxToInteger(step$1)}));
    }

    public static final class ConcatIterator<A>
    extends AbstractIterator<A> {
        private final Iterator<A> from;
        private Iterator<A> current;
        private ConcatIteratorCell<A> tail;
        private ConcatIteratorCell<A> last;
        private boolean currentHasNextChecked;

        public ConcatIterator(Iterator<A> from) {
            this.from = from;
            this.current = from;
            this.tail = null;
            this.last = null;
            this.currentHasNextChecked = false;
        }

        public Iterator<A> from() {
            return this.from;
        }

        private Iterator<A> current() {
            return this.current;
        }

        private void current_$eq(Iterator<A> x$0) {
            this.current = x$0;
        }

        private ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        private void tail_$eq(ConcatIteratorCell<A> x$0) {
            this.tail = x$0;
        }

        private ConcatIteratorCell<A> last() {
            return this.last;
        }

        private void last_$eq(ConcatIteratorCell<A> x$0) {
            this.last = x$0;
        }

        private boolean currentHasNextChecked() {
            return this.currentHasNextChecked;
        }

        private void currentHasNextChecked_$eq(boolean x$0) {
            this.currentHasNextChecked = x$0;
        }

        @Override
        public boolean hasNext() {
            if (this.currentHasNextChecked()) {
                return true;
            }
            if (this.current() == null) {
                return false;
            }
            if (this.current().hasNext()) {
                this.currentHasNextChecked_$eq(true);
                return true;
            }
            return this.advance$1();
        }

        @Override
        public A next() {
            if (this.hasNext()) {
                this.currentHasNextChecked_$eq(false);
                Iterator<A> x$proxy13 = this.current();
                if (x$proxy13 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return x$proxy13.next();
            }
            return Iterator$.MODULE$.empty().next();
        }

        @Override
        public <B> Iterator<B> concat(Function0<IterableOnce<B>> that) {
            ConcatIteratorCell c = new ConcatIteratorCell(that, null);
            if (this.tail() == null) {
                this.tail_$eq(c);
                this.last_$eq(c);
            } else {
                ConcatIteratorCell x$proxy14 = this.last();
                if (x$proxy14 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy14.tail_$eq(c);
                this.last_$eq(c);
            }
            if (this.current() == null) {
                this.current_$eq((Iterator<A>)Iterator$.MODULE$.empty());
            }
            return this;
        }

        private final void merge$1() {
            while (this.current() instanceof ConcatIterator) {
                ConcatIteratorCell<A> x$proxy10;
                ConcatIterator c = (ConcatIterator)this.current();
                this.current_$eq(c.current());
                this.currentHasNextChecked_$eq(c.currentHasNextChecked());
                if (c.tail() == null) continue;
                if (this.last() == null) {
                    this.last_$eq(c.last());
                }
                if ((x$proxy10 = c.last()) == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy10.tail_$eq(this.tail());
                this.tail_$eq(c.tail());
            }
        }

        private final boolean advance$1() {
            do {
                if (this.tail() == null) {
                    this.current_$eq(null);
                    this.last_$eq(null);
                    return false;
                }
                this.current_$eq(this.tail().headIterator());
                if (this.last() == this.tail()) {
                    ConcatIteratorCell<A> x$proxy12 = this.last();
                    if (x$proxy12 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    this.last_$eq(x$proxy12.tail());
                }
                this.tail_$eq(this.tail().tail());
                this.merge$1();
                if (!this.currentHasNextChecked()) continue;
                return true;
            } while (this.current() == null || !this.current().hasNext());
            this.currentHasNextChecked_$eq(true);
            return true;
        }
    }

    public static final class ConcatIteratorCell<A> {
        private final Function0<IterableOnce<A>> head;
        private ConcatIteratorCell<A> tail;

        public ConcatIteratorCell(Function0<IterableOnce<A>> head, ConcatIteratorCell<A> tail) {
            this.head = head;
            this.tail = tail;
        }

        public ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        public void tail_$eq(ConcatIteratorCell<A> x$1) {
            this.tail = x$1;
        }

        public Iterator<A> headIterator() {
            return this.head.apply().iterator();
        }
    }

    public class GroupedIterator<B>
    extends AbstractIterator<Seq<B>> {
        private final Iterator<B> self;
        private final int size;
        private final int step;
        private Object buffer;
        private Object prev;
        private boolean first;
        private boolean filled;
        private boolean partial;
        private Function0<B> padding;
        private final /* synthetic */ Iterator $outer;

        public GroupedIterator(Iterator $outer, Iterator<B> self, int size, int step) {
            this.self = self;
            this.size = size;
            this.step = step;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Predef$.MODULE$.require(size >= 1 && step >= 1, () -> Iterator.scala$collection$Iterator$GroupedIterator$$_$$lessinit$greater$$anonfun$1(size, step));
            this.buffer = null;
            this.prev = null;
            this.first = true;
            this.filled = false;
            this.partial = true;
            this.padding = null;
        }

        private boolean pad() {
            return this.padding != null;
        }

        private ArrayBuilder<Object> newBuilder() {
            ArrayBuilder<Object> b = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Any());
            int k = this.self.knownSize();
            if (k > 0) {
                b.sizeHint(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(k), this.size));
            }
            return b;
        }

        public GroupedIterator<B> withPadding(Function0<B> x) {
            this.padding = x;
            this.partial = true;
            return this;
        }

        public GroupedIterator withPartial(boolean x) {
            this.partial = x;
            this.padding = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private boolean fulfill() {
            boolean ok;
            int index;
            ArrayBuilder<Object> builder = this.newBuilder();
            boolean done = false;
            if (this.prev != null) {
                void var3_3;
                Object x$proxy1 = this.prev;
                if (x$proxy1 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                builder.addAll(var3_3);
            }
            if (!this.first && this.step > this.size) {
                int dropping;
                for (dropping = this.step - this.size; dropping > 0 && this.self.hasNext(); --dropping) {
                    this.self.next();
                }
                done = dropping > 0;
            }
            if (!done) {
                for (index = builder.length(); index < this.size && this.self.hasNext(); ++index) {
                    builder.addOne(this.self.next());
                }
                if (index < this.size && this.pad()) {
                    builder.sizeHint(this.size);
                    while (index < this.size) {
                        Function0<B> x$proxy2 = this.padding;
                        if (x$proxy2 == null) {
                            throw Scala3RunTime$.MODULE$.nnFail();
                        }
                        builder.addOne(x$proxy2.apply());
                        ++index;
                    }
                }
            }
            boolean bl = ok = index > 0 && (this.partial || index == this.size);
            if (ok) {
                this.buffer = builder.result();
            } else {
                this.prev = null;
            }
            return ok;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean fill() {
            if (this.filled) return true;
            this.filled = this.self.hasNext() && this.fulfill();
            if (!this.filled) return false;
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.fill();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Seq<B> next() throws NoSuchElementException {
            void var2_1;
            if (!this.fill()) {
                return (Seq)Iterator$.MODULE$.empty().next();
            }
            this.filled = false;
            Object x$proxy3 = this.buffer;
            if (x$proxy3 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            void buffer = var2_1;
            if (this.step < this.size) {
                if (this.first) {
                    Object object = Predef$.MODULE$.genericArrayOps(buffer);
                    this.prev = ArrayOps$.MODULE$.drop$extension(object, this.step);
                } else if (ScalaRunTime$.MODULE$.array_length(buffer) == this.size) {
                    Object x$proxy4 = this.prev;
                    if (x$proxy4 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    Array$.MODULE$.copy(buffer, this.step, x$proxy4, 0, this.size - this.step);
                } else {
                    this.prev = null;
                }
            }
            ArraySeq res = ArraySeq$.MODULE$.unsafeWrapArray(buffer);
            this.buffer = null;
            this.first = false;
            return res;
        }

        public final /* synthetic */ Iterator scala$collection$Iterator$GroupedIterator$$$outer() {
            return this.$outer;
        }
    }

    public static final class SliceIterator<A>
    extends AbstractIterator<A> {
        private final Iterator<A> underlying;
        private int remaining;
        private int dropping;

        public SliceIterator(Iterator<A> underlying, int start, int limit) {
            this.underlying = underlying;
            this.remaining = limit;
            this.dropping = start;
        }

        public Iterator<A> underlying() {
            return this.underlying;
        }

        private boolean unbounded() {
            return this.remaining < 0;
        }

        private void skip() {
            while (this.dropping > 0) {
                if (this.underlying().hasNext()) {
                    this.underlying().next();
                    --this.dropping;
                    continue;
                }
                this.dropping = 0;
            }
        }

        @Override
        public int knownSize() {
            int size = this.underlying().knownSize();
            if (size < 0) {
                return -1;
            }
            int dropSize = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), size - this.dropping);
            if (this.unbounded()) {
                return dropSize;
            }
            return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.remaining), dropSize);
        }

        @Override
        public boolean hasNext() {
            this.skip();
            return this.remaining != 0 && this.underlying().hasNext();
        }

        @Override
        public A next() {
            this.skip();
            if (this.remaining > 0) {
                --this.remaining;
                return this.underlying().next();
            }
            if (this.unbounded()) {
                return this.underlying().next();
            }
            return Iterator$.MODULE$.empty().next();
        }

        @Override
        public Iterator<A> sliceIterator(int from, int until) {
            int lo = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(from), 0);
            int rest = until < 0 ? this.adjustedBound$1(lo) : (until <= lo ? 0 : (this.unbounded() ? until - lo : RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.adjustedBound$1(lo)), until - lo)));
            int sum = this.dropping + lo;
            if (rest == 0) {
                return Iterator$.MODULE$.empty();
            }
            if (sum < 0) {
                this.dropping = Integer.MAX_VALUE;
                this.remaining = 0;
                return this.concat(() -> this.sliceIterator$$anonfun$1(sum, rest));
            }
            this.dropping = sum;
            this.remaining = rest;
            return this;
        }

        private final int adjustedBound$1(int lo$1) {
            if (this.unbounded()) {
                return -1;
            }
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), this.remaining - lo$1);
        }

        private final IterableOnce sliceIterator$$anonfun$1(int sum$1, int rest$1) {
            return new SliceIterator<A>(this.underlying(), sum$1 - Integer.MAX_VALUE, rest$1);
        }
    }

    public static final class UnfoldIterator<A, S>
    extends AbstractIterator<A> {
        private final Function1<S, Option<Tuple2<A, S>>> f;
        private S state;
        private Option<Tuple2<A, S>> nextResult;

        public UnfoldIterator(S init2, Function1<S, Option<Tuple2<A, S>>> f) {
            this.f = f;
            this.state = init2;
            this.nextResult = null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasNext() {
            Option<Tuple2<A, S>> x$proxy16;
            if (this.nextResult == null) {
                void var1_1;
                Option<Tuple2<A, S>> res = this.f.apply(this.state);
                if (res == null) {
                    throw new NullPointerException("null during unfold");
                }
                this.nextResult = var1_1;
                this.state = null;
            }
            if ((x$proxy16 = this.nextResult) == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy16.isDefined();
        }

        @Override
        public A next() {
            if (this.hasNext()) {
                Tuple2<A, S> tuple2;
                Tuple2<A, S> $3$;
                Option<Tuple2<A, S>> x$proxy17 = this.nextResult;
                if (x$proxy17 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Tuple2<A, S> tuple22 = $3$ = (tuple2 = x$proxy17.get());
                A value = tuple22._1();
                S newState = tuple22._2();
                this.state = newState;
                this.nextResult = null;
                return value;
            }
            return Iterator$.MODULE$.empty().next();
        }
    }
}

