/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public interface StrictOptimizedSeqOps<A, CC, C>
extends SeqOps<A, CC, C>,
StrictOptimizedIterableOps<A, CC, C>,
Object {
    public static void $init$(StrictOptimizedSeqOps $this) {
    }

    public static Object distinctBy$(StrictOptimizedSeqOps $this, Function1 f) {
        return $this.distinctBy(f);
    }

    @Override
    default public <B> C distinctBy(Function1<A, B> f) {
        Builder builder = this.newSpecificBuilder();
        Object seen = HashSet$.MODULE$.empty();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!((HashSet)seen).add(f.apply(next))) continue;
            builder.$plus$eq(next);
        }
        return builder.result();
    }

    public static Object prepended$(StrictOptimizedSeqOps $this, Object elem) {
        return $this.prepended(elem);
    }

    @Override
    default public <B> CC prepended(B elem) {
        Builder b = this.iterableFactory().newBuilder();
        b.sizeHint(this, 1);
        b.$plus$eq(elem);
        b.$plus$plus$eq(this);
        return b.result();
    }

    public static Object appended$(StrictOptimizedSeqOps $this, Object elem) {
        return $this.appended(elem);
    }

    @Override
    default public <B> CC appended(B elem) {
        Builder b = this.iterableFactory().newBuilder();
        b.sizeHint(this, 1);
        b.$plus$plus$eq(this);
        b.$plus$eq(elem);
        return b.result();
    }

    public static Object appendedAll$(StrictOptimizedSeqOps $this, IterableOnce suffix) {
        return $this.appendedAll(suffix);
    }

    @Override
    default public <B> CC appendedAll(IterableOnce<B> suffix) {
        return this.strictOptimizedConcat(suffix, this.iterableFactory().newBuilder());
    }

    public static Object prependedAll$(StrictOptimizedSeqOps $this, IterableOnce prefix) {
        return $this.prependedAll(prefix);
    }

    @Override
    default public <B> CC prependedAll(IterableOnce<B> prefix) {
        Builder b = this.iterableFactory().newBuilder();
        b.$plus$plus$eq(prefix);
        b.$plus$plus$eq(this);
        return b.result();
    }

    public static Object padTo$(StrictOptimizedSeqOps $this, int len, Object elem) {
        return $this.padTo(len, elem);
    }

    @Override
    default public <B> CC padTo(int len, B elem) {
        Builder b = this.iterableFactory().newBuilder();
        int L = this.size();
        b.sizeHint(package$.MODULE$.max(L, len));
        b.$plus$plus$eq(this);
        for (int diff = len - L; diff > 0; --diff) {
            b.$plus$eq(elem);
        }
        return b.result();
    }

    public static Object diff$(StrictOptimizedSeqOps $this, Seq that) {
        return $this.diff(that);
    }

    @Override
    default public <B> C diff(Seq<B> that) {
        if (this.isEmpty() || that.isEmpty()) {
            return this.coll();
        }
        Map occ = this.occCounts(that);
        Builder b = this.newSpecificBuilder();
        this.foreach((Function1<Object, Option> & Serializable)x -> occ.updateWith(x, (Function1<Option, Option> & Serializable)x$12 -> {
            Option option = x$12;
            if (None$.MODULE$.equals(option)) {
                b.addOne(x);
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                int n = BoxesRunTime.unboxToInt(some.value());
                if (1 == n) {
                    return None$.MODULE$;
                }
                int n2 = n;
                return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(n2 - 1));
            }
            throw new MatchError(option);
        }));
        return b.result();
    }

    public static Object intersect$(StrictOptimizedSeqOps $this, Seq that) {
        return $this.intersect(that);
    }

    @Override
    default public <B> C intersect(Seq<B> that) {
        if (this.isEmpty() || that.isEmpty()) {
            return this.empty();
        }
        Map occ = this.occCounts(that);
        Builder b = this.newSpecificBuilder();
        this.foreach((Function1<Object, Option> & Serializable)x -> occ.updateWith(x, (Function1<Option, Option> & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                int n = BoxesRunTime.unboxToInt(some.value());
                b.addOne(x);
                if (n == 1) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(n - 1));
            }
            throw new MatchError(option);
        }));
        return b.result();
    }
}

