//--------------------------------------------------------------
// TriTone
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Tri Tone", "Colour", "Components", kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Level1, "Threshold One", kNoGroup, kNoFlags, 0.33, 0.0, 1.0 );
DeclareFloatParam( Level2, "Threshold Two", kNoGroup, kNoFlags, 0.66, 0.0, 1.0 );
DeclareColourParam( DarkColour,  "Dark Colour",  kNoGroup, kNoFlags, 0.0, 0.0, 0.0, 1.0 );
DeclareColourParam( MidColour,   "Mid Colour",   kNoGroup, kNoFlags, 0.5, 0.5, 0.5, 1.0 );
DeclareColourParam( LightColour, "Light Colour", kNoGroup, kNoFlags, 1.0, 1.0, 1.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

DeclareFloatParam( _OutputWidth );
DeclareFloatParam( _OutputHeight );

float4 blur = float4( 20.0 / 64.0, 15.0 / 64.0, 6.0  / 64.0, 1.0  / 64.0 );  // See Pascals Triangle

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclarePass( Threshold )
{
   float4 src1 = tex2D( Input, uv1 );
   float srcLum = ( ( src1.r * 0.3 ) + ( src1.g * 0.59 ) + ( src1.b * 0.11 ) );

   if ( srcLum < Level1 )
      src1.rgb = DarkColour.rgb;
   else if ( srcLum < Level2 )
      src1.rgb = MidColour.rgb;
   else
      src1.rgb = LightColour.rgb;

   return src1;
}

//--------------------------------------------------------------
// Blur1
//--------------------------------------------------------------
DeclarePass( Blur1 )
{
   // Explicitly query BETWEEN pixels to get extra averaging

   float2 onePixAcross   = float2( 0.5 / _OutputWidth, 0.0 );
   float2 twoPixAcross   = float2( 1.5 / _OutputWidth, 0.0 );
   float2 threePixAcross = float2( 2.5 / _OutputWidth, 0.0 );

   float4 keyPix = tex2D( Threshold, uv1 );

   float4 result = keyPix * blur[ 0 ];
   result += tex2D( Threshold, uv1 + onePixAcross )   * blur[ 1 ];
   result += tex2D( Threshold, uv1 - onePixAcross )   * blur[ 1 ];
   result += tex2D( Threshold, uv1 + twoPixAcross )   * blur[ 2 ];
   result += tex2D( Threshold, uv1 - twoPixAcross )   * blur[ 2 ];
   result += tex2D( Threshold, uv1 + threePixAcross ) * blur[ 3 ];
   result += tex2D( Threshold, uv1 - threePixAcross ) * blur[ 3 ];
   result.a = keyPix.a;

   return result;
}

//--------------------------------------------------------------
// Blur2
//--------------------------------------------------------------
DeclareEntryPoint( blur2 )
{
   // Explicitly query BETWEEN pixels to get extra averaging
   float2 onePixDown   = float2( 0.0, 0.5 / _OutputHeight );
   float2 twoPixDown   = float2( 0.0, 1.5 / _OutputHeight );
   float2 threePixDown = float2( 0.0, 2.5 / _OutputHeight );

   float4 keyPix = tex2D( Blur1, uv1 );
   float4 source = tex2D( Input, uv1 );

   float4 result = keyPix * blur[ 0 ];
   result += tex2D( Blur1, uv1 + onePixDown )   * blur[ 1 ];
   result += tex2D( Blur1, uv1 - onePixDown )   * blur[ 1 ];
   result += tex2D( Blur1, uv1 + twoPixDown )   * blur[ 2 ];
   result += tex2D( Blur1, uv1 - twoPixDown )   * blur[ 2 ];
   result += tex2D( Blur1, uv1 + threePixDown ) * blur[ 3 ];
   result += tex2D( Blur1, uv1 - threePixDown ) * blur[ 3 ];
   result.a = keyPix.a;

   result = lerp( source, result, source.a );
   result.a = source.a;

   return lerp( source, result, tex2D( Mask, uv1 ) );
}
