//--------------------------------------------------------------
// Threshold
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Two Tone", "Colour", "Components", kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Level, "Threshold", kNoGroup, kNoFlags, 0.5, 0.0, 1.0 );
DeclareColourParam( DarkColour,  "Dark Colour",  kNoGroup, kNoFlags, 0.0, 0.0, 0.0, 1.0 );
DeclareColourParam( LightColour, "Light Colour", kNoGroup, kNoFlags, 1.0, 1.0, 1.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

DeclareFloatParam( _OutputWidth );
DeclareFloatParam( _OutputHeight );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclarePass( Threshold )
{
   float4 src1 = tex2D( Input, uv1 );
   float srcLum = ( ( src1.r * 0.3 ) + ( src1.g * 0.59 ) + ( src1.b * 0.11 ) );

   if ( srcLum > Level )
      src1.rgb = LightColour.rgb;
   else
      src1.rgb = DarkColour.rgb;

   return src1;
}
//--------------------------------------------------------------
DeclarePass( BlurX )
{
   float one   = 1.0 / _OutputWidth;
   float tap1  = uv1.x + one;
   float ntap1 = uv1.x - one;

   float4 ret =  tex2D( Threshold, uv1 );
   float4 blurred = ret;

   blurred += tex2D( Threshold, float2( tap1,  uv1.y ) );
   blurred += tex2D( Threshold, float2( ntap1, uv1.y ) );
   blurred /= 3;

   return blurred;
}
//--------------------------------------------------------------
DeclareEntryPoint( BlurY )
{
   float one  = 1.0 / _OutputHeight;
   float tap1 = uv1.y + one;
   float ntap1 = uv1.y - one;

   float4 ret    = tex2D( BlurX, uv1 );
   float4 source = tex2D( Input, uv1 );
   ret += tex2D( BlurX, float2( uv1.x, tap1 ) );
   ret += tex2D( BlurX, float2( uv1.x, ntap1 ) );
   ret /= 3;

   ret = lerp( source, ret, source.a );
   ret.a = source.a;

   float4 srcPixel = ReadPixel( Input, uv1 );
   return lerp( srcPixel, ret, tex2D( Mask, uv1 ) );
}
