//--------------------------------------------------------------
// squeeze.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Squeeze", "Mix", "User", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareIntParam( SetTechnique, "Type", kNoGroup, 0, "Squeeze Right|Squeeze Down|Squeeze Left|Squeeze Up" );

DeclareFloatParamAnimated( Progress, "Progress", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInputs( fg, bg );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint( Squeeze1 )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 ret;

   if ( uv0.x > Progress )
   {
      ret = ReadPixel( fg, float2( ( uv1.x - Progress ) / ( 1.0 - Progress ), uv1.y )  );
   }
   else
   {
      ret = ReadPixel( bg, float2( uv2.x / Progress, uv2.y )  );
   }

   return lerp( fgPix, ret, tex2D( Mask, uv1 ) );
}

//--------------------------------------------------------------
DeclareEntryPoint( Squeeze2 )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 ret;

   if ( uv0.y > Progress )
   {
      ret = ReadPixel( fg, float2( uv1.x, ( uv1.y - Progress ) / ( 1.0 - Progress ) ) );
   }
   else
   {
      ret = ReadPixel( bg, float2( uv2.x, uv2.y / Progress ) );
   }

   return lerp( fgPix, ret, tex2D(Mask, uv1) );
}

//--------------------------------------------------------------
DeclareEntryPoint( Squeeze3 )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 ret;

   if ( uv0.x > ( 1.0 - Progress ) )
   {
      ret = ReadPixel( bg, float2( ( uv2.x - ( 1.0 - Progress ) ) / Progress, uv2.y )  );
   }
   else
   {
      ret = ReadPixel( fg, float2( uv1.x / ( 1.0 - Progress ), uv1.y ) );
   }

   return lerp( fgPix, ret, tex2D(Mask, uv1) );
}

//--------------------------------------------------------------
DeclareEntryPoint( Squeeze4 )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 ret;

   if ( uv0.y > ( 1.0 - Progress ) )
   {
      ret = ReadPixel( bg, float2( uv2.x ,( uv2.y - ( 1.0 - Progress ) ) / Progress ) );
   }
   else
   {
      ret = ReadPixel( fg, float2( uv1.x, uv1.y / ( 1.0 - Progress ) ) );
   }

   return lerp( fgPix, ret, tex2D( Mask, uv1 ) );
}
