//--------------------------------------------------------------//
// ChromaKey2
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//

int _LwksEffectInfo
<
   string EffectGroup = "GenericPixelShader";
   string Description = "Selective x4";
   string Category    = "Colour Effects";
   bool CanSize       = true;
> = 0;

//--------------------------------------------------------------//
// Params
//--------------------------------------------------------------//

float4 Colour1
<
   string Description = "Key Colour";
   string Flags = "SpecifiesColourRange";
>;

float4 Tolerance1
<
   string Description = "Tolerance";
   string Flags = "SpecifiesColourRange";
   bool Visible = false;
>;

float4 Soft1
<
   string Description = "Softness";
   string Flags = "SpecifiesColourRange";
   bool Visible = false;
>;

bool Invert1
<
   string Description = "Invert selection";
> = false;

bool Reveal1
<
   string Description = "Reveal selection";
> = false;

float4 RangeExtents1
<
   string Description = "RangeExtents";
   string Flags = "SpecifiesTonalRanges";
> = { 0.2, 0.4, 0.6, 0.8 };

float4 ShadowTint1
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float4 MidTint1
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float4 HighTint1
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float Saturation1
<
   string Description = "Saturation";
   float MinVal = 0.0;
   float MaxVal = 4.00;
> = 1.00;

float Gamma1
<
   string Description = "Gamma";
   float MinVal = 0.10;
   float MaxVal = 4.00;
> = 1.00;

float Contrast1
<
   string Description = "Contrast";
   float MinVal = 0.00;
   float MaxVal = 5.00;
> = 1.0;

float Brightness1
<
   string Description = "Brightness";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float Gain1
<
   string Description = "Gain";
   float MinVal = 0.00;
   float MaxVal = 4.00;
> = 1.0;

bool Enabled1
<
   string Description = "Enable";
> = false;

//---------------------------------------------
float4 Colour2
<
   string Description = "Key Colour";
   string Flags = "SpecifiesColourRange";
>;

float4 Tolerance2
<
   string Description = "Tolerance";
   string Flags = "SpecifiesColourRange";
   bool Visible = false;
>;

float4 Soft2
<
   string Description = "Softness";
   string Flags = "SpecifiesColourRange";
   bool Visible = false;
>;

bool Invert2
<
   string Description = "Invert selection";
> = false;

bool Reveal2
<
   string Description = "Reveal selection";
> = false;

float4 RangeExtents2
<
   string Description = "RangeExtents";
   string Flags = "SpecifiesTonalRanges";
> = { 0.2, 0.4, 0.6, 0.8 };

float4 ShadowTint2
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float4 MidTint2
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float4 HighTint2
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float Saturation2
<
   string Description = "Saturation";
   float MinVal = 0.0;
   float MaxVal = 4.00;
> = 1.00;

float Gamma2
<
   string Description = "Gamma";
   float MinVal = 0.10;
   float MaxVal = 4.00;
> = 1.00;

float Contrast2
<
   string Description = "Contrast";
   float MinVal = 0.00;
   float MaxVal = 5.00;
> = 1.0;

float Brightness2
<
   string Description = "Brightness";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float Gain2
<
   string Description = "Gain";
   float MinVal = 0.00;
   float MaxVal = 4.00;
> = 1.0;

bool Enabled2
<
   string Description = "Enable";
> = false;

//---------------------------------------------
float4 Colour3
<
   string Description = "Key Colour";
   string Flags = "SpecifiesColourRange";
>;

float4 Tolerance3
<
   string Description = "Tolerance";
   string Flags = "SpecifiesColourRange";
   bool Visible = false;
>;

float4 Soft3
<
   string Description = "Softness";
   string Flags = "SpecifiesColourRange";
   bool Visible = false;
>;

bool Invert3
<
   string Description = "Invert selection";
> = false;

bool Reveal3
<
   string Description = "Reveal selection";
> = false;

float4 RangeExtents3
<
   string Description = "RangeExtents";
   string Flags = "SpecifiesTonalRanges";
> = { 0.2, 0.4, 0.6, 0.8 };

float4 ShadowTint3
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float4 MidTint3
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float4 HighTint3
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float Saturation3
<
   string Description = "Saturation";
   float MinVal = 0.0;
   float MaxVal = 4.00;
> = 1.00;

float Gamma3
<
   string Description = "Gamma";
   float MinVal = 0.10;
   float MaxVal = 4.00;
> = 1.00;

float Contrast3
<
   string Description = "Contrast";
   float MinVal = 0.00;
   float MaxVal = 5.00;
> = 1.0;

float Brightness3
<
   string Description = "Brightness";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float Gain3
<
   string Description = "Gain";
   float MinVal = 0.00;
   float MaxVal = 4.00;
> = 1.0;

bool Enabled3
<
   string Description = "Enable";
> = false;

//---------------------------------------------
float4 Colour4
<
   string Description = "Key Colour";
   string Flags = "SpecifiesColourRange";
>;

float4 Tolerance4
<
   string Description = "Tolerance";
   string Flags = "SpecifiesColourRange";
   bool Visible = false;
>;

float4 Soft4
<
   string Description = "Softness";
   string Flags = "SpecifiesColourRange";
   bool Visible = false;
>;

bool Invert4
<
   string Description = "Invert selection";
> = false;

bool Reveal4
<
   string Description = "Reveal selection";
> = false;

float4 RangeExtents4
<
   string Description = "RangeExtents";
   string Flags = "SpecifiesTonalRanges";
> = { 0.2, 0.4, 0.6, 0.8 };

float4 ShadowTint4
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float4 MidTint4
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float4 HighTint4
<
   string Description = "Tint";
   string Flags = "SpecifiesColourOffset";
> = { 1.0, 1.0, 1.0, 1.0 };

float Saturation4
<
   string Description = "Saturation";
   float MinVal = 0.0;
   float MaxVal = 4.00;
> = 1.00;

float Gamma4
<
   string Description = "Gamma";
   float MinVal = 0.10;
   float MaxVal = 4.00;
> = 1.00;

float Contrast4
<
   string Description = "Contrast";
   float MinVal = 0.00;
   float MaxVal = 5.00;
> = 1.0;

float Brightness4
<
   string Description = "Brightness";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float Gain4
<
   string Description = "Gain";
   float MinVal = 0.00;
   float MaxVal = 4.00;
> = 1.0;

bool Enabled4
<
   string Description = "Enable";
> = false;

//---------------------------------------------
int _SplitScreen
<
   string Description = "Split screen";
   string Enum = "None,Left,Right,Top,Bottom";
> = 0;

float _SplitProportion = 0.5;


//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
texture Input;

//--------------------------------------------------------------//
// Intermediate textures
//--------------------------------------------------------------//
texture HSV        : RenderColorTarget;
texture Col1Result : RenderColorTarget;
texture Col2Result : RenderColorTarget;
texture Col3Result : RenderColorTarget;
texture Col4Result : RenderColorTarget;

//--------------------------------------------------------------//
// Samplers - one for each texture
//--------------------------------------------------------------//
sampler FgSampler   = sampler_state { Texture = <Input>; };
sampler HSVSampler  = sampler_state { Texture = <HSV>; };
sampler Col1Sampler = sampler_state { Texture = <Col1Result>; };
sampler Col2Sampler = sampler_state { Texture = <Col2Result>; };
sampler Col3Sampler = sampler_state { Texture = <Col3Result>; };
sampler Col4Sampler = sampler_state { Texture = <Col4Result>; };

//--------------------------------------------------------------//
// Common
//--------------------------------------------------------------//
const float _FallOff = 0.12;

#define HUE_IDX 0
#define SAT_IDX 1
#define VAL_IDX 2

const float _oneSixth = 1.0 / 6.0;
const float _oneHalf  = 0.5;

//--------------------------------------------------------------//
// RGBToHSV_ps_main
//
// Convert the source to HSV
//--------------------------------------------------------------//
float4 RGBToHSV_ps_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 hsv;
   float4 rgba = tex2D( FgSampler, xy1 );

   float maxComponentVal = max( max( rgba.r, rgba.g ), rgba.b );
   float minComponentVal = min( min( rgba.r, rgba.g ), rgba.b );
   float componentRange  = maxComponentVal - minComponentVal;

   hsv[ VAL_IDX ] = maxComponentVal;
   hsv[ SAT_IDX ] = componentRange / maxComponentVal;

   if ( hsv[ SAT_IDX ] == 0 )
   {
      hsv[ HUE_IDX ] = 0;   // undefined
   }
   else
   {
      if ( rgba.r == maxComponentVal )
      {
         hsv[ HUE_IDX ] = ( rgba.g - rgba.b ) / componentRange;
      }
      else if ( rgba.g == maxComponentVal )
      {
         hsv[ HUE_IDX ] = 2 + ( ( rgba.b - rgba.r ) / componentRange );
      }
      else
      {
         hsv[ HUE_IDX ] = 4 + ( ( rgba.r - rgba.g ) / componentRange );
      }

      hsv[ HUE_IDX ] *= _oneSixth;
      if (hsv[ HUE_IDX ] < 0) hsv[ HUE_IDX ] += 1.0;
   }

   hsv.a = ( rgba.r * 0.3 ) + ( rgba.g * 0.59 ) + ( rgba.b * 0.11 );

   return hsv;
}

const float _minTolerance = 1.0 / 256.0;

//--------------------------------------------------------------//
// applyColAdjust
//
// Compute similarity of 'colour' with each source pixel and apply
// a colour adjustment accordingly
//--------------------------------------------------------------//
float4 applyColAdjust( float2 xy1,
                       float4 tolerance1,
                       float4 softness,
                       float4 colour,
                       float4 rangeExtents,
                       float4 shadowTint,
                       float4 midTint,
                       float4 highTint,
                       float  saturation,
                       float  gamma,
                       float  gain,
                       float  brightness,
                       float  contrast,
                       bool   reveal,
                       bool   invert )
{
   tolerance1 += _minTolerance;
   float4 tolerance2 = tolerance1 + softness;

   float mix        = 0.0;
   float4 corrected = 1.0;
   float4 orig      = tex2D( FgSampler,  xy1 );
   float4 hsv       = tex2D( HSVSampler, xy1 );

   // Calc difference between current pixel and specified key-colour
   float4 diff = abs( hsv - colour );

   if ( diff[ HUE_IDX ] > 0.5 )
      diff[ HUE_IDX ] = 1.0 - diff[ HUE_IDX ];

   // Compute the colour-corrected pixel value
   if ( reveal == false )
   {
      if ( hsv.a < rangeExtents[ 1 ] )       // Shadow
      {
         corrected = orig + shadowTint;

         if ( hsv.a >= rangeExtents[ 0 ] )
            corrected = lerp( corrected, orig + midTint, ( hsv.a - rangeExtents[ 0 ] ) / ( rangeExtents[ 1 ] - rangeExtents[ 0 ] ) );
      }
      else if ( hsv.a > rangeExtents[ 2 ] )  // Highlight
      {
         corrected = orig + highTint;

         if ( hsv.a <= rangeExtents[ 3 ] )
            corrected = lerp( orig + midTint, corrected, ( hsv.a - rangeExtents[ 2 ] ) / ( rangeExtents[ 3 ] - rangeExtents[ 2 ] ) );
      }
      else                                   // Midtone
      {
         corrected = orig + midTint;
      }

      // Saturation
      float4 avg = ( corrected.r + corrected.g + corrected.b ) / 3.0;
      corrected = saturate( avg + ( ( corrected - avg ) * saturation ) );

      // Brightness, gamma, contrast & gain
      corrected = ( ( ( ( pow( corrected, 1.0 / gamma ) * gain ) + brightness ) - 0.5 ) * contrast ) + 0.5;
   }

   // Work out how transparent/opaque the corrected pixel will be
   if ( all( saturate( tolerance2 - diff ) ) )
   {
      if ( all( saturate( tolerance1 - diff ) ) )
         mix = 1;
      else
      {
         diff -= tolerance1;
         diff /= softness;
         mix = 1.0 - ( max( diff[ HUE_IDX ], max( diff[ SAT_IDX ], + diff[ VAL_IDX ] ) ) );
      }
   }

   // Handle mask inversion
   corrected.a = lerp( mix, 1.0 - mix, invert );

   return corrected;
}


//--------------------------------------------------------------//
// apply1
//--------------------------------------------------------------//
float4 apply1_ps_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   return applyColAdjust( xy1, Tolerance1, Soft1, Colour1, RangeExtents1, ShadowTint1, MidTint1, HighTint1,
                          Saturation1, Gamma1, Gain1, Brightness1, Contrast1, Reveal1, Invert1 );
}
//--------------------------------------------------------------//
// apply2
//--------------------------------------------------------------//
float4 apply2_ps_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   return applyColAdjust( xy1, Tolerance2, Soft2, Colour2, RangeExtents2, ShadowTint2, MidTint2, HighTint2,
                          Saturation2, Gamma2, Gain2, Brightness2, Contrast2, Reveal2, Invert2 );
}
//--------------------------------------------------------------//
// apply3
//--------------------------------------------------------------//
float4 apply3_ps_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   return applyColAdjust( xy1, Tolerance3, Soft3, Colour3, RangeExtents3, ShadowTint3, MidTint3, HighTint3,
                          Saturation3, Gamma3, Gain3, Brightness3, Contrast3, Reveal3, Invert3 );
}
//--------------------------------------------------------------//
// apply4
//--------------------------------------------------------------//
float4 apply4_ps_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   return applyColAdjust( xy1, Tolerance4, Soft4, Colour4, RangeExtents4, ShadowTint4, MidTint4, HighTint4,
                          Saturation4, Gamma4, Gain4, Brightness4, Contrast4, Reveal4, Invert4 );
}

//--------------------------------------------------------------//
// Composite
//
// Each colour-correction has been made (to its own image/texture)
// Now we need to merge them all together to produce the final result
//--------------------------------------------------------------//
float4 composite_ps_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 ret;
   float4 orig       = tex2D( FgSampler,  xy1 );
   float4 corrected1 = tex2D( Col1Sampler, xy1 );
   float4 corrected2 = tex2D( Col2Sampler, xy1 );
   float4 corrected3 = tex2D( Col3Sampler, xy1 );
   float4 corrected4 = tex2D( Col4Sampler, xy1 );

   if ( ( _SplitScreen == 0 ) ||
        ( _SplitScreen == 1 && xy1.x < _SplitProportion ) ||
        ( _SplitScreen == 2 && xy1.x > _SplitProportion ) ||
        ( _SplitScreen == 3 && xy1.y < _SplitProportion ) ||
        ( _SplitScreen == 4 && xy1.y > _SplitProportion ) )
   {
      ret = lerp( orig, corrected1, corrected1.a * Enabled1 );
      ret = lerp( ret,  corrected2, corrected2.a * Enabled2 );
      ret = lerp( ret,  corrected3, corrected3.a * Enabled3 );
      ret = lerp( ret,  corrected4, corrected4.a * Enabled4 );
      ret.a = orig.a;
   }
   else
      ret = orig;

   return ret;
}
//--------------------------------------------------------------//
float4 passthrough_ps_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   return tex2D( FgSampler, xy1 );
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection1234
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C1 < string Script = "RenderColorTarget0 = Col1Result;"; > { PixelShader = compile PROFILE apply1_ps_main();    }
   pass C2 < string Script = "RenderColorTarget0 = Col2Result;"; > { PixelShader = compile PROFILE apply2_ps_main();    }
   pass C3 < string Script = "RenderColorTarget0 = Col3Result;"; > { PixelShader = compile PROFILE apply3_ps_main();    }
   pass C4 < string Script = "RenderColorTarget0 = Col4Result;"; > { PixelShader = compile PROFILE apply4_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection1
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C1 < string Script = "RenderColorTarget0 = Col1Result;"; > { PixelShader = compile PROFILE apply1_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection2
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C2 < string Script = "RenderColorTarget0 = Col2Result;"; > { PixelShader = compile PROFILE apply2_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection3
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C3 < string Script = "RenderColorTarget0 = Col3Result;"; > { PixelShader = compile PROFILE apply3_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection4
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C4 < string Script = "RenderColorTarget0 = Col4Result;"; > { PixelShader = compile PROFILE apply4_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection12
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C1 < string Script = "RenderColorTarget0 = Col1Result;"; > { PixelShader = compile PROFILE apply1_ps_main();    }
   pass C2 < string Script = "RenderColorTarget0 = Col2Result;"; > { PixelShader = compile PROFILE apply2_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection13
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C1 < string Script = "RenderColorTarget0 = Col1Result;"; > { PixelShader = compile PROFILE apply1_ps_main();    }
   pass C3 < string Script = "RenderColorTarget0 = Col3Result;"; > { PixelShader = compile PROFILE apply3_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection14
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C1 < string Script = "RenderColorTarget0 = Col1Result;"; > { PixelShader = compile PROFILE apply1_ps_main();    }
   pass C4 < string Script = "RenderColorTarget0 = Col4Result;"; > { PixelShader = compile PROFILE apply4_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection23
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C2 < string Script = "RenderColorTarget0 = Col2Result;"; > { PixelShader = compile PROFILE apply2_ps_main();    }
   pass C3 < string Script = "RenderColorTarget0 = Col3Result;"; > { PixelShader = compile PROFILE apply3_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection24
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C2 < string Script = "RenderColorTarget0 = Col2Result;"; > { PixelShader = compile PROFILE apply2_ps_main();    }
   pass C4 < string Script = "RenderColorTarget0 = Col4Result;"; > { PixelShader = compile PROFILE apply4_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection34
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C3 < string Script = "RenderColorTarget0 = Col3Result;"; > { PixelShader = compile PROFILE apply3_ps_main();    }
   pass C4 < string Script = "RenderColorTarget0 = Col4Result;"; > { PixelShader = compile PROFILE apply4_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection123
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C1 < string Script = "RenderColorTarget0 = Col1Result;"; > { PixelShader = compile PROFILE apply1_ps_main();    }
   pass C2 < string Script = "RenderColorTarget0 = Col2Result;"; > { PixelShader = compile PROFILE apply2_ps_main();    }
   pass C3 < string Script = "RenderColorTarget0 = Col3Result;"; > { PixelShader = compile PROFILE apply3_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection124
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C1 < string Script = "RenderColorTarget0 = Col1Result;"; > { PixelShader = compile PROFILE apply1_ps_main();    }
   pass C2 < string Script = "RenderColorTarget0 = Col2Result;"; > { PixelShader = compile PROFILE apply2_ps_main();    }
   pass C4 < string Script = "RenderColorTarget0 = Col4Result;"; > { PixelShader = compile PROFILE apply4_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection134
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C1 < string Script = "RenderColorTarget0 = Col1Result;"; > { PixelShader = compile PROFILE apply1_ps_main();    }
   pass C3 < string Script = "RenderColorTarget0 = Col3Result;"; > { PixelShader = compile PROFILE apply3_ps_main();    }
   pass C4 < string Script = "RenderColorTarget0 = Col4Result;"; > { PixelShader = compile PROFILE apply4_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection234
{
   pass RGBToHSV < string Script = "RenderColorTarget0 = HSV;"; >  { PixelShader = compile PROFILE RGBToHSV_ps_main();  }
   pass C2 < string Script = "RenderColorTarget0 = Col2Result;"; > { PixelShader = compile PROFILE apply2_ps_main();    }
   pass C3 < string Script = "RenderColorTarget0 = Col3Result;"; > { PixelShader = compile PROFILE apply3_ps_main();    }
   pass C4 < string Script = "RenderColorTarget0 = Col4Result;"; > { PixelShader = compile PROFILE apply4_ps_main();    }
   pass Composite                                                  { PixelShader = compile PROFILE composite_ps_main(); }
}
//--------------------------------------------------------------//
technique SelectiveColourCorrection
{
   pass PassThrough                                                { PixelShader = compile PROFILE passthrough_ps_main(); }
}

