//--------------------------------------------------------------
// Push.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Push", "Mix", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareIntParam( SetTechnique, "Type", kNoGroup, 0, "Push Right|Push Down|Push Left|Push Up" );
DeclareFloatParamAnimated( Progress, "Progress", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
DeclareInputs( fg, bg );

DeclareIntParam( _fgOrientation );
DeclareIntParam( _bgOrientation );
DeclareFloat4Param( _fgExtents );
DeclareFloat4Param( _bgExtents );

//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//
DeclareEntryPoint( PushRight )
{
   float4 ret;

   if ( uv0.x > Progress )
   {
      float xProgress = abs( Progress * ( _fgExtents[ 2 ] - _fgExtents[ 0 ] ) );
      float yProgress = abs( Progress * ( _fgExtents[ 3 ] - _fgExtents[ 1 ] ) );

      if ( _fgOrientation == 90 )
      {
         ret = ReadPixel( fg, float2( uv1.x, uv1.y - yProgress  ) );
      }
      else if ( _fgOrientation == 180 )
      {
         ret = ReadPixel( fg, float2( uv1.x + xProgress, uv1.y ) );
      }
      else if ( _fgOrientation == 270 )
      {
         ret = ReadPixel( fg, float2( uv1.x, uv1.y + yProgress ) );
      }
      else
      {
         ret = ReadPixel( fg, float2( uv1.x - xProgress, uv1.y ) );
      }
   }
   else
   {
      float w = abs( _bgExtents[ 2 ] - _bgExtents[ 0 ] );
      float h = abs( _bgExtents[ 3 ] - _bgExtents[ 1 ] );

      float xProgress = Progress * w;
      float yProgress = Progress * h;

      if ( _bgOrientation == 90 )
      {
         ret = ReadPixel( bg, float2( uv2.x, h - ( yProgress - uv2.y ) ) );
      }
      else if ( _bgOrientation == 180 )
      {
         ret = ReadPixel( bg, float2( ( uv2.x - w ) + xProgress, uv2.y ) );
      }
      else if ( _bgOrientation == 270 )
      {
         ret = ReadPixel( bg, float2( uv2.x, ( uv2.y - h ) + yProgress ) );
      }
      else
      {
         ret = ReadPixel( bg, float2( w - ( xProgress - uv2.x ), uv2.y ) );
      }
   }

   return ret;
}

//--------------------------------------------------------------
DeclareEntryPoint( PushDown )
{
   float4 ret;

   if ( uv0.y > Progress )
   {
      float xProgress = abs( Progress * ( _fgExtents[ 2 ] - _fgExtents[ 0 ] ) );
      float yProgress = abs( Progress * ( _fgExtents[ 3 ] - _fgExtents[ 1 ] ) );

      if ( _fgOrientation == 90 )
      {
         ret = ReadPixel( fg, float2( uv1.x + xProgress, uv1.y ) );
      }
      else if ( _fgOrientation == 180 )
      {
         ret = ReadPixel( fg, float2( uv1.x, uv1.y + yProgress ) );
      }
      else if ( _fgOrientation == 270 )
      {
         ret = ReadPixel( fg, float2( uv1.x - xProgress, uv1.y ) );
      }
      else
      {
         ret = ReadPixel( fg, float2( uv1.x, uv1.y - yProgress ) );
      }
   }
   else
   {
      float w = abs( _bgExtents[ 2 ] - _bgExtents[ 0 ] );
      float h = abs( _bgExtents[ 3 ] - _bgExtents[ 1 ] );

      float xProgress = Progress * w;
      float yProgress = Progress * h;

      if ( _bgOrientation == 90 )
      {
         ret = ReadPixel( bg, float2( xProgress - ( w - uv2.x ), uv2.y ) );
      }
      else if ( _bgOrientation == 180 )
      {
         ret = ReadPixel( bg, float2( uv2.x, ( uv2.y - h ) + yProgress )  );
      }
      else if ( _bgOrientation == 270 )
      {
         ret = ReadPixel( bg, float2( w - ( xProgress - uv2.x ), uv2.y ) );
      }
      else
      {
         ret = ReadPixel( bg, float2( uv2.x, h - ( yProgress - uv2.y ) )  );
      }
   }

   return ret;
}

//--------------------------------------------------------------
DeclareEntryPoint( PushLeft )
{
   float4 ret;

      // Same as PushRight except going the other way, so :

   float progress = 1.0 - Progress;

   if ( uv0.x > progress )
   {
      float xProgress = abs( progress * ( _bgExtents[ 2 ] - _bgExtents[ 0 ] ) );
      float yProgress = abs( progress * ( _bgExtents[ 3 ] - _bgExtents[ 1 ] ) );

      if ( _bgOrientation == 90 )
      {
         ret = ReadPixel( bg, float2( uv2.x, uv2.y - yProgress  ) );
      }
      else if ( _bgOrientation == 180 )
      {
         ret = ReadPixel( bg, float2( uv2.x + xProgress, uv2.y ) );
      }
      else if ( _bgOrientation == 270 )
      {
         ret = ReadPixel( bg, float2( uv2.x, uv2.y + yProgress ) );
      }
      else
      {
         ret = ReadPixel( bg, float2( uv2.x - xProgress, uv2.y ) );
      }
   }
   else
   {
      float w = abs( _fgExtents[ 2 ] - _fgExtents[ 0 ] );
      float h = abs( _fgExtents[ 3 ] - _fgExtents[ 1 ] );

      float xProgress = progress * w;
      float yProgress = progress * h;

      if ( _fgOrientation == 90 )
      {
         ret = ReadPixel( fg, float2( uv1.x, h - ( yProgress - uv1.y ) ) );
      }
      else if ( _fgOrientation == 180 )
      {
         ret = ReadPixel( fg, float2( ( uv1.x - w ) + xProgress, uv1.y ) );
      }
      else if ( _fgOrientation == 270 )
      {
         ret = ReadPixel( fg, float2( uv1.x, ( uv1.y - h ) + yProgress ) );
      }
      else
      {
         ret = ReadPixel( fg, float2( w - ( xProgress - uv1.x ), uv1.y ) );
      }
   }

   return ret;
}

//--------------------------------------------------------------//
DeclareEntryPoint( PushUp )
{
   float4 ret;

   // Same as PushDown except going the other way, so :

   float progress = 1.0 - Progress;

   if ( uv0.y > progress )
   {
      float xProgress = abs( progress * ( _bgExtents[ 2 ] - _bgExtents[ 0 ] ) );
      float yProgress = abs( progress * ( _bgExtents[ 3 ] - _bgExtents[ 1 ] ) );

      if ( _bgOrientation == 90 )
      {
         ret = ReadPixel( bg, float2( uv2.x + xProgress, uv2.y ) );
      }
      else if ( _bgOrientation == 180 )
      {
         ret = ReadPixel( bg, float2( uv2.x, uv2.y + yProgress ) );
      }
      else if ( _bgOrientation == 270 )
      {
         ret = ReadPixel( bg, float2( uv2.x - xProgress, uv2.y ) );
      }
      else
      {
         ret = ReadPixel( bg, float2( uv2.x, uv2.y - yProgress ) );
      }
   }
   else
   {
      float w = abs( _fgExtents[ 2 ] - _fgExtents[ 0 ] );
      float h = abs( _fgExtents[ 3 ] - _fgExtents[ 1 ] );

      float xProgress = progress * w;
      float yProgress = progress * h;

      if ( _fgOrientation == 90 )
      {
         ret = ReadPixel( fg, float2( xProgress - ( w - uv1.x ), uv1.y ) );
      }
      else if ( _fgOrientation == 180 )
      {
         ret = ReadPixel( fg, float2( uv1.x, ( uv1.y - h ) + yProgress )  );
      }
      else if ( _fgOrientation == 270 )
      {
         ret = ReadPixel( fg, float2( w - ( xProgress - uv1.x ), uv1.y ) );
      }
      else
      {
         ret = ReadPixel( fg, float2( uv1.x, h - ( yProgress - uv1.y ) )  );
      }
   }

   return ret;
}
