//--------------------------------------------------------------
// Lumakey
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Lumakey", "Key", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Tolerance,    "Tolerance",     kNoGroup, kNoFlags, 0.5, 0.0, 1.0 );
DeclareFloatParam( EdgeSoftness, "Edge Softness", kNoGroup, kNoFlags, 0.1, 0.0, 1.0 );
DeclareBoolParam( Invert, "Invert", kNoGroup, false );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInputs( Fg, Bg );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 ret;
   float4 src1 = ReadPixel( Fg, uv1 );
   float4 src2 = ReadPixel( Bg, uv2 );

   float srcLum = ( ( src1.r * 0.3 ) + ( src1.g * 0.59 ) + ( src1.b * 0.11 ) );

   if ( Invert )
   {
      float softStart = Tolerance;
      float softEnd   = softStart + EdgeSoftness;

      if ( srcLum > softEnd )
      {
         ret = src2;
      }
      else
      {
         if ( srcLum > softStart )
         {
            ret = lerp( src1, src2, ( srcLum - softStart ) / EdgeSoftness );
         }
         else
         {
            ret = src1;
         }
      }
   }
   else
   {
      float softStart = 1.0 - Tolerance;
      float softEnd   = softStart + EdgeSoftness;

      if ( srcLum > softEnd )
      {
         ret = src1;
      }
      else
      {
         if ( srcLum > softStart )
         {
            ret = lerp( src2, src1, ( srcLum - softStart ) / EdgeSoftness );
         }
         else
         {
            ret = src2;
         }
      }
   }

   float4 src = Invert ? src1 : src2;
   float2 pos = Invert ? uv1 : uv2;
   return lerp(src, ret, tex2D( Mask, pos ));
}
