//--------------------------------------------------------------//
// Lumakey
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//

int _LwksEffectInfo
<
   string EffectGroup = "GenericPixelShader";
   string Description = "DVE";
   string Category    = "DVEs";
> = 0;

//--------------------------------------------------------------//
// Params
//--------------------------------------------------------------//
float CentreX
<
   string Description = "Position";
   string Flags = "SpecifiesPointX";
   float MinVal = -1.00;
   float MaxVal = 2.00;
> = 0.5;

float CentreY
<
   string Description = "Position";
   string Flags = "SpecifiesPointY";
   float MinVal = -1.00;
   float MaxVal = 2.00;
> = 0.5;

float XScale
<
   string Description = "X Scale";
   string Group = "Scale";
   float MinVal = 0.00;
   float MaxVal = 10.00;
> = 1.0;

float YScale
<
   string Description = "Y Scale";
   string Group = "Scale";
   float MinVal = 0.00;
   float MaxVal = 10.00;
> = 1.0;

float CropLeft
<
   string Description = "Left";
   string Group = "Crop";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.0;

float CropTop
<
   string Description = "Top";
   string Group = "Crop";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.0;

float CropRight
<
   string Description = "Right";
   string Group = "Crop";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.0;

float CropBottom
<
   string Description = "Bottom";
   string Group = "Crop";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.0;

float ShadowTransparency
<
   string Description = "Transparency";
   string Group = "Shadow";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.75;

float ShadowXOffset
<
   string Description = "X Offset";
   string Group = "Shadow";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float ShadowYOffset
<
   string Description = "Y Offset";
   string Group = "Shadow";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float Opacity
<
   string Description = "Opacity";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 1.0;

float _MaxShadowOffset = 0.2;

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
texture Fg;
sampler FgSampler = sampler_state
{
   Texture = <Fg>;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
   MAGFILTER = LINEAR;
};

float _FgNormWidth = 1.0;
float _FgWidth  = 10.0;
float _FgHeight = 10.0;

texture Bg;
sampler2D BgSampler = sampler_state { Texture = <Bg>; };

//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//
float4 ps_main( float2 xyNorm : TEXCOORD0, float2 xy1 : TEXCOORD1, float2 xy2 : TEXCOORD2 ) : COLOR
{
   float4 ret;

//   float x             = ( ( CentreX - 0.5 ) * ( XScale + 1 ) ) + 0.5;
//   float y             = ( ( 0.5 - CentreY ) * ( YScale + 1 ) ) + 0.5;
   float x             = CentreX;
   float y             = 1.0 - CentreY;
   float l             = x - ( XScale / 2 );
   float t             = y - ( YScale / 2 );
   float r             = l + XScale;
   float b             = t + YScale;
   float croppedL      = l + ( CropLeft * XScale );
   float croppedT      = t + ( CropTop  * YScale );
   float croppedR      = r - ( CropRight * XScale );
   float croppedB      = b - ( CropBottom * YScale );
   float scaledXShadow = ShadowXOffset * _MaxShadowOffset;
   float scaledYShadow = ShadowYOffset * _MaxShadowOffset;
   float shadowL       = croppedL + scaledXShadow;
   float shadowR       = croppedR + scaledXShadow;
   float shadowT       = croppedT + scaledYShadow;
   float shadowB       = croppedB + scaledYShadow;
   float2 texAddressAdjust = float2( 0.5 / _FgWidth, 0.5 / _FgHeight );

   float4 bgPixel = tex2D( BgSampler, xy2 );

   if ( xyNorm.x < croppedL ||  xyNorm.x > croppedR || xyNorm.y < croppedT || xyNorm.y > croppedB )
   {
      if ( ShadowXOffset != 0 || ShadowYOffset != 0 )
      {
         if ( xyNorm.x > shadowL && xyNorm.x < shadowR && xyNorm.y > shadowT && xyNorm.y < shadowB )
         {
            ret = lerp( 0, bgPixel, ShadowTransparency );
            ret = lerp( bgPixel, ret, Opacity );
         }
         else
         {
            ret = bgPixel;
         }
      }
      else
      {
         ret = bgPixel;
      }
   }
   else
   {
      float2 fgPos = float2( ( xyNorm.x - l ) / XScale, ( xyNorm.y - t ) / YScale );

      // Remember that the texCoords for the FG may not be 0 -> 1
      fgPos.x *= _FgNormWidth;
      fgPos += texAddressAdjust;

      if ( Opacity != 1.0 )
      {
         ret = lerp( tex2D( BgSampler, xy2 ), tex2D( FgSampler, fgPos ), Opacity );
      }
      else
      {
         ret = tex2D( FgSampler, fgPos );
      }

      ret   = lerp( bgPixel, ret, ret.a );
      ret.a = 1.0;
   }

   return ret;
}

//--------------------------------------------------------------//
// Techniques
//--------------------------------------------------------------//
technique DVE { pass Single_Pass { PixelShader = compile PROFILE ps_main(); } }
