//-----------------------------------------------------------------------------------------
// TextOutline.fx
//
// Credits : khaver & schrauber
//-----------------------------------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( TextEffects, Text, Internal, kNoNotes, CanSize );

//-----------------------------------------------------------------------------------------
// Inputs & Samplers
//-----------------------------------------------------------------------------------------
DeclareInput( Input );

//-----------------------------------------------------------------------------------------
// Parameters
//-----------------------------------------------------------------------------------------
DeclareFloatParam( Size, "Radius", kNoGroup, kNoFlags, 0.1, 0.0, 100.0 );
DeclareFloatParam( Width, "Width", kNoGroup, kNoFlags, 1920.0f, 0.0, 10000.0 );
DeclareFloatParam( Height, "Height", kNoGroup, kNoFlags, 1080.0f, 0.0, 10000.0 );
DeclareColourParam( Colour, "Colour",  kNoGroup, kNoFlags, 0.7,0.4,0.9,0.5 );
//-----------------------------------------------------------------------------------------
// Definitions and declarations
//-----------------------------------------------------------------------------------------
DeclareFloatParam( _OutputHeight);
DeclareFloatParam( _OutputWidth );

//-----------------------------------------------------------------------------------------
// Shaders
//-----------------------------------------------------------------------------------------
float4 textOutline( float2 uv, sampler2D blurSampler, int run )
{
   float2 pixelSize = (1.0f/ Width, 1.0f/ Width);
   float2 halfpix = pixelSize / 2.0;
   float asp = Width/Height;
   float2 coord, sample;

   float4 cOut = tex2D( blurSampler, uv );//- halfpix );
   //cOut.rgb *= cOut.a;

   for( float tap = 0.0f; tap < 12.0f; tap += 1.0f )
   {
      //sincos( ( tap * 30 ) + run, sample.y, sample.x );   
     // 30 is the rotation angle between the 12 samples, 5 is the additional rotation of all rotation angles per pass (30? / 6 pass = 5?).
      sample.y = sin( (tap * 30.0f) + float(run) )*asp;
      sample.x = cos( (tap * 30.0f) + float(run) );
      coord = uv + (halfpix * Size * sample);
      
      float4 pixel = tex2D( blurSampler, coord );
      //pixel.rgb *= pixel.a;
      
      cOut += pixel;
   }

cOut /= 5.0f;
   return cOut;
}

DeclarePass( P1 )
{
   return textOutline( uv1, Input, 0 );
}

DeclarePass( P2 )
{
   return textOutline( uv1, P1, 5 );
}

DeclarePass( P3 )
{
   return textOutline( uv1, P2, 10 );
}

DeclarePass( P4 )
{
   return textOutline( uv1, P3, 15 );
}

DeclarePass( P5 )
{
   return textOutline( uv1, P4, 20 );
}

DeclarePass( P6 )
{
   return textOutline( uv1, P5, 25 );
}

DeclareEntryPoint()
{
   float4 outline = ReadPixel( P6, uv1 );

   if(outline.a > 1.0f) outline.a = 1.0f;
   
   outline.a *= Colour.a;
   outline.r = Colour.r;
   outline.g = Colour.g;
   outline.b = Colour.b;
   
   return outline;
}
