//--------------------------------------------------------------
// RGBToYCrCb444.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( RGBToYCrCb444, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( gSourceImage, Point, Clamp );

DeclareFloatParam( Width );
DeclareFloat3Param( coefsAdd );
DeclareFloat3x3Param( coefsMul );
DeclareIntParam( includeAlpha );
//DeclareFloatParam( Normalise );
#define Half_10Bit (0.5/1024.0)

//------------------------------------------------------------------------
DeclareEntryPoint()
{
   // U and V (Cr and Cb) samples are co-sited with every Y-sample
   float4 ret;

   // 0,0.25,0.5,0.75
   float2 uv1q = float2( uv1.x - 0.75 / Width, uv1.y );

   // Y'CbCr
   ret.gab = mul( tex2D(gSourceImage, uv1q ).rgb, coefsMul ) + coefsAdd;

   // Rounding correction
   ret.gab += Half_10Bit;

   // full range alpha upto 16-bit
   if ( includeAlpha == 1 )
     ret.r = tex2D( gSourceImage, uv1q ).a;
   else
     ret.r = 1;

   return ret;
}
