//--------------------------------------------------------------//
// RGBToARGB
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( RGBToARGB, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input, Point );

DeclareFloatParam( _Width );

DeclareEntryPoint()
{
   float4 ret;

   float2 uvr;

   // shift a quarter pixel right
   uvr.x = uv1.x + 0.25 / _Width;
   uvr.y = uv1.y;

   int x = int( fmod( uv1.x * _Width, 4 ) );

   if ( x == 0 )
   {
      float4 src = tex2D( Input, uvr );

      ret.r = src.r;
      ret.g = src.g;
      ret.b = src.b;
   }
   else if ( x == 1 )
   {
      float4 srcl = tex2D( Input, uv2 );
      float4 srcr = tex2D( Input, uvr );

      ret.r = srcl.a;
      ret.g = srcr.r;
      ret.b = srcr.g;
   }
   else if ( x == 2 )
   {
      float4 srcl = tex2D( Input, uv2 );
      float4 srcr = tex2D( Input, uvr );

      ret.r = srcl.b;
      ret.g = srcl.a;
      ret.b = srcr.r;
   }
   else if ( x == 3 )
   {
      float4 src = tex2D( Input, uvr );

      ret.r = src.g;
      ret.g = src.b;
      ret.b = src.a;
   }

   ret.a = 1.;

   return ret;
}
