//--------------------------------------------------------------
// Ellipse.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( Ellipse, "Internal", "Matte", kNoNotes, kNoFlags );

DeclareColourParam( LineColour, "Line Colour", kNoGroup, kNoFlags, 0,1,0,1 );
DeclareColourParam( FillColour, "Fill Colour", kNoGroup, kNoFlags, 0,0,0,0 );
DeclareFloatParam( Softness,   "Softness", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );
DeclareFloatParam( Thickness,  "Thickness", kNoGroup, kNoFlags, 0.05, 0.0, 1.0 );
DeclareFloatParam( StartAngle, "Start Angle", kNoGroup, kNoFlags, 0.0, 0, 6.28 );
DeclareFloatParam( EndAngle,   "End Angle", kNoGroup, kNoFlags, 6.28, 0.0, 6.28 );

float _pi     = 3.14159;
float _pi2    = 6.2831853;

DeclareEntryPoint()
{
   float4 outputPixel = float4( 0, 0, 0, 0 );
   
   float2 pos = 2.0 * ( uv1 - 0.5 );
   float currentPixelAngle = atan2( -pos.y, -pos.x ) + _pi;  // -> 0..2pi, clockwise from 3-o-clock 
   
   if ( ( EndAngle > _pi2 ) && ( currentPixelAngle < fmod( EndAngle, _pi2 ) ) )
   {
      currentPixelAngle += _pi2;
   }

   if ( ( StartAngle == EndAngle ) || ( smoothstep( currentPixelAngle, StartAngle, EndAngle ) == 0 ) )
   {
      float dist = length( pos );
      float fillAmount = smoothstep( 1 - Softness, 1, dist );
      float lineAmount = smoothstep( 1 - ( Softness + Thickness ), 1 - Thickness, dist ) - fillAmount;

      outputPixel = lerp( lerp( FillColour, float4( 0,0,0,0 ), fillAmount ), LineColour, lineAmount * LineColour.a );
   }

   return outputPixel;
}
