//--------------------------------------------------------------
// DeadPixelFix.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( "DeadPixelFix", "Internal", "Components", kNoNotes, kNoFlags );

//------------------------------------------------------------------------
// Inputs
//------------------------------------------------------------------------
DeclareInput( Input, Point );

DeclareFloatParam( PixelX,     "PixelX",     kNoGroup, kNoFlags, 0.5, 0, 1 );
DeclareFloatParam( PixelY,     "PixelY",     kNoGroup, kNoFlags, 0.5, 0, 1 );
DeclareFloatParam( HalfPixelW, "HalfPixelW", kNoGroup, kNoFlags, 0.0009, 0, 1 );
DeclareFloatParam( HalfPixelH, "HalfPixelH", kNoGroup, kNoFlags, 0.0009, 0, 1 );

//------------------------------------------------------------------------
// Code
//------------------------------------------------------------------------
DeclareEntryPoint()
{
   float4 source = tex2D( Input, uv1 );
   float4 result = source;

   if ( ( abs( uv1.x - PixelX ) < HalfPixelW ) && ( abs( uv1.y - PixelY ) < HalfPixelH ) )
   {
      float2 offset = float2( 2 * HalfPixelW, 0 );

      float4 left  = tex2D( Input, uv1 - offset );
      float4 right = tex2D( Input, uv1 + offset );

      result = lerp( left, right, 0.5f );
   }

   return result;
}
