//--------------------------------------------------------------
// Colour Temperature
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Colour Temperature", "Colour", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
float4 _ColdColour = float4( 0.0, 0.8, 1.0, 1.0 );
float4 _HotColour  = float4( 1.0, 0.5, 0.0, 1.0 );

DeclareFloatParam( Amount, "Temperature", kNoGroup, kNoFlags, 0.0, -1.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 src = ReadPixel( Input, uv1 );
   float4 ret;

   float oldLum  = ( src.r * 0.3 ) + ( src.g * 0.59 ) + ( src.b * 0.11 );

   if ( Amount > 0 )
   {
      ret = lerp( src, _HotColour, Amount / 5 );
   }
   else
   {
      ret = lerp( _ColdColour, src, 1 + ( Amount / 5 ) );
   }

   float newLum  = ( ret.r * 0.3 ) + ( ret.g * 0.59 ) + ( ret.b * 0.11 );

   // Try to retain a similar luminance
   ret -= ( newLum - oldLum );

   ret.a = src.a;

   return lerp( src, ret, tex2D( Mask, uv1 ));
}
