//-----------------------------------------------------------------------------------------
// BigBlur.fx
//
// Credits : khaver & schrauber
//-----------------------------------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Blur", "Stylize", "Components", "High quality blur using a rotating Poisson distribution", kNoFlags );

//-----------------------------------------------------------------------------------------
// Inputs & Samplers
//-----------------------------------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//-----------------------------------------------------------------------------------------
// Parameters
//-----------------------------------------------------------------------------------------
DeclareFloatParam( Size, "Radius", kNoGroup, kNoFlags, 0.1, 0.0, 1.0 );

//-----------------------------------------------------------------------------------------
// Definitions and declarations
//-----------------------------------------------------------------------------------------
DeclareFloatParam( _OutputAspectRatio );
DeclareFloatParam( _OutputWidth );

//-----------------------------------------------------------------------------------------
// Shaders
//-----------------------------------------------------------------------------------------
float4 bigBlur( float2 uv, sampler2D blurSampler, int run )
{
   float blur = Size *_OutputWidth * 0.1;
   float2 pixelSize = float2 (1.0, _OutputAspectRatio) / _OutputWidth;

   float2 halfpix = pixelSize / 2.0;

   float2 coord, sample;

   float4 cOut = tex2D( blurSampler, uv - halfpix );
   cOut.rgb *= cOut.a;

   for (int tap = 0; tap < 12; tap++)
   {
      sincos( ( tap * 30 ) + run, sample.y, sample.x );   // 30 is the rotation angle between the 12 samples, 5 is the additional rotation of all rotation angles per pass (30 / 6 pass = 5).
      coord = uv + ( halfpix * sample * blur );

      float4 pixel = tex2D( blurSampler, coord );
      pixel.rgb *= pixel.a;

      cOut += pixel;
   }

   cOut /= 13.0;
   cOut.rgb /= cOut.a;

   return cOut;
}

DeclarePass( P1 )
{
   return bigBlur( uv1, Input, 0 );
}

DeclarePass( P2 )
{
   return bigBlur( uv1, P1, 5 );
}

DeclarePass( P3 )
{
   return bigBlur( uv1, P2, 10 );
}

DeclarePass( P4 )
{
   return bigBlur( uv1, P3, 15 );
}

DeclarePass( P5 )
{
   return bigBlur( uv1, P4, 20 );
}

DeclarePass( P6 )
{
   return bigBlur( uv1, P5, 25 );
}

DeclareEntryPoint()
{
   float4 fg   = ReadPixel( Input, uv1 );
   float4 blur = ReadPixel( P6, uv1 );

   return lerp( fg, blur, tex2D( Mask, uv1 ) );
}
