//--------------------------------------------------------------//
// BGR8ToARGB
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( NULL, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input, Point );

DeclareFloatParam( _Width );

DeclareEntryPoint()
{
   float4 ret;

   int x = int( fmod( uv1.x * _Width, 4 ) );

   // shift a quarter pixel right
   float2 uv1q = float2( uv1.x + 0.25 / _Width, uv1.y );

   if ( x == 0 )
   {
      float4 src = tex2D( Input, uv1q );

      ret.r = src.b;
      ret.g = src.g;
      ret.b = src.r;
   }
   else if ( x == 1 )
   {
      float4 srcl = tex2D( Input, uv2 );
      float4 srcr = tex2D( Input, uv1q );

      ret.r = srcl.a;
      ret.g = srcr.b;
      ret.b = srcr.g;
   }
   else if ( x == 2 )
   {
      float4 srcl = tex2D( Input, uv2 );
      float4 srcr = tex2D( Input, uv1q );

      ret.r = srcl.r;
      ret.g = srcl.a;
      ret.b = srcr.b;
   }
   else if ( x == 3 )
   {
      float4 src = tex2D( Input, uv1q );

      ret.r = src.g;
      ret.g = src.r;
      ret.b = src.a;
   }

   ret.a = 1.;

   return ret;
}
