/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.json.JsonWriter;
import net.sf.mpxj.mpx.MPXWriter;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.planner.PlannerWriter;
import net.sf.mpxj.primavera.PrimaveraPMFileWriter;
import net.sf.mpxj.sdef.SDEFWriter;
import net.sf.mpxj.writer.ProjectWriter;

public final class ProjectWriterUtility {
    private static final Map<String, Class<? extends ProjectWriter>> WRITER_MAP = new HashMap<String, Class<? extends ProjectWriter>>();

    private ProjectWriterUtility() {
    }

    public static ProjectWriter getProjectWriter(String name) throws InstantiationException, IllegalAccessException {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("Filename has no extension: " + name);
        }
        String extension = name.substring(index + 1).toUpperCase();
        Class<? extends ProjectWriter> fileClass = WRITER_MAP.get(extension);
        if (fileClass == null) {
            throw new IllegalArgumentException("Cannot write files of type: " + name);
        }
        return fileClass.newInstance();
    }

    public static Set<String> getSupportedFileExtensions() {
        return WRITER_MAP.keySet();
    }

    static {
        WRITER_MAP.put("MPX", MPXWriter.class);
        WRITER_MAP.put("XML", MSPDIWriter.class);
        WRITER_MAP.put("PMXML", PrimaveraPMFileWriter.class);
        WRITER_MAP.put("PLANNER", PlannerWriter.class);
        WRITER_MAP.put("JSON", JsonWriter.class);
        WRITER_MAP.put("SDEF", SDEFWriter.class);
    }
}

