/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Arrays;

public final class MPXJNumberFormat
extends DecimalFormat {
    private final DecimalFormatSymbols m_symbols = new DecimalFormatSymbols();
    private DecimalFormat[] m_alternativeFormats;

    public void applyPattern(String primaryPattern, String[] alternativePatterns, char decimalSeparator, char groupingSeparator) {
        this.m_symbols.setDecimalSeparator(decimalSeparator);
        this.m_symbols.setGroupingSeparator(groupingSeparator);
        this.setDecimalFormatSymbols(this.m_symbols);
        this.applyPattern(primaryPattern);
        if (alternativePatterns != null && alternativePatterns.length != 0) {
            int loop;
            if (this.m_alternativeFormats == null || this.m_alternativeFormats.length != alternativePatterns.length) {
                this.m_alternativeFormats = new DecimalFormat[alternativePatterns.length];
                for (loop = 0; loop < alternativePatterns.length; ++loop) {
                    this.m_alternativeFormats[loop] = new DecimalFormat();
                }
            }
            for (loop = 0; loop < alternativePatterns.length; ++loop) {
                this.m_alternativeFormats[loop].setDecimalFormatSymbols(this.m_symbols);
                this.m_alternativeFormats[loop].applyPattern(alternativePatterns[loop]);
            }
        }
    }

    @Override
    public Number parse(String str, ParsePosition parsePosition) {
        Number result = null;
        if (str == null) {
            parsePosition.setIndex(-1);
        } else if ((str = str.trim()).length() == 0) {
            parsePosition.setIndex(-1);
        } else {
            result = super.parse(str, parsePosition);
            if (parsePosition.getIndex() == 0) {
                result = null;
                if (this.m_alternativeFormats != null) {
                    for (DecimalFormat alternativeFormat : this.m_alternativeFormats) {
                        result = alternativeFormat.parse(str, parsePosition);
                        if (parsePosition.getIndex() != 0) break;
                    }
                    if (parsePosition.getIndex() == 0) {
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.m_alternativeFormats);
        result = 31 * result + (this.m_symbols == null ? 0 : this.m_symbols.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MPXJNumberFormat other = (MPXJNumberFormat)obj;
        if (!Arrays.equals(this.m_alternativeFormats, other.m_alternativeFormats)) {
            return false;
        }
        if (this.m_symbols == null) {
            return other.m_symbols == null;
        }
        return this.m_symbols.equals(other.m_symbols);
    }
}

