/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.CustomFieldValueDataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.CustomFieldValueReader;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public class CustomFieldValueReader14
extends CustomFieldValueReader {
    public CustomFieldValueReader14(ProjectProperties properties, CustomFieldContainer container, VarMeta outlineCodeVarMeta, Var2Data outlineCodeVarData, FixedData outlineCodeFixedData, FixedData outlineCodeFixedData2, Props taskProps) {
        super(properties, container, outlineCodeVarMeta, outlineCodeVarData, outlineCodeFixedData, outlineCodeFixedData2, taskProps);
    }

    @Override
    public void process() {
        int parentOffset;
        int fieldOffset;
        int typeOffset;
        Integer[] uniqueid = this.m_outlineCodeVarMeta.getUniqueIdentifierArray();
        if (NumberHelper.getInt(this.m_properties.getApplicationVersion()) > 14) {
            typeOffset = 16;
            fieldOffset = 18;
            parentOffset = 10;
        } else {
            fieldOffset = 16;
            typeOffset = 32;
            parentOffset = 8;
        }
        Map<UUID, FieldType> map = this.populateCustomFieldMap();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            byte[] b2;
            Integer id = uniqueid[loop];
            CustomFieldValueItem item = new CustomFieldValueItem(id);
            byte[] value = this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_VALUE);
            item.setDescription(this.m_outlineCodeVarData.getUnicodeString(id, VALUE_LIST_DESCRIPTION));
            item.setUnknown(this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_UNKNOWN));
            byte[] b = this.m_outlineCodeFixedData.getByteArrayValue(loop + 3);
            if (b != null) {
                item.setParent(MPPUtility.getShort(b, parentOffset));
            }
            if ((b2 = this.m_outlineCodeFixedData2.getByteArrayValue(loop + 3)) == null) continue;
            item.setGUID(MPPUtility.getGUID(b2, 0));
            UUID lookupTableGuid = MPPUtility.getGUID(b2, fieldOffset);
            item.setType(CustomFieldValueDataType.getInstance(MPPUtility.getShort(b2, typeOffset)));
            item.setValue(this.getTypedValue(item.getType(), value));
            this.m_container.registerValue(item);
            FieldType field = map.get(lookupTableGuid);
            if (field == null) continue;
            CustomFieldLookupTable table = this.m_container.getOrCreate(field).getLookupTable();
            table.add(item);
            table.setGUID(lookupTableGuid);
        }
    }

    private Map<UUID, FieldType> populateCustomFieldMap() {
        HashMap<UUID, FieldType> map = new HashMap<UUID, FieldType>();
        byte[] data = this.m_taskProps.getByteArray(Props.CUSTOM_FIELDS);
        if (data != null) {
            int length = MPPUtility.getInt(data, 0);
            int index = length + 36;
            while (index + 52 <= data.length) {
                int extendedAttributeFieldID = MPPUtility.getInt(data, index);
                FieldType field = FieldTypeHelper.getInstance(extendedAttributeFieldID);
                UUID lookupTableGuid = MPPUtility.getGUID(data, index + 36);
                map.put(lookupTableGuid, field);
                index += 88;
            }
        }
        return map;
    }
}

