/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.asta.ColumnDefinition;
import net.sf.mpxj.asta.TableDefinition;

abstract class AbstractFileFormat {
    private static final ColumnDefinition[] PROJECT_SUMMARY_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("PROJECT_SUMMARYID", 4), new ColumnDefinition("DURATIONTYPF", 4), new ColumnDefinition("DURATIONELA_MONTHS", 4), new ColumnDefinition("DURATIONHOURS", 8), new ColumnDefinition("STARU", 93), new ColumnDefinition("ENE", 93), new ColumnDefinition("FISCAL_YEAR_START", 93), new ColumnDefinition("LAST_ID_USED_IN_BASELINE", 4), new ColumnDefinition("DS_ID_BOOKED_FROM", 4), new ColumnDefinition("WBN_CONSTRAINT", 4), new ColumnDefinition("WBN_RANGE_FROM", 4), new ColumnDefinition("WBN_RANGE_TO", 4), new ColumnDefinition("WBN_INCREMENT", 4), new ColumnDefinition("WBN_MINIMUM_WIDTH", 4), new ColumnDefinition("SPARF_INTEGER", 4), new ColumnDefinition("UTID_CONSTRAINT", 4), new ColumnDefinition("UTID_START_VALUE", 4), new ColumnDefinition("UTID_INCREMENT", 4), new ColumnDefinition("UTID_SUB_INCREMENT", 4), new ColumnDefinition("UTID_MINIMUM_WIDTH", 4), new ColumnDefinition("INITIAL_VIEW", 4), new ColumnDefinition("POINT_RELEASE", 4), new ColumnDefinition("TIMESHEET_PROJECT_ID", 4), new ColumnDefinition("LAST_ID_USED_IN_ARCHIVES", 4), new ColumnDefinition("PROJECT_VERSION", 4), new ColumnDefinition("STANDARD_WORK_MIN_FADE", 4), new ColumnDefinition("BOOKOUT_SET_UNIQUE_ID", 4), new ColumnDefinition("NUMBER_BOOKED_OUT_SETS", 4), new ColumnDefinition("SHORT_NAME", 12), new ColumnDefinition("LONG_NAME", 12), new ColumnDefinition("LOCAL_FILE_BOOKED_FROM", 12), new ColumnDefinition("WBN_START_VALUE", 12), new ColumnDefinition("WBN_PATHNAME_SEPARATOR", 12), new ColumnDefinition("WBN_TASK_SEPARATOR", 12), new ColumnDefinition("WBN_PREFIX", 12), new ColumnDefinition("LAST_WBN_USED", 12), new ColumnDefinition("PROJECT_FOR", 12), new ColumnDefinition("PROJECT_BY", 12), new ColumnDefinition("PATH_SEPARATOR", 12), new ColumnDefinition("CHART_PATH_SEPARATOR", 12), new ColumnDefinition("UTID_PREFIX", 12), new ColumnDefinition("TIMESHEET_CONNECTION", 12), new ColumnDefinition("WBS_PATH_SEPARATOR", 12), new ColumnDefinition("PROJECT_GUID", 12), new ColumnDefinition("DURATION_TIME_UNIT", 4), new ColumnDefinition("SECURITY_CODELIBRARY", 4), new ColumnDefinition("BOOKOUT_COUNTER", 4), new ColumnDefinition("PROGRESS_METHOD", 4), new ColumnDefinition("FORMULA_DATE_FORMAT", 4), new ColumnDefinition("WBN_ENABLED", -7), new ColumnDefinition("OLD_START_VALUE", -7), new ColumnDefinition("IGNORE_SATISFIED_COSTS", -7), new ColumnDefinition("UTID_ENABLE_SUB_INCREMENTS", -7), new ColumnDefinition("EXCLUSIVE_CUSTOM_TIME_UNITS", -7), new ColumnDefinition("IS_AN_ARCHIVE", -7), new ColumnDefinition("SORT_BY_SORT_ORDER", -7), new ColumnDefinition("USE_PROJECT_BASELINES_FOR_JP", -7), new ColumnDefinition("USE_ROLLED_UP_OPC_WEIGHTINGS", -7), new ColumnDefinition("DISPLAY_WBS_BY_CODE", -7), new ColumnDefinition("INHERIT_FROM_NEIGHBOUR", -7), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4), new ColumnDefinition("SCALE_SPR_FONTS_CONSISTENTLY", 4)};
    private static final ColumnDefinition[] BAR_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("BARID", 4), new ColumnDefinition("STARV", 93), new ColumnDefinition("ENF", 93), new ColumnDefinition("NATURAL_ORDER", 4), new ColumnDefinition("SPARI_INTEGER", 4), new ColumnDefinition("NAMH", 12), new ColumnDefinition("EXPANDED_TASK", 4), new ColumnDefinition("PRIORITY", 4), new ColumnDefinition("UNSCHEDULABLE", -7), new ColumnDefinition("MARK_FOR_HIDING", -7), new ColumnDefinition("TASKS_MAY_OVERLAP", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] CALENDAR_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("CALENDARID", 4), new ColumnDefinition("SPARL_INTEGER", 4), new ColumnDefinition("NAMK", 12), new ColumnDefinition("DOMINANT_WORK_PATTERN", 4), new ColumnDefinition("CALENDAR", 4), new ColumnDefinition("DISPLAY_THRESHOLD", 4), new ColumnDefinition("NO_WORKING_TIME_COLOUR", 4), new ColumnDefinition("WORKING_TIME_COLOUR", 4), new ColumnDefinition("NUMBERING", 4), new ColumnDefinition("SHOW_PAST_DATES", -7), new ColumnDefinition("ISO8601_WEEK_NUMBERING", -7), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] EXCEPTIONN_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("EXCEPTIONNID", 4), new ColumnDefinition("ARR_STOUT_STAPPANDARROW_TYPE", 4), new ColumnDefinition("ARR_STOUT_STAPPANDLENGTH", 4), new ColumnDefinition("ARR_STOUT_STAPPANDEDGE", 4), new ColumnDefinition("ARR_STOUT_STAPPANDBORDET_COL", 4), new ColumnDefinition("ARR_STOUT_STAPPANDINSIDG_COL", 4), new ColumnDefinition("ARR_STOUT_STAPPANDPLACEMENW", 4), new ColumnDefinition("BLI_STOUT_STAPPANDBLIP_TYPE", 4), new ColumnDefinition("BLI_STOUT_STAPPANDSCALEY", 4), new ColumnDefinition("BLI_STOUT_STAPPANDSCALEZ", 4), new ColumnDefinition("BLI_STOUT_STAPPANDGAP", 4), new ColumnDefinition("BLI_STOUT_STAPPANDBORDES_COL", 4), new ColumnDefinition("BLI_STOUT_STAPPANDINSIDF_COL", 4), new ColumnDefinition("BLI_STOUT_STAPPANDPLACEMENV", 4), new ColumnDefinition("LIN_STOUT_STAPPANDSCALEX", 8), new ColumnDefinition("LIN_STOUT_STAPPANDWIDTH", 4), new ColumnDefinition("LIN_STOUT_STAPPANDBORDER_COL", 4), new ColumnDefinition("LIN_STOUT_STAPPANDINSIDE_COL", 4), new ColumnDefinition("LIN_STOUT_STAPPANDLINE_TYPE", 4), new ColumnDefinition("APPANDFOREGROUND_FILL_COLOUR", 4), new ColumnDefinition("APPANDBACKGROUND_FILL_COLOUR", 4), new ColumnDefinition("APPANDPATTERN", 4), new ColumnDefinition("UNIQUE_BIT_FIELD", 4), new ColumnDefinition("NAML", 12), new ColumnDefinition("TYPG", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4), new ColumnDefinition("SORT_ORDER", 4)};
    private static final ColumnDefinition[] EXCEPTION_ASSIGNMENT_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("EXCEPTION_ASSIGNMENTID", 4), new ColumnDefinition("STARU_DATE", 93), new ColumnDefinition("ENE_DATE", 93), new ColumnDefinition("EXCEPTIOO", 4)};
    private static final ColumnDefinition[] TIME_ENTRY_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("TIME_ENTRYID", 4), new ColumnDefinition("EXCEPTIOP", 4), new ColumnDefinition("START_TIME", 92), new ColumnDefinition("END_TIME", 92)};
    private static final ColumnDefinition[] WORK_PATTERN_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("WORK_PATTERNID", 4), new ColumnDefinition("DEFAULT_OFFSET", 4), new ColumnDefinition("NAMN", 12), new ColumnDefinition("DEFAULT_ALIGNMENT_DATE", 93), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] TASK_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("TASKID", 4), new ColumnDefinition("GIVEN_DURATIONTYPF", 4), new ColumnDefinition("GIVEN_DURATIONELA_MONTHS", 4), new ColumnDefinition("GIVEN_DURATIONHOURS", 8), new ColumnDefinition("RESUME", 93), new ColumnDefinition("GIVEN_START", 93), new ColumnDefinition("LATEST_PROGRESS_PERIOD", 4), new ColumnDefinition("TASK_WORK_RATE_TIME_UNIT", 4), new ColumnDefinition("TASK_WORK_RATE", 8), new ColumnDefinition("PLACEMENT", 4), new ColumnDefinition("BEEN_SPLIT", -7), new ColumnDefinition("INTERRUPTIBLE", -7), new ColumnDefinition("HOLDING_PIN", -7), new ColumnDefinition("ACTUAL_DURATIONTYPF", 4), new ColumnDefinition("ACTUAL_DURATIONELA_MONTHS", 4), new ColumnDefinition("ACTUAL_DURATIONHOURS", 8), new ColumnDefinition("EARLY_START_DATE", 93), new ColumnDefinition("LATE_START_DATE", 93), new ColumnDefinition("FREE_START_DATE", 93), new ColumnDefinition("START_CONSTRAINT_DATE", 93), new ColumnDefinition("END_CONSTRAINT_DATE", 93), new ColumnDefinition("EFFORT_BUDGET", 8), new ColumnDefinition("NATURAO_ORDER", 4), new ColumnDefinition("LOGICAL_PRECEDENCE", 4), new ColumnDefinition("SPAVE_INTEGER", 4), new ColumnDefinition("SWIM_LANE", 4), new ColumnDefinition("USER_PERCENT_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENV_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENT_COMPL_WEIGHT", 8), new ColumnDefinition("NARE", 12), new ColumnDefinition("WBN_CODE", 12), new ColumnDefinition("NOTET", -1), new ColumnDefinition("UNIQUE_TASK_ID", 12), new ColumnDefinition("CALENDAU", 4), new ColumnDefinition("WBT", 4), new ColumnDefinition("EFFORT_TIMI_UNIT", 4), new ColumnDefinition("WORL_UNIT", 4), new ColumnDefinition("LATEST_ALLOC_PROGRESS_PERIOD", 4), new ColumnDefinition("WORN", 8), new ColumnDefinition("BAR", 4), new ColumnDefinition("CONSTRAINU", 4), new ColumnDefinition("PRIORITB", 4), new ColumnDefinition("CRITICAM", -7), new ColumnDefinition("USE_PARENU_CALENDAR", -7), new ColumnDefinition("BUFFER_TASK", -7), new ColumnDefinition("MARK_FOS_HIDING", -7), new ColumnDefinition("OWNED_BY_TIMESHEEV_X", -7), new ColumnDefinition("START_ON_NEX_DAY", -7), new ColumnDefinition("LONGEST_PATH", -7), new ColumnDefinition("DURATIOTTYPF", 4), new ColumnDefinition("DURATIOTELA_MONTHS", 4), new ColumnDefinition("DURATIOTHOURS", 8), new ColumnDefinition("STARZ", 93), new ColumnDefinition("ENJ", 93), new ColumnDefinition("DURATION_TIMJ_UNIT", 4), new ColumnDefinition("UNSCHEDULABLG", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4), new ColumnDefinition("IFC_PRODUCT_SET", 4), new ColumnDefinition("IFC_TASK_TYPE", 4)};
    private static final ColumnDefinition[] MILESTONE_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("MILESTONEID", 4), new ColumnDefinition("GIVEN_DATE_TIME", 93), new ColumnDefinition("PROGREST_PERIOD", 4), new ColumnDefinition("SYMBOL_APPEARANCE", 4), new ColumnDefinition("MILESTONE_TYPE", 4), new ColumnDefinition("PLACEMENU", 4), new ColumnDefinition("COMPLETED", -7), new ColumnDefinition("INTERRUPTIBLE_X", -7), new ColumnDefinition("ACTUAL_DURATIONTYPF", 4), new ColumnDefinition("ACTUAL_DURATIONELA_MONTHS", 4), new ColumnDefinition("ACTUAL_DURATIONHOURS", 8), new ColumnDefinition("EARLY_START_DATE", 93), new ColumnDefinition("LATE_START_DATE", 93), new ColumnDefinition("FREE_START_DATE", 93), new ColumnDefinition("START_CONSTRAINT_DATE", 93), new ColumnDefinition("END_CONSTRAINT_DATE", 93), new ColumnDefinition("EFFORT_BUDGET", 8), new ColumnDefinition("NATURAO_ORDER", 4), new ColumnDefinition("LOGICAL_PRECEDENCE", 4), new ColumnDefinition("SPAVE_INTEGER", 4), new ColumnDefinition("SWIM_LANE", 4), new ColumnDefinition("USER_PERCENT_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENV_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENT_COMPL_WEIGHT", 8), new ColumnDefinition("NARE", 12), new ColumnDefinition("WBN_CODE", 12), new ColumnDefinition("NOTET", -1), new ColumnDefinition("UNIQUE_TASK_ID", 12), new ColumnDefinition("CALENDAU", 4), new ColumnDefinition("WBT", 4), new ColumnDefinition("EFFORT_TIMI_UNIT", 4), new ColumnDefinition("WORL_UNIT", 4), new ColumnDefinition("LATEST_ALLOC_PROGRESS_PERIOD", 4), new ColumnDefinition("WORN", 8), new ColumnDefinition("BAR", 4), new ColumnDefinition("CONSTRAINU", 4), new ColumnDefinition("PRIORITB", 4), new ColumnDefinition("CRITICAM", -7), new ColumnDefinition("USE_PARENU_CALENDAR", -7), new ColumnDefinition("BUFFER_TASK", -7), new ColumnDefinition("MARK_FOS_HIDING", -7), new ColumnDefinition("OWNED_BY_TIMESHEEV_X", -7), new ColumnDefinition("START_ON_NEX_DAY", -7), new ColumnDefinition("LONGEST_PATH", -7), new ColumnDefinition("DURATIOTTYPF", 4), new ColumnDefinition("DURATIOTELA_MONTHS", 4), new ColumnDefinition("DURATIOTHOURS", 8), new ColumnDefinition("STARZ", 93), new ColumnDefinition("ENJ", 93), new ColumnDefinition("DURATION_TIMJ_UNIT", 4), new ColumnDefinition("UNSCHEDULABLG", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4), new ColumnDefinition("IFC_PRODUCT_SET", 4), new ColumnDefinition("IFC_TASK_TYPE", 4)};
    private static final ColumnDefinition[] EXPANDED_TASK_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("EXPANDED_TASKID", 4), new ColumnDefinition("VAR_DATE1COMM_ATTSFIXED_DATE", 93), new ColumnDefinition("VAR_DATE1COMM_ATTSBASE_DATE", 4), new ColumnDefinition("VAR_DATE2COMM_ATTSFIXED_DATE", 93), new ColumnDefinition("VAR_DATE2COMM_ATTSBASE_DATE", 4), new ColumnDefinition("VAR_DATE3COMM_ATTSFIXED_DATE", 93), new ColumnDefinition("VAR_DATE3COMM_ATTSBASE_DATE", 4), new ColumnDefinition("COMM_ATTSSCALE1", 8), new ColumnDefinition("COMM_ATTSSCALE2", 8), new ColumnDefinition("COMM_ATTSSCALE3", 8), new ColumnDefinition("COMM_ATTSNSCALES", 4), new ColumnDefinition("PERCENTAGE_LIKELIHOOD", 8), new ColumnDefinition("PROJ_RISK", 8), new ColumnDefinition("PROJ_PRIORITY", 8), new ColumnDefinition("SUM_WEIGHTS", 8), new ColumnDefinition("ISSUE_DATE", 93), new ColumnDefinition("REVISION_DATE", 93), new ColumnDefinition("PROJECT_BASELINE_ID", 4), new ColumnDefinition("DRAWN_BY", 12), new ColumnDefinition("REVISION_COMMENT", 12), new ColumnDefinition("CHART_MANAGER", 12), new ColumnDefinition("REVISION_NUMBER", 12), new ColumnDefinition("PROGRAMME_NUMBER", 12), new ColumnDefinition("COMMENU", 12), new ColumnDefinition("PROJ_TYPE", 12), new ColumnDefinition("PROJ_STATUS", 12), new ColumnDefinition("PROGRESU_PERIOD", 4), new ColumnDefinition("MANAGER_RESOURCE", 4), new ColumnDefinition("TYPH", 4), new ColumnDefinition("TAG_FIELD", 4), new ColumnDefinition("IS_PROJECT", -7), new ColumnDefinition("CONTAINS_PROJECTS", -7), new ColumnDefinition("CUMULATIVH_COSTCURRENCZ", 4), new ColumnDefinition("CUMULATIVH_COSTAMOUNT", 8), new ColumnDefinition("CUMULATIVH_INCOMECURRENCZ", 4), new ColumnDefinition("CUMULATIVH_INCOMEAMOUNT", 8), new ColumnDefinition("CUMULATIVE_ACTU_COSTCURRENCZ", 4), new ColumnDefinition("CUMULATIVE_ACTU_COSTAMOUNT", 8), new ColumnDefinition("CUMULATIV_DURATIONTYPF", 4), new ColumnDefinition("CUMULATIV_DURATIONELA_MONTHS", 4), new ColumnDefinition("CUMULATIV_DURATIONHOURS", 8), new ColumnDefinition("ACTUAL_CU_DURATIONTYPF", 4), new ColumnDefinition("ACTUAL_CU_DURATIONELA_MONTHS", 4), new ColumnDefinition("ACTUAL_CU_DURATIONHOURS", 8), new ColumnDefinition("ACTUAL_CUMULATIVE_QUANTITY", 8), new ColumnDefinition("CUMULATIVE_QUANTIT_REMAINING", 8), new ColumnDefinition("CUMULATIVE_EFFORT_P_COMPLETE", 8), new ColumnDefinition("CUMULATIVE_WORK_PER_COMPLETE", 8), new ColumnDefinition("CUMULATIVE_QUANTITY_COMPLETE", 8), new ColumnDefinition("MILESTONE_PERCENT_COMPLETE", 8), new ColumnDefinition("FIRST_PREFERRED_START", 93), new ColumnDefinition("CALCULATED_PROGRESS_DATE", 93), new ColumnDefinition("EARLIEST_PROGRESS_DATE", 93), new ColumnDefinition("LATEST_PROGRESS_DATE", 93), new ColumnDefinition("EARLY_END_DATE_RT", 93), new ColumnDefinition("LATE_END_DATE_RT", 93), new ColumnDefinition("FREE_END_DATE_RT", 93), new ColumnDefinition("CUMULATIVE_DEMANE_EFFORT", 8), new ColumnDefinition("CUMULATIVE_SCHEDULEE_EFFORT", 8), new ColumnDefinition("ACTUAL_CUMULATIVF_EFFORT", 8), new ColumnDefinition("CUMULATIVE_EFFORU_REMAINING", 8), new ColumnDefinition("ACTUAL_CUMULATIVE_WORK", 8), new ColumnDefinition("CUMULATIVE_WORK_REMAINING", 8), new ColumnDefinition("MILESTONES_DONE", 4), new ColumnDefinition("MILESTONES_REMAINING", 4), new ColumnDefinition("CUMULATIVE_EFFORT_TIME_UNIT", 4), new ColumnDefinition("CUMULATIVE_LATEST_PRO_PERIOD", 4), new ColumnDefinition("ACTUAL_DURATIONTYPF", 4), new ColumnDefinition("ACTUAL_DURATIONELA_MONTHS", 4), new ColumnDefinition("ACTUAL_DURATIONHOURS", 8), new ColumnDefinition("EARLY_START_DATE", 93), new ColumnDefinition("LATE_START_DATE", 93), new ColumnDefinition("FREE_START_DATE", 93), new ColumnDefinition("START_CONSTRAINT_DATE", 93), new ColumnDefinition("END_CONSTRAINT_DATE", 93), new ColumnDefinition("EFFORT_BUDGET", 8), new ColumnDefinition("NATURAO_ORDER", 4), new ColumnDefinition("LOGICAL_PRECEDENCE", 4), new ColumnDefinition("SPAVE_INTEGER", 4), new ColumnDefinition("SWIM_LANE", 4), new ColumnDefinition("USER_PERCENT_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENV_COMPLETE", 8), new ColumnDefinition("OVERALL_PERCENT_COMPL_WEIGHT", 8), new ColumnDefinition("NARE", 12), new ColumnDefinition("WBN_CODE", 12), new ColumnDefinition("NOTET", -1), new ColumnDefinition("UNIQUE_TASK_ID", 12), new ColumnDefinition("CALENDAU", 4), new ColumnDefinition("WBT", 4), new ColumnDefinition("EFFORT_TIMI_UNIT", 4), new ColumnDefinition("WORL_UNIT", 4), new ColumnDefinition("LATEST_ALLOC_PROGRESS_PERIOD", 4), new ColumnDefinition("WORN", 8), new ColumnDefinition("BAR", 4), new ColumnDefinition("CONSTRAINU", 4), new ColumnDefinition("PRIORITB", 4), new ColumnDefinition("CRITICAM", -7), new ColumnDefinition("USE_PARENU_CALENDAR", -7), new ColumnDefinition("BUFFER_TASK", -7), new ColumnDefinition("MARK_FOS_HIDING", -7), new ColumnDefinition("OWNED_BY_TIMESHEEV_X", -7), new ColumnDefinition("START_ON_NEX_DAY", -7), new ColumnDefinition("LONGEST_PATH", -7), new ColumnDefinition("DURATIOTTYPF", 4), new ColumnDefinition("DURATIOTELA_MONTHS", 4), new ColumnDefinition("DURATIOTHOURS", 8), new ColumnDefinition("STARZ", 93), new ColumnDefinition("ENJ", 93), new ColumnDefinition("DURATION_TIMJ_UNIT", 4), new ColumnDefinition("UNSCHEDULABLG", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4), new ColumnDefinition("NUMBER_OF_ACTIVITIES", 4), new ColumnDefinition("ONLY_PM_MAY_APPROVE", -7), new ColumnDefinition("IFC_PRODUCT_SET", 4), new ColumnDefinition("IFC_TASK_TYPE", 4)};
    private static final ColumnDefinition[] LINK_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("LINKID", 4), new ColumnDefinition("START_LAG_TIMETYPF", 4), new ColumnDefinition("START_LAG_TIMEELA_MONTHS", 4), new ColumnDefinition("START_LAG_TIMEHOURS", 8), new ColumnDefinition("END_LAG_TIMETYPF", 4), new ColumnDefinition("END_LAG_TIMEELA_MONTHS", 4), new ColumnDefinition("END_LAG_TIMEHOURS", 8), new ColumnDefinition("MAXIMUM_LAGTYPF", 4), new ColumnDefinition("MAXIMUM_LAGELA_MONTHS", 4), new ColumnDefinition("MAXIMUM_LAGHOURS", 8), new ColumnDefinition("STARV_DATE", 93), new ColumnDefinition("ENF_DATE", 93), new ColumnDefinition("CURVATURE_PERCENTAGE", 4), new ColumnDefinition("START_LAG_PERCENT_FLOAT", 8), new ColumnDefinition("END_LAG_PERCENT_FLOAT", 8), new ColumnDefinition("COMMENTS", 12), new ColumnDefinition("LINK_CATEGORY", 4), new ColumnDefinition("START_LAG_TIME_UNIT", 4), new ColumnDefinition("END_LAG_TIME_UNIT", 4), new ColumnDefinition("MAXIMUM_LAG_TIME_UNIT", 4), new ColumnDefinition("START_TASK", 4), new ColumnDefinition("END_TASK", 4), new ColumnDefinition("TYPI", 4), new ColumnDefinition("START_LAG_TYPE", 4), new ColumnDefinition("END_LAG_TYPE", 4), new ColumnDefinition("MAINTAIN_TASK_OFFSETS", 4), new ColumnDefinition("UNSCHEDULABLF", -7), new ColumnDefinition("CRITICAL", -7), new ColumnDefinition("ON_LOOP", -7), new ColumnDefinition("MAXIMUM_LAG_MODE", -7), new ColumnDefinition("ANNOTATE_LEAD_LAG", -7), new ColumnDefinition("START_REPOSITION_ON_TAS_MOVE", -7), new ColumnDefinition("END_REPOSITION_ON_TASK_MOVE", -7), new ColumnDefinition("DRAW_CURVED_IF_VERTICAL", -7), new ColumnDefinition("AUTOMATIC_CURVED_LI_SETTINGS", -7), new ColumnDefinition("DRAW_CURVED_LINK_TO_LEFT", -7), new ColumnDefinition("LOCAL_LINK", -7), new ColumnDefinition("DRIVING", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] CONSUMABLE_RESOURCE_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("CONSUMABLE_RESOURCEID", 4), new ColumnDefinition("COST_PER_UNITCURRENCZ", 4), new ColumnDefinition("COST_PER_UNITAMOUNT", 8), new ColumnDefinition("INCOME_PER_UNITCURRENCZ", 4), new ColumnDefinition("INCOME_PER_UNITAMOUNT", 8), new ColumnDefinition("COST_PER_USEDEFAULTSCURRENCZ", 4), new ColumnDefinition("COST_PER_USEDEFAULTSAMOUNT", 8), new ColumnDefinition("INCOME_P_USEDEFAULTSCURRENCZ", 4), new ColumnDefinition("INCOME_P_USEDEFAULTSAMOUNT", 8), new ColumnDefinition("DURATIOPDEFAULTSTYPF", 4), new ColumnDefinition("DURATIOPDEFAULTSELA_MONTHS", 4), new ColumnDefinition("DURATIOPDEFAULTSHOURS", 8), new ColumnDefinition("DELAZDEFAULTSTYPF", 4), new ColumnDefinition("DELAZDEFAULTSELA_MONTHS", 4), new ColumnDefinition("DELAZDEFAULTSHOURS", 8), new ColumnDefinition("DEFAULTSQUANTITY", 8), new ColumnDefinition("DEFAULTSACTIVITY_CONV_FACTOR", 8), new ColumnDefinition("DEFAULTSCONSUMPTION_RATE", 8), new ColumnDefinition("DEFAULTSCONSUMPTION_RAT_UNIT", 4), new ColumnDefinition("DEFAULTSDURATION_TIMG_UNIT", 4), new ColumnDefinition("DEFAULTSDELAY_TIMF_UNIT", 4), new ColumnDefinition("DEFAULTSEXPENDITURE_C_CENTRE", 4), new ColumnDefinition("DEFAULTSINCOME_COST_CENTRE", 4), new ColumnDefinition("DEFAULTSTYPM", 4), new ColumnDefinition("DEFAULTSCALCULATEE_PARAMETER", 4), new ColumnDefinition("DEFAULTSBALANCINH_PARAMETER", 4), new ColumnDefinition("DEFAULTSCONSUMPTION_RAT_TYPE", 4), new ColumnDefinition("DEFAULTSUSE_TASL_CALENDAR", -7), new ColumnDefinition("DEFAULTSALLOD_PROPORTIONALLY", -7), new ColumnDefinition("DEFAULTSCONSUMED", -7), new ColumnDefinition("DEFAULTSACCOUNTEDA_ELSEWHERE", -7), new ColumnDefinition("DEFAULTSMAY_BE_SHORTERA_TASK", -7), new ColumnDefinition("AVAILABLE_FROM", 93), new ColumnDefinition("AVAILABLE_TO", 93), new ColumnDefinition("MEASUREMENT", 12), new ColumnDefinition("CONSUMABLE_RESOURCE", 4), new ColumnDefinition("ARR_STOUT_STRES_APARROW_TYPE", 4), new ColumnDefinition("ARR_STOUT_STRES_APLENGTH", 4), new ColumnDefinition("ARR_STOUT_STRES_APEDGE", 4), new ColumnDefinition("ARR_STOUT_STRES_APBORDET_COL", 4), new ColumnDefinition("ARR_STOUT_STRES_APINSIDG_COL", 4), new ColumnDefinition("ARR_STOUT_STRES_APPLACEMENW", 4), new ColumnDefinition("BLI_STOUT_STRES_APBLIP_TYPE", 4), new ColumnDefinition("BLI_STOUT_STRES_APSCALEY", 4), new ColumnDefinition("BLI_STOUT_STRES_APSCALEZ", 4), new ColumnDefinition("BLI_STOUT_STRES_APGAP", 4), new ColumnDefinition("BLI_STOUT_STRES_APBORDES_COL", 4), new ColumnDefinition("BLI_STOUT_STRES_APINSIDF_COL", 4), new ColumnDefinition("BLI_STOUT_STRES_APPLACEMENV", 4), new ColumnDefinition("LIN_STOUT_STRES_APSCALEX", 8), new ColumnDefinition("LIN_STOUT_STRES_APWIDTH", 4), new ColumnDefinition("LIN_STOUT_STRES_APBORDER_COL", 4), new ColumnDefinition("LIN_STOUT_STRES_APINSIDE_COL", 4), new ColumnDefinition("LIN_STOUT_STRES_APLINE_TYPE", 4), new ColumnDefinition("RES_APFOREGROUND_FILL_COLOUR", 4), new ColumnDefinition("RES_APBACKGROUND_FILL_COLOUR", 4), new ColumnDefinition("RES_APPATTERN", 4), new ColumnDefinition("AVAILABILITY", 8), new ColumnDefinition("TOTAL_AVAILABILITY", 8), new ColumnDefinition("SPAWE_INTEGER", 4), new ColumnDefinition("NASE", 12), new ColumnDefinition("SHORT_NAME_SINGLE", 12), new ColumnDefinition("SHORT_NAME_PLURAL", 12), new ColumnDefinition("CALENDAV", 4), new ColumnDefinition("USE_PARENV_CALENDAR", -7), new ColumnDefinition("USE_LINE_STYLE_P_ALLOCATIONS", -7), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4), new ColumnDefinition("NO_NEW_ASSIGNMENTS", 4)};
    private static final ColumnDefinition[] PERMANENT_RESOURCE_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("PERMANENT_RESOURCEID", 4), new ColumnDefinition("EMAIL_ADDRESS", 12), new ColumnDefinition("EFFORT_TIME_UNIT", 4), new ColumnDefinition("PURE_TREE", -7), new ColumnDefinition("EXCLUDED_FROM_TIMESHEET", -7), new ColumnDefinition("ARR_STOUT_STRES_APARROW_TYPE", 4), new ColumnDefinition("ARR_STOUT_STRES_APLENGTH", 4), new ColumnDefinition("ARR_STOUT_STRES_APEDGE", 4), new ColumnDefinition("ARR_STOUT_STRES_APBORDET_COL", 4), new ColumnDefinition("ARR_STOUT_STRES_APINSIDG_COL", 4), new ColumnDefinition("ARR_STOUT_STRES_APPLACEMENW", 4), new ColumnDefinition("BLI_STOUT_STRES_APBLIP_TYPE", 4), new ColumnDefinition("BLI_STOUT_STRES_APSCALEY", 4), new ColumnDefinition("BLI_STOUT_STRES_APSCALEZ", 4), new ColumnDefinition("BLI_STOUT_STRES_APGAP", 4), new ColumnDefinition("BLI_STOUT_STRES_APBORDES_COL", 4), new ColumnDefinition("BLI_STOUT_STRES_APINSIDF_COL", 4), new ColumnDefinition("BLI_STOUT_STRES_APPLACEMENV", 4), new ColumnDefinition("LIN_STOUT_STRES_APSCALEX", 8), new ColumnDefinition("LIN_STOUT_STRES_APWIDTH", 4), new ColumnDefinition("LIN_STOUT_STRES_APBORDER_COL", 4), new ColumnDefinition("LIN_STOUT_STRES_APINSIDE_COL", 4), new ColumnDefinition("LIN_STOUT_STRES_APLINE_TYPE", 4), new ColumnDefinition("RES_APFOREGROUND_FILL_COLOUR", 4), new ColumnDefinition("RES_APBACKGROUND_FILL_COLOUR", 4), new ColumnDefinition("RES_APPATTERN", 4), new ColumnDefinition("AVAILABILITY", 8), new ColumnDefinition("TOTAL_AVAILABILITY", 8), new ColumnDefinition("SPAWE_INTEGER", 4), new ColumnDefinition("NASE", 12), new ColumnDefinition("SHORT_NAME_SINGLE", 12), new ColumnDefinition("SHORT_NAME_PLURAL", 12), new ColumnDefinition("CALENDAV", 4), new ColumnDefinition("USE_PARENV_CALENDAR", -7), new ColumnDefinition("USE_LINE_STYLE_P_ALLOCATIONS", -7), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4), new ColumnDefinition("NO_NEW_ASSIGNMENTS", 4)};
    private static final ColumnDefinition[] PERMANENT_RESOURCE_SKILL_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("PERM_RESOURCE_SKILLID", 4), new ColumnDefinition("ARR_STOUT_STSKI_APARROW_TYPE", 4), new ColumnDefinition("ARR_STOUT_STSKI_APLENGTH", 4), new ColumnDefinition("ARR_STOUT_STSKI_APEDGE", 4), new ColumnDefinition("ARR_STOUT_STSKI_APBORDET_COL", 4), new ColumnDefinition("ARR_STOUT_STSKI_APINSIDG_COL", 4), new ColumnDefinition("ARR_STOUT_STSKI_APPLACEMENW", 4), new ColumnDefinition("BLI_STOUT_STSKI_APBLIP_TYPE", 4), new ColumnDefinition("BLI_STOUT_STSKI_APSCALEY", 4), new ColumnDefinition("BLI_STOUT_STSKI_APSCALEZ", 4), new ColumnDefinition("BLI_STOUT_STSKI_APGAP", 4), new ColumnDefinition("BLI_STOUT_STSKI_APBORDES_COL", 4), new ColumnDefinition("BLI_STOUT_STSKI_APINSIDF_COL", 4), new ColumnDefinition("BLI_STOUT_STSKI_APPLACEMENV", 4), new ColumnDefinition("LIN_STOUT_STSKI_APSCALEX", 8), new ColumnDefinition("LIN_STOUT_STSKI_APWIDTH", 4), new ColumnDefinition("LIN_STOUT_STSKI_APBORDER_COL", 4), new ColumnDefinition("LIN_STOUT_STSKI_APINSIDE_COL", 4), new ColumnDefinition("LIN_STOUT_STSKI_APLINE_TYPE", 4), new ColumnDefinition("SKI_APFOREGROUND_FILL_COLOUR", 4), new ColumnDefinition("SKI_APBACKGROUND_FILL_COLOUR", 4), new ColumnDefinition("SKI_APPATTERN", 4), new ColumnDefinition("DURATIOODEFAULTTTYPF", 4), new ColumnDefinition("DURATIOODEFAULTTELA_MONTHS", 4), new ColumnDefinition("DURATIOODEFAULTTHOURS", 8), new ColumnDefinition("DELAYDEFAULTTTYPF", 4), new ColumnDefinition("DELAYDEFAULTTELA_MONTHS", 4), new ColumnDefinition("DELAYDEFAULTTHOURS", 8), new ColumnDefinition("DEFAULTTALLOCATION", 8), new ColumnDefinition("DEFAULTTWORK_FROM_ACT_FACTOR", 8), new ColumnDefinition("DEFAULTTEFFORT", 8), new ColumnDefinition("DEFAULTTWORL", 8), new ColumnDefinition("DEFAULTTWORK_RATE", 8), new ColumnDefinition("DEFAULTTWORK_UNIT", 4), new ColumnDefinition("DEFAULTTWORK_RATE_TIME_UNIT", 4), new ColumnDefinition("DEFAULTTEFFORT_TIMG_UNIT", 4), new ColumnDefinition("DEFAULTTDURATION_TIMF_UNIT", 4), new ColumnDefinition("DEFAULTTDELAY_TIME_UNIT", 4), new ColumnDefinition("DEFAULTTTYPL", 4), new ColumnDefinition("DEFAULTTCALCULATED_PARAMETER", 4), new ColumnDefinition("DEFAULTTBALANCING_PARAMETER", 4), new ColumnDefinition("DEFAULTTWORK_RATE_TYPE", 4), new ColumnDefinition("DEFAULTTUSE_TASK_CALENDAR", -7), new ColumnDefinition("DEFAULTTALLOC_PROPORTIONALLY", -7), new ColumnDefinition("DEFAULTTCAN_BE_SPLIT", -7), new ColumnDefinition("DEFAULTTCAN_BE_DELAYED", -7), new ColumnDefinition("DEFAULTTCAN_BE_STRETCHED", -7), new ColumnDefinition("DEFAULTTACCOUNTED__ELSEWHERE", -7), new ColumnDefinition("DEFAULTTCONTRIBUTES_T_EFFORT", -7), new ColumnDefinition("DEFAULTTMAY_BE_SHORTER__TASK", -7), new ColumnDefinition("DEFAULTTSHARED_EFFORT", -7), new ColumnDefinition("ABILITY", 8), new ColumnDefinition("EFFECTIVENESS", 8), new ColumnDefinition("AVAILABILITY", 8), new ColumnDefinition("AVAILABLF_FROM", 93), new ColumnDefinition("AVAILABLF_TO", 93), new ColumnDefinition("SPARO_INTEGER", 4), new ColumnDefinition("EFFORT_TIMF_UNIT", 4), new ColumnDefinition("ROLE", 4), new ColumnDefinition("PLAYER", 4), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] PERMANENT_SCHEDULE_ALLOCATION_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("PERMANENT_SCHEDUL_ALLOCATIONID", 4), new ColumnDefinition("REQUIREE_BY", 4), new ColumnDefinition("OWNED_BY_TIMESHEET_X", -7), new ColumnDefinition("EFFORW", 8), new ColumnDefinition("GIVEN_EFFORT", 8), new ColumnDefinition("WORK_FROM_TASK_FACTOR", 8), new ColumnDefinition("ALLOCATIOO", 8), new ColumnDefinition("GIVEN_ALLOCATION", 8), new ColumnDefinition("ALLOCATIOP_OF", 4), new ColumnDefinition("WORM_UNIT", 4), new ColumnDefinition("WORK_RATE_TIMF_UNIT", 4), new ColumnDefinition("EFFORT_TIMJ_UNIT", 4), new ColumnDefinition("WORO", 8), new ColumnDefinition("GIVEN_WORK", 8), new ColumnDefinition("WORL_RATE", 8), new ColumnDefinition("GIVEN_WORK_RATE", 8), new ColumnDefinition("TYPV", 4), new ColumnDefinition("CALCULATEG_PARAMETER", 4), new ColumnDefinition("BALANCINJ_PARAMETER", 4), new ColumnDefinition("SHAREE_EFFORT", -7), new ColumnDefinition("CONTRIBUTES_TO_ACTIVI_EFFORT", -7), new ColumnDefinition("DELAATYPF", 4), new ColumnDefinition("DELAAELA_MONTHS", 4), new ColumnDefinition("DELAAHOURS", 8), new ColumnDefinition("GIVEO_DURATIONTYPF", 4), new ColumnDefinition("GIVEO_DURATIONELA_MONTHS", 4), new ColumnDefinition("GIVEO_DURATIONHOURS", 8), new ColumnDefinition("DELAY_TIMI_UNIT", 4), new ColumnDefinition("RATE_TYPE", 4), new ColumnDefinition("USE_TASM_CALENDAR", -7), new ColumnDefinition("IGNORF", -7), new ColumnDefinition("ELAPSEE", -7), new ColumnDefinition("MAY_BE_SHORTER_THAN_TASK", -7), new ColumnDefinition("RESUMF", 93), new ColumnDefinition("SPAXE_INTEGER", 4), new ColumnDefinition("PERCENT_COMPLETE", 8), new ColumnDefinition("USER_PERCENU_COMPLETE", 8), new ColumnDefinition("ALLOCATIOR_GROUP", 4), new ColumnDefinition("ALLOCATEE_TO", 4), new ColumnDefinition("PRIORITC", 4), new ColumnDefinition("ACCOUNTED_FOR_ELSEWHERE", -7), new ColumnDefinition("DURATIOTTYPF", 4), new ColumnDefinition("DURATIOTELA_MONTHS", 4), new ColumnDefinition("DURATIOTHOURS", 8), new ColumnDefinition("STARZ", 93), new ColumnDefinition("ENJ", 93), new ColumnDefinition("DURATION_TIMJ_UNIT", 4), new ColumnDefinition("UNSCHEDULABLG", -7), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4), new ColumnDefinition("TIMESHEET_ROUND_UP_IF_UNDER", 4), new ColumnDefinition("TIMESHEET_CAP_IF_OVER", 4), new ColumnDefinition("BUDGETED_COST_CURRENCY", 4), new ColumnDefinition("BUDGETED_COST_AMOUNT", 8), new ColumnDefinition("FLAGS", 4), new ColumnDefinition("ALLOCATION_PROFILE", 12), new ColumnDefinition("RESOURCE_CURVE", 4), new ColumnDefinition("NONLINEAR_TYPE", 4)};
    private static final ColumnDefinition[] WBS_ENTRY_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("WBS_ENTRYID", 4), new ColumnDefinition("NATURAP_ORDER", 4), new ColumnDefinition("WBT_CODE", 12), new ColumnDefinition("WBT_NAME", 12), new ColumnDefinition("WBS_ENTRY", 4), new ColumnDefinition("CREATED_AS_FOLDER", -7), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};
    private static final ColumnDefinition[] TASK_COMPLETED_SECTION_COLUMNS = new ColumnDefinition[]{new ColumnDefinition("TASK_COMPLETED_SECTIONID", 4), new ColumnDefinition("NATURAM_ORDER", 4), new ColumnDefinition("OVERALL_PERCENT_COMPLETE", 8), new ColumnDefinition("ACTUAL_TASK_WORK", 8), new ColumnDefinition("TASK", 4), new ColumnDefinition("ACTUAL_START", 93), new ColumnDefinition("ACTUAL_END", 93), new ColumnDefinition("SPAUE_INTEGER", 4), new ColumnDefinition("DURATIOTTYPF", 4), new ColumnDefinition("DURATIOTELA_MONTHS", 4), new ColumnDefinition("DURATIOTHOURS", 8), new ColumnDefinition("STARZ", 93), new ColumnDefinition("ENJ", 93), new ColumnDefinition("DURATION_TIMJ_UNIT", 4), new ColumnDefinition("UNSCHEDULABLG", 4), new ColumnDefinition("SUBPROJECT_ID", 4), new ColumnDefinition("ALT_ID", 4), new ColumnDefinition("LAST_EDITED_DATE", 93), new ColumnDefinition("LAST_EDITED_BY", 4)};

    AbstractFileFormat() {
    }

    public Map<Integer, TableDefinition> tableDefinitions() {
        HashMap<Integer, TableDefinition> result = new HashMap<Integer, TableDefinition>();
        result.put(2, new TableDefinition("PROJECT_SUMMARY", this.columnDefinitions(PROJECT_SUMMARY_COLUMNS, this.projectSummaryColumnsOrder())));
        result.put(7, new TableDefinition("BAR", this.columnDefinitions(BAR_COLUMNS, this.barColumnsOrder())));
        result.put(11, new TableDefinition("CALENDAR", this.columnDefinitions(CALENDAR_COLUMNS, this.calendarColumnsOrder())));
        result.put(12, new TableDefinition("EXCEPTIONN", this.columnDefinitions(EXCEPTIONN_COLUMNS, this.exceptionColumnsOrder())));
        result.put(14, new TableDefinition("EXCEPTION_ASSIGNMENT", this.columnDefinitions(EXCEPTION_ASSIGNMENT_COLUMNS, this.exceptionAssignmentColumnsOrder())));
        result.put(15, new TableDefinition("TIME_ENTRY", this.columnDefinitions(TIME_ENTRY_COLUMNS, this.timeEntryColumnsOrder())));
        result.put(17, new TableDefinition("WORK_PATTERN", this.columnDefinitions(WORK_PATTERN_COLUMNS, this.workPatternColumnsOrder())));
        result.put(18, new TableDefinition("TASK_COMPLETED_SECTION", this.columnDefinitions(TASK_COMPLETED_SECTION_COLUMNS, this.taskCompletedSectionColumnsOrder())));
        result.put(21, new TableDefinition("TASK", this.columnDefinitions(TASK_COLUMNS, this.taskColumnsOrder())));
        result.put(22, new TableDefinition("MILESTONE", this.columnDefinitions(MILESTONE_COLUMNS, this.milestoneColumnsOrder())));
        result.put(23, new TableDefinition("EXPANDED_TASK", this.columnDefinitions(EXPANDED_TASK_COLUMNS, this.expandedTaskColumnsOrder())));
        result.put(25, new TableDefinition("LINK", this.columnDefinitions(LINK_COLUMNS, this.linkColumnsOrder())));
        result.put(61, new TableDefinition("CONSUMABLE_RESOURCE", this.columnDefinitions(CONSUMABLE_RESOURCE_COLUMNS, this.consumableResourceColumnsOrder())));
        result.put(62, new TableDefinition("PERMANENT_RESOURCE", this.columnDefinitions(PERMANENT_RESOURCE_COLUMNS, this.permanentResourceColumnsOrder())));
        result.put(63, new TableDefinition("PERM_RESOURCE_SKILL", this.columnDefinitions(PERMANENT_RESOURCE_SKILL_COLUMNS, this.permanentResourceSkillColumnsOrder())));
        result.put(67, new TableDefinition("PERMANENT_SCHEDUL_ALLOCATION", this.columnDefinitions(PERMANENT_SCHEDULE_ALLOCATION_COLUMNS, this.permanentScheduleAllocationColumnsOrder())));
        result.put(190, new TableDefinition("WBS_ENTRY", this.columnDefinitions(WBS_ENTRY_COLUMNS, this.wbsEntryColumnsOrder())));
        return result;
    }

    public abstract boolean epochDateFormat();

    protected abstract String[] barColumnsOrder();

    protected abstract String[] calendarColumnsOrder();

    protected abstract String[] consumableResourceColumnsOrder();

    protected abstract String[] exceptionColumnsOrder();

    protected abstract String[] exceptionAssignmentColumnsOrder();

    protected abstract String[] expandedTaskColumnsOrder();

    protected abstract String[] linkColumnsOrder();

    protected abstract String[] milestoneColumnsOrder();

    protected abstract String[] permanentResourceSkillColumnsOrder();

    protected abstract String[] permanentResourceColumnsOrder();

    protected abstract String[] permanentScheduleAllocationColumnsOrder();

    protected abstract String[] projectSummaryColumnsOrder();

    protected abstract String[] taskColumnsOrder();

    protected abstract String[] timeEntryColumnsOrder();

    protected abstract String[] workPatternColumnsOrder();

    protected abstract String[] wbsEntryColumnsOrder();

    protected abstract String[] taskCompletedSectionColumnsOrder();

    private ColumnDefinition[] columnDefinitions(ColumnDefinition[] columns, String[] order) {
        Map<String, ColumnDefinition> map = this.makeColumnMap(columns);
        ColumnDefinition[] result = new ColumnDefinition[order.length];
        for (int index = 0; index < order.length; ++index) {
            result[index] = map.get(order[index]);
        }
        return result;
    }

    private Map<String, ColumnDefinition> makeColumnMap(ColumnDefinition[] columns) {
        HashMap<String, ColumnDefinition> map = new HashMap<String, ColumnDefinition>();
        for (ColumnDefinition def : columns) {
            map.put(def.getName(), def);
        }
        return map;
    }
}

