/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.Duration;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;

public final class Relation {
    private Integer m_uniqueID;
    private final Task m_sourceTask;
    private final Task m_targetTask;
    private RelationType m_type;
    private Duration m_lag;

    public Relation(Task sourceTask, Task targetTask, RelationType type, Duration lag) {
        this.m_sourceTask = sourceTask;
        this.m_targetTask = targetTask;
        this.m_type = type;
        this.m_lag = lag;
        if (this.m_type == null) {
            this.m_type = RelationType.FINISH_START;
        }
        if (this.m_lag == null) {
            this.m_lag = Duration.getInstance(0, TimeUnit.DAYS);
        }
    }

    public RelationType getType() {
        return this.m_type;
    }

    public Duration getLag() {
        return this.m_lag;
    }

    public Task getSourceTask() {
        return this.m_sourceTask;
    }

    public Task getTargetTask() {
        return this.m_targetTask;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public void setUniqueID(Integer uniqueID) {
        this.m_uniqueID = uniqueID;
    }

    public String toString() {
        return "[Relation lag: " + this.m_lag + " type: " + this.m_type + " " + this.m_sourceTask + " -> " + this.m_targetTask + "]";
    }
}

