/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.sf.mpxj.BaselineStrategy;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.TaskFieldLists;

public class DefaultBaselineStrategy
implements BaselineStrategy {
    private static final TaskField[] SOURCE_FIELDS = new TaskField[]{TaskField.COST, TaskField.DURATION, TaskField.FINISH, TaskField.FIXED_COST_ACCRUAL, TaskField.FIXED_COST, TaskField.START, TaskField.WORK};
    private static final TaskField[] BASELINE0_FIELDS = new TaskField[]{TaskField.BASELINE_COST, TaskField.BASELINE_DURATION, TaskField.BASELINE_FINISH, TaskField.BASELINE_FIXED_COST_ACCRUAL, TaskField.BASELINE_FIXED_COST, TaskField.BASELINE_START, TaskField.BASELINE_WORK};

    @Override
    public void clearBaseline(ProjectFile project, int index) {
        TaskField[] baselineFields = this.getBaselineFields(index);
        project.getTasks().forEach(t -> this.populateBaseline((Task)t, null, baselineFields));
    }

    @Override
    public void populateBaseline(ProjectFile project, ProjectFile baseline, int index) {
        TaskField[] baselineFields = this.getBaselineFields(index);
        Map<Object, Task> map = baseline.getTasks().stream().filter(t -> this.getKeyForTask((Task)t) != null).collect(Collectors.toMap(this::getKeyForTask, t -> t, (u, v) -> null));
        project.getTasks().forEach(t -> this.populateBaseline((Task)t, (Task)map.get(this.getKeyForTask((Task)t)), baselineFields));
    }

    private void populateBaseline(Task task, Task baseline, TaskField[] baselineFields) {
        TaskField[] sourceFields = this.getSourceFields();
        IntStream.range(0, sourceFields.length).forEach(i -> task.set((FieldType)baselineFields[i], baseline == null ? null : baseline.getCachedValue(sourceFields[i])));
    }

    protected Object getKeyForTask(Task task) {
        return task.getGUID();
    }

    protected TaskField[] getBaselineFields(int index) {
        TaskField[] fields = index == 0 ? BASELINE0_FIELDS : new TaskField[]{TaskFieldLists.BASELINE_COSTS[--index], TaskFieldLists.BASELINE_DURATIONS[index], TaskFieldLists.BASELINE_FINISHES[index], TaskFieldLists.BASELINE_FIXED_COST_ACCRUALS[index], TaskFieldLists.BASELINE_FIXED_COSTS[index], TaskFieldLists.BASELINE_STARTS[index], TaskFieldLists.BASELINE_WORKS[index]};
        return fields;
    }

    protected TaskField[] getSourceFields() {
        return SOURCE_FIELDS;
    }
}

