/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.util;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingUtils {
    private static final Logger LOGGER = Logger.getLogger(LoggingUtils.class.getName());
    private static Level defaultLevel = Level.FINE;

    private LoggingUtils() {
    }

    public static void setDefaultLevel(Level level) {
        Preconditions.checkNotNull(level, "The log level must not be null.");
        defaultLevel = level;
    }

    public static void logPropertyChanges(Object bean) {
        LoggingUtils.logPropertyChanges(bean, LOGGER);
    }

    public static void logPropertyChanges(Object bean, Logger logger) {
        LoggingUtils.logPropertyChanges(bean, logger, defaultLevel);
    }

    public static void logPropertyChanges(Object bean, Logger logger, Level level) {
        BeanUtils.addPropertyChangeListener(bean, new LogHandler(logger, level));
    }

    public static void logPropertyChanges(Object bean, String propertyName) {
        LoggingUtils.logPropertyChanges(bean, propertyName, LOGGER);
    }

    public static void logPropertyChanges(Object bean, String propertyName, Logger logger) {
        LoggingUtils.logPropertyChanges(bean, propertyName, logger, defaultLevel);
    }

    public static void logPropertyChanges(Object bean, String propertyName, Logger logger, Level level) {
        BeanUtils.addPropertyChangeListener(bean, propertyName, (PropertyChangeListener)new LogHandler(logger, level));
    }

    private static final class LogHandler
    implements PropertyChangeListener {
        private final Logger logger;
        private final Level level;

        LogHandler(Logger logger, Level level) {
            this.logger = Preconditions.checkNotNull(logger, "The logger must not be null.");
            this.level = Preconditions.checkNotNull(level, "The level must not be null.");
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!this.logger.isLoggable(this.level)) {
                return;
            }
            Object newValue = e.getNewValue();
            Object oldValue = e.getOldValue();
            StringBuilder builder = new StringBuilder(e.getSource().toString());
            builder.append(" [propertyName=");
            builder.append(e.getPropertyName());
            builder.append(", oldValue=");
            builder.append(oldValue);
            if (oldValue != null) {
                builder.append(", oldValueType=");
                builder.append(oldValue.getClass());
            }
            builder.append(", newValue=");
            builder.append(newValue);
            if (newValue != null) {
                builder.append(", newValueType=");
                builder.append(newValue.getClass());
            }
            this.logger.log(this.level, builder.toString());
        }
    }
}

