/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.IndexData;
import com.healthmarketscience.jackcess.impl.PageChannel;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class IndexPageCache {
    private static final int MAX_CACHE_SIZE = 25;
    private final IndexData _indexData;
    private DataPageMain _rootPage;
    private final Map<Integer, DataPageMain> _dataPages = new LinkedHashMap<Integer, DataPageMain>(16, 0.75f, true){
        private static final long serialVersionUID = 0L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, DataPageMain> e) {
            if (this.size() > 25 && !IndexPageCache.this.getPageChannel().isWriting()) {
                IndexPageCache.this.purgeOldPages();
            }
            return false;
        }
    };
    private final List<CacheDataPage> _modifiedPages = new ArrayList<CacheDataPage>();

    public IndexPageCache(IndexData indexData) {
        this._indexData = indexData;
    }

    public IndexData getIndexData() {
        return this._indexData;
    }

    public PageChannel getPageChannel() {
        return this.getIndexData().getPageChannel();
    }

    public void setRootPageNumber(int pageNumber) throws IOException {
        this._rootPage = this.getDataPage(pageNumber);
        this._rootPage.initParentPage(0, false);
    }

    public void write() throws IOException {
        this.handleEmptyPages();
        this.preparePagesForWriting();
        this.writeDataPages();
        if (this._dataPages.size() > 25) {
            this.purgeOldPages();
        }
    }

    private void handleEmptyPages() throws IOException {
        Iterator<CacheDataPage> iter = this._modifiedPages.iterator();
        while (iter.hasNext()) {
            CacheDataPage cacheDataPage = iter.next();
            if (!cacheDataPage._extra._entryView.isEmpty()) continue;
            if (!cacheDataPage._main.isRoot()) {
                this.deleteDataPage(cacheDataPage);
            } else {
                this.writeDataPage(cacheDataPage);
            }
            iter.remove();
        }
    }

    private void preparePagesForWriting() throws IOException {
        boolean splitPages = false;
        int maxPageEntrySize = this.getIndexData().getMaxPageEntrySize();
        do {
            splitPages = false;
            for (int i = 0; i < this._modifiedPages.size(); ++i) {
                CacheDataPage cacheDataPage = this._modifiedPages.get(i);
                if (!cacheDataPage.isLeaf()) {
                    DataPageMain dpMain = cacheDataPage._main;
                    int size = cacheDataPage._extra._entryView.size();
                    if (dpMain.hasChildTail()) {
                        if (size == 1) {
                            this.demoteTail(cacheDataPage);
                        }
                    } else if (size > 1) {
                        this.promoteTail(cacheDataPage);
                    }
                }
                if (cacheDataPage.getTotalEntrySize() <= maxPageEntrySize) continue;
                cacheDataPage._extra.updateEntryPrefix();
                if (cacheDataPage.getCompressedEntrySize() <= maxPageEntrySize) continue;
                splitPages = true;
                this.splitDataPage(cacheDataPage);
            }
        } while (splitPages);
    }

    private void writeDataPages() throws IOException {
        for (CacheDataPage cacheDataPage : this._modifiedPages) {
            if (cacheDataPage._extra._entryView.isEmpty()) {
                throw new IllegalStateException(this.withErrorContext("Unexpected empty page " + cacheDataPage));
            }
            this.writeDataPage(cacheDataPage);
        }
        this._modifiedPages.clear();
    }

    public CacheDataPage getCacheDataPage(Integer pageNumber) throws IOException {
        DataPageMain main = this.getDataPage(pageNumber);
        return main != null ? new CacheDataPage(main) : null;
    }

    private DataPageMain getDataPage(Integer pageNumber) throws IOException {
        DataPageMain dataPage = this._dataPages.get(pageNumber);
        if (dataPage == null && pageNumber > 0) {
            dataPage = this.readDataPage((Integer)pageNumber)._main;
            this._dataPages.put(pageNumber, dataPage);
        }
        return dataPage;
    }

    private void writeDataPage(CacheDataPage cacheDataPage) throws IOException {
        this.getIndexData().writeDataPage(cacheDataPage);
        cacheDataPage._extra._modified = false;
    }

    private void deleteDataPage(CacheDataPage cacheDataPage) throws IOException {
        this.getPageChannel().deallocatePage(cacheDataPage._main._pageNumber);
        this._dataPages.remove(cacheDataPage._main._pageNumber);
        cacheDataPage._extra._modified = false;
    }

    private CacheDataPage readDataPage(Integer pageNumber) throws IOException {
        DataPageMain dataPage = new DataPageMain(pageNumber);
        DataPageExtra extra = new DataPageExtra();
        CacheDataPage cacheDataPage = new CacheDataPage(dataPage, extra);
        this.getIndexData().readDataPage(cacheDataPage);
        dataPage.setExtra(extra);
        return cacheDataPage;
    }

    private IndexData.Entry removeEntry(CacheDataPage cacheDataPage, int entryIdx) throws IOException {
        return this.updateEntry(cacheDataPage, entryIdx, null, UpdateType.REMOVE);
    }

    private void addEntry(CacheDataPage cacheDataPage, int entryIdx, IndexData.Entry newEntry) throws IOException {
        this.updateEntry(cacheDataPage, entryIdx, newEntry, UpdateType.ADD);
    }

    private IndexData.Entry updateEntry(CacheDataPage cacheDataPage, int entryIdx, IndexData.Entry newEntry, UpdateType upType) throws IOException {
        boolean updateLast;
        DataPageMain dpMain = cacheDataPage._main;
        DataPageExtra dpExtra = cacheDataPage._extra;
        if (newEntry != null) {
            this.validateEntryForPage(dpMain, newEntry);
        }
        CacheDataPage parentDataPage = !dpMain.isRoot() ? new CacheDataPage(dpMain.getParentPage()) : null;
        IndexData.Entry oldLastEntry = dpExtra._entryView.getLast();
        IndexData.Entry oldEntry = null;
        int entrySizeDiff = 0;
        switch (upType) {
            case ADD: {
                dpExtra._entryView.add(entryIdx, newEntry);
                entrySizeDiff += newEntry.size();
                break;
            }
            case REPLACE: {
                oldEntry = dpExtra._entryView.set(entryIdx, newEntry);
                entrySizeDiff += newEntry.size() - oldEntry.size();
                break;
            }
            case REMOVE: {
                oldEntry = dpExtra._entryView.remove(entryIdx);
                entrySizeDiff -= oldEntry.size();
                break;
            }
            default: {
                throw new RuntimeException(this.withErrorContext("unknown update type " + (Object)((Object)upType)));
            }
        }
        boolean bl = updateLast = oldLastEntry != dpExtra._entryView.getLast();
        if (!updateLast || !dpMain.hasChildTail()) {
            dpExtra._totalEntrySize += entrySizeDiff;
            this.setModified(cacheDataPage);
            dpExtra._entryPrefix = IndexData.EMPTY_PREFIX;
        }
        if (dpExtra._entryView.isEmpty()) {
            this.removeDataPage(parentDataPage, cacheDataPage, oldLastEntry);
            return oldEntry;
        }
        if (!updateLast || dpMain.isRoot()) {
            return oldEntry;
        }
        this.replaceParentEntry(parentDataPage, cacheDataPage, oldLastEntry);
        return oldEntry;
    }

    private void removeDataPage(CacheDataPage parentDataPage, CacheDataPage cacheDataPage, IndexData.Entry oldLastEntry) throws IOException {
        DataPageMain dpMain = cacheDataPage._main;
        DataPageExtra dpExtra = cacheDataPage._extra;
        if (dpMain.hasChildTail()) {
            throw new IllegalStateException(this.withErrorContext("Still has child tail?"));
        }
        if (dpExtra._totalEntrySize != 0) {
            throw new IllegalStateException(this.withErrorContext("Empty page but size is not 0? " + dpExtra._totalEntrySize + ", " + cacheDataPage));
        }
        if (dpMain.isRoot()) {
            dpExtra._entryPrefix = IndexData.EMPTY_PREFIX;
            dpMain._leaf = true;
            return;
        }
        this.updateParentEntry(parentDataPage, cacheDataPage, oldLastEntry, null, UpdateType.REMOVE);
        this.removeFromPeers(cacheDataPage);
    }

    private void removeFromPeers(CacheDataPage cacheDataPage) throws IOException {
        DataPageMain nextMain;
        DataPageMain dpMain = cacheDataPage._main;
        Integer prevPageNumber = dpMain._prevPageNumber;
        Integer nextPageNumber = dpMain._nextPageNumber;
        DataPageMain prevMain = dpMain.getPrevPage();
        if (prevMain != null) {
            this.setModified(new CacheDataPage(prevMain));
            prevMain._nextPageNumber = nextPageNumber;
        }
        if ((nextMain = dpMain.getNextPage()) != null) {
            this.setModified(new CacheDataPage(nextMain));
            nextMain._prevPageNumber = prevPageNumber;
        }
    }

    private void addParentEntry(CacheDataPage parentDataPage, CacheDataPage childDataPage) throws IOException {
        DataPageExtra childExtra = childDataPage._extra;
        this.updateParentEntry(parentDataPage, childDataPage, null, childExtra._entryView.getLast(), UpdateType.ADD);
    }

    private void replaceParentEntry(CacheDataPage parentDataPage, CacheDataPage childDataPage, IndexData.Entry oldEntry) throws IOException {
        DataPageExtra childExtra = childDataPage._extra;
        this.updateParentEntry(parentDataPage, childDataPage, oldEntry, childExtra._entryView.getLast(), UpdateType.REPLACE);
    }

    private void updateParentEntry(CacheDataPage parentDataPage, CacheDataPage childDataPage, IndexData.Entry oldEntry, IndexData.Entry newEntry, UpdateType upType) throws IOException {
        DataPageMain childMain = childDataPage._main;
        DataPageExtra parentExtra = parentDataPage._extra;
        if (childMain.isTail() && upType != UpdateType.REMOVE) {
            this.updateParentTail(parentDataPage, childDataPage, upType);
        }
        if (oldEntry != null) {
            oldEntry = oldEntry.asNodeEntry(childMain._pageNumber);
        }
        if (newEntry != null) {
            newEntry = newEntry.asNodeEntry(childMain._pageNumber);
        }
        boolean expectFound = true;
        int idx = 0;
        switch (upType) {
            case ADD: {
                expectFound = false;
                idx = parentExtra._entryView.find(newEntry);
                break;
            }
            case REPLACE: 
            case REMOVE: {
                idx = parentExtra._entryView.find(oldEntry);
                break;
            }
            default: {
                throw new RuntimeException(this.withErrorContext("unknown update type " + (Object)((Object)upType)));
            }
        }
        if (idx < 0) {
            if (expectFound) {
                throw new IllegalStateException(this.withErrorContext("Could not find child entry in parent; childEntry " + oldEntry + "; parent " + parentDataPage));
            }
            idx = IndexData.missingIndexToInsertionPoint(idx);
        } else if (!expectFound) {
            throw new IllegalStateException(this.withErrorContext("Unexpectedly found child entry in parent; childEntry " + newEntry + "; parent " + parentDataPage));
        }
        this.updateEntry(parentDataPage, idx, newEntry, upType);
        if (childMain.isTail() && upType == UpdateType.REMOVE) {
            this.updateParentTail(parentDataPage, childDataPage, upType);
        }
    }

    private void updateParentTail(CacheDataPage parentDataPage, CacheDataPage childDataPage, UpdateType upType) throws IOException {
        int newChildTailPageNumber;
        DataPageMain parentMain = parentDataPage._main;
        int n = newChildTailPageNumber = upType == UpdateType.REMOVE ? 0 : childDataPage._main._pageNumber;
        if (!parentMain.isChildTailPageNumber(newChildTailPageNumber)) {
            this.setModified(parentDataPage);
            parentMain._childTailPageNumber = newChildTailPageNumber;
        }
    }

    private void validateEntryForPage(DataPageMain dpMain, IndexData.Entry entry) {
        if (dpMain._leaf != entry.isLeafEntry()) {
            throw new IllegalStateException(this.withErrorContext("Trying to update page with wrong entry type; pageLeaf " + dpMain._leaf + ", entryLeaf " + entry.isLeafEntry()));
        }
    }

    private void splitDataPage(CacheDataPage origDataPage) throws IOException {
        DataPageMain origMain = origDataPage._main;
        DataPageExtra origExtra = origDataPage._extra;
        this.setModified(origDataPage);
        int numEntries = origExtra._entries.size();
        if (numEntries < 2) {
            throw new IllegalStateException(this.withErrorContext("Cannot split page with less than 2 entries " + origDataPage));
        }
        if (origMain.isRoot()) {
            CacheDataPage newDataPage;
            origDataPage = newDataPage = this.nestRootDataPage(origDataPage);
            origMain = newDataPage._main;
            origExtra = newDataPage._extra;
        }
        DataPageMain parentMain = origMain.getParentPage();
        CacheDataPage parentDataPage = new CacheDataPage(parentMain);
        CacheDataPage newDataPage = this.allocateNewCacheDataPage(parentMain._pageNumber, origMain._leaf);
        DataPageMain newMain = newDataPage._main;
        DataPageExtra newExtra = newDataPage._extra;
        List<IndexData.Entry> headEntries = origExtra._entries.subList(0, (numEntries + 1) / 2);
        for (IndexData.Entry headEntry : headEntries) {
            newExtra._totalEntrySize += headEntry.size();
            newExtra._entries.add(headEntry);
        }
        newExtra.setEntryView(newMain);
        headEntries.clear();
        origExtra._entryPrefix = IndexData.EMPTY_PREFIX;
        origExtra._totalEntrySize -= newExtra._totalEntrySize;
        this.addToPeersBefore(newDataPage, origDataPage);
        if (!newMain._leaf) {
            this.reparentChildren(newDataPage);
            DataPageMain childMain = newMain.getChildPage(newExtra._entryView.getLast());
            if (!childMain._leaf) {
                this.separateFromNextPeer(new CacheDataPage(childMain));
            }
        }
        this.addParentEntry(parentDataPage, newDataPage);
    }

    private CacheDataPage nestRootDataPage(CacheDataPage rootDataPage) throws IOException {
        DataPageMain rootMain = rootDataPage._main;
        DataPageExtra rootExtra = rootDataPage._extra;
        if (!rootMain.isRoot()) {
            throw new IllegalArgumentException(this.withErrorContext("should be called with root, duh"));
        }
        CacheDataPage newDataPage = this.allocateNewCacheDataPage(rootMain._pageNumber, rootMain._leaf);
        DataPageMain newMain = newDataPage._main;
        DataPageExtra newExtra = newDataPage._extra;
        newMain._childTailPageNumber = rootMain._childTailPageNumber;
        newExtra._entries = rootExtra._entries;
        newExtra._entryPrefix = rootExtra._entryPrefix;
        newExtra._totalEntrySize = rootExtra._totalEntrySize;
        newExtra.setEntryView(newMain);
        if (!newMain._leaf) {
            this.reparentChildren(newDataPage);
        }
        rootMain._leaf = false;
        rootMain._childTailPageNumber = 0;
        rootExtra._entries = new ArrayList<IndexData.Entry>();
        rootExtra._entryPrefix = IndexData.EMPTY_PREFIX;
        rootExtra._totalEntrySize = 0;
        rootExtra.setEntryView(rootMain);
        this.addParentEntry(rootDataPage, newDataPage);
        return newDataPage;
    }

    private CacheDataPage allocateNewCacheDataPage(Integer parentPageNumber, boolean isLeaf) throws IOException {
        DataPageMain dpMain = new DataPageMain(this.getPageChannel().allocateNewPage());
        DataPageExtra dpExtra = new DataPageExtra();
        dpMain.initParentPage(parentPageNumber, false);
        dpMain._leaf = isLeaf;
        dpMain._prevPageNumber = 0;
        dpMain._nextPageNumber = 0;
        dpMain._childTailPageNumber = 0;
        dpExtra._entries = new ArrayList<IndexData.Entry>();
        dpExtra._entryPrefix = IndexData.EMPTY_PREFIX;
        dpMain.setExtra(dpExtra);
        this._dataPages.put(dpMain._pageNumber, dpMain);
        this._indexData.addOwnedPage(dpMain._pageNumber);
        CacheDataPage cacheDataPage = new CacheDataPage(dpMain, dpExtra);
        this.setModified(cacheDataPage);
        return cacheDataPage;
    }

    private void addToPeersBefore(CacheDataPage newDataPage, CacheDataPage origDataPage) throws IOException {
        DataPageMain origMain = origDataPage._main;
        DataPageMain newMain = newDataPage._main;
        DataPageMain prevMain = origMain.getPrevPage();
        newMain._nextPageNumber = origMain._pageNumber;
        newMain._prevPageNumber = origMain._prevPageNumber;
        origMain._prevPageNumber = newMain._pageNumber;
        if (prevMain != null) {
            this.setModified(new CacheDataPage(prevMain));
            prevMain._nextPageNumber = newMain._pageNumber;
        }
    }

    private void separateFromNextPeer(CacheDataPage cacheDataPage) throws IOException {
        DataPageMain dpMain = cacheDataPage._main;
        this.setModified(cacheDataPage);
        DataPageMain nextMain = dpMain.getNextPage();
        this.setModified(new CacheDataPage(nextMain));
        nextMain._prevPageNumber = 0;
        dpMain._nextPageNumber = 0;
    }

    private void reparentChildren(CacheDataPage cacheDataPage) throws IOException {
        DataPageMain dpMain = cacheDataPage._main;
        DataPageExtra dpExtra = cacheDataPage._extra;
        for (IndexData.Entry entry : dpExtra._entryView) {
            Integer childPageNumber = entry.getSubPageNumber();
            DataPageMain childMain = this._dataPages.get(childPageNumber);
            if (childMain == null) continue;
            childMain.setParentPage(dpMain._pageNumber, dpMain.isChildTailPageNumber(childPageNumber));
        }
    }

    private void demoteTail(CacheDataPage cacheDataPage) throws IOException {
        DataPageMain dpMain = cacheDataPage._main;
        DataPageExtra dpExtra = cacheDataPage._extra;
        this.setModified(cacheDataPage);
        DataPageMain tailMain = dpMain.getChildTailPage();
        CacheDataPage tailDataPage = new CacheDataPage(tailMain);
        this.updateParentTail(cacheDataPage, tailDataPage, UpdateType.REMOVE);
        IndexData.Entry tailEntry = dpExtra._entryView.demoteTail();
        dpExtra._totalEntrySize += tailEntry.size();
        dpExtra._entryPrefix = IndexData.EMPTY_PREFIX;
        tailMain.setParentPage(dpMain._pageNumber, false);
    }

    private void promoteTail(CacheDataPage cacheDataPage) throws IOException {
        DataPageMain dpMain = cacheDataPage._main;
        DataPageExtra dpExtra = cacheDataPage._extra;
        this.setModified(cacheDataPage);
        DataPageMain lastMain = dpMain.getChildPage(dpExtra._entryView.getLast());
        CacheDataPage lastDataPage = new CacheDataPage(lastMain);
        this.updateParentTail(cacheDataPage, lastDataPage, UpdateType.ADD);
        IndexData.Entry lastEntry = dpExtra._entryView.promoteTail();
        dpExtra._totalEntrySize -= lastEntry.size();
        dpExtra._entryPrefix = IndexData.EMPTY_PREFIX;
        lastMain.setParentPage(dpMain._pageNumber, true);
    }

    public CacheDataPage findCacheDataPage(IndexData.Entry e) throws IOException {
        DataPageMain curPage = this._rootPage;
        while (!curPage._leaf) {
            DataPageExtra extra = curPage.getExtra();
            int idx = extra._entryView.find(e);
            if (idx < 0 && (idx = IndexData.missingIndexToInsertionPoint(idx)) == extra._entryView.size()) {
                --idx;
            }
            IndexData.Entry nodeEntry = extra._entryView.get(idx);
            curPage = curPage.getChildPage(nodeEntry);
        }
        return new CacheDataPage(curPage);
    }

    private void setModified(CacheDataPage cacheDataPage) {
        if (!cacheDataPage._extra._modified) {
            this._modifiedPages.add(cacheDataPage);
            cacheDataPage._extra._modified = true;
        }
    }

    private static byte[] findCommonPrefix(IndexData.Entry e1, IndexData.Entry e2) {
        int len;
        byte[] b1 = e1.getEntryBytes();
        byte[] b2 = e2.getEntryBytes();
        int maxLen = b1.length;
        byte[] prefix = b1;
        if (b1.length > b2.length) {
            maxLen = b2.length;
            prefix = b2;
        }
        for (len = 0; len < maxLen && b1[len] == b2[len]; ++len) {
        }
        if (len < prefix.length) {
            if (len == 0) {
                return IndexData.EMPTY_PREFIX;
            }
            prefix = ByteUtil.copyOf(prefix, len);
        }
        return prefix;
    }

    void validate() throws IOException {
        for (DataPageMain dpMain : new ArrayList<DataPageMain>(this._dataPages.values())) {
            DataPageExtra dpExtra = dpMain.getExtra();
            this.validateEntries(dpExtra);
            this.validateChildren(dpMain, dpExtra);
            this.validatePeers(dpMain);
        }
    }

    private void validateEntries(DataPageExtra dpExtra) throws IOException {
        int entrySize = 0;
        IndexData.Entry prevEntry = IndexData.FIRST_ENTRY;
        for (IndexData.Entry e : dpExtra._entries) {
            entrySize += e.size();
            if (prevEntry.compareTo(e) >= 0) {
                throw new IOException(this.withErrorContext("Unexpected order in index entries, " + prevEntry + " >= " + e));
            }
            prevEntry = e;
        }
        if (entrySize != dpExtra._totalEntrySize) {
            throw new IllegalStateException(this.withErrorContext("Expected size " + entrySize + " but was " + dpExtra._totalEntrySize));
        }
    }

    private void validateChildren(DataPageMain dpMain, DataPageExtra dpExtra) throws IOException {
        int childTailPageNumber = dpMain._childTailPageNumber;
        if (dpMain._leaf) {
            if (childTailPageNumber != 0) {
                throw new IllegalStateException(this.withErrorContext("Leaf page has tail " + dpMain));
            }
            return;
        }
        if (dpExtra._entryView.size() == 1 && dpMain.hasChildTail()) {
            throw new IllegalStateException(this.withErrorContext("Single child is tail " + dpMain));
        }
        for (IndexData.Entry e : dpExtra._entryView) {
            IndexData.Entry lastEntry;
            this.validateEntryForPage(dpMain, e);
            Integer subPageNumber = e.getSubPageNumber();
            DataPageMain childMain = this._dataPages.get(subPageNumber);
            if (childMain == null) continue;
            if (childMain._parentPageNumber != null) {
                boolean expectTail;
                if (childMain._parentPageNumber != dpMain._pageNumber) {
                    throw new IllegalStateException(this.withErrorContext("Child's parent is incorrect " + childMain));
                }
                boolean bl = expectTail = subPageNumber == childTailPageNumber;
                if (expectTail != childMain._tail) {
                    throw new IllegalStateException(this.withErrorContext("Child tail status incorrect " + childMain));
                }
            }
            if (e.compareTo(lastEntry = childMain.getExtra()._entryView.getLast()) == 0) continue;
            throw new IllegalStateException(this.withErrorContext("Invalid entry " + e + " but child is " + lastEntry));
        }
    }

    private void validatePeers(DataPageMain dpMain) throws IOException {
        DataPageMain nextMain;
        DataPageMain prevMain = this._dataPages.get(dpMain._prevPageNumber);
        if (prevMain != null) {
            if (prevMain._nextPageNumber != dpMain._pageNumber) {
                throw new IllegalStateException(this.withErrorContext("Prev page " + prevMain + " does not ref " + dpMain));
            }
            this.validatePeerStatus(dpMain, prevMain);
        }
        if ((nextMain = this._dataPages.get(dpMain._nextPageNumber)) != null) {
            if (nextMain._prevPageNumber != dpMain._pageNumber) {
                throw new IllegalStateException(this.withErrorContext("Next page " + nextMain + " does not ref " + dpMain));
            }
            this.validatePeerStatus(dpMain, nextMain);
        }
    }

    private void validatePeerStatus(DataPageMain dpMain, DataPageMain peerMain) throws IOException {
        if (dpMain._leaf != peerMain._leaf) {
            throw new IllegalStateException(this.withErrorContext("Mismatched peer status " + dpMain._leaf + " " + peerMain._leaf));
        }
        if (!dpMain._leaf && dpMain._parentPageNumber != null && peerMain._parentPageNumber != null && dpMain._parentPageNumber.intValue() != peerMain._parentPageNumber.intValue()) {
            throw new IllegalStateException(this.withErrorContext("Mismatched node parents " + dpMain._parentPageNumber + " " + peerMain._parentPageNumber));
        }
    }

    private List<Object> collectPages(List<Object> pages, DataPageMain dpMain) {
        try {
            CacheDataPage cacheDataPage = new CacheDataPage(dpMain);
            pages.add(cacheDataPage);
            if (!dpMain._leaf) {
                for (IndexData.Entry e : cacheDataPage._extra._entryView) {
                    DataPageMain childMain = dpMain.getChildPage(e);
                    this.collectPages(pages, childMain);
                }
            }
        }
        catch (IOException e) {
            pages.add("DataPage[" + dpMain._pageNumber + "]: <" + e + ">");
        }
        return pages;
    }

    private void purgeOldPages() {
        Iterator<DataPageMain> iter = this._dataPages.values().iterator();
        while (iter.hasNext()) {
            DataPageMain dpMain = iter.next();
            if (dpMain == this._rootPage) continue;
            iter.remove();
            if (this._dataPages.size() > 25) continue;
            break;
        }
    }

    public String toString() {
        ToStringBuilder sb = CustomToStringStyle.builder(this);
        if (this._rootPage == null) {
            sb.append("pages", "(uninitialized)");
        } else {
            sb.append("pages", this.collectPages(new ArrayList<Object>(), this._rootPage));
        }
        return sb.toString();
    }

    private String withErrorContext(String msg) {
        return this._indexData.withErrorContext(msg);
    }

    private static class EntryListView
    extends AbstractList<IndexData.Entry>
    implements RandomAccess {
        private final DataPageExtra _extra;
        private IndexData.Entry _childTailEntry;

        private EntryListView(DataPageMain main, DataPageExtra extra) throws IOException {
            if (main.hasChildTail()) {
                this._childTailEntry = main.getChildTailPage().getExtra()._entryView.getLast().asNodeEntry(main._childTailPageNumber);
            }
            this._extra = extra;
        }

        private List<IndexData.Entry> getEntries() {
            return this._extra._entries;
        }

        @Override
        public int size() {
            int size = this.getEntries().size();
            if (this.hasChildTail()) {
                ++size;
            }
            return size;
        }

        @Override
        public IndexData.Entry get(int idx) {
            return this.isCurrentChildTailIndex(idx) ? this._childTailEntry : this.getEntries().get(idx);
        }

        @Override
        public IndexData.Entry set(int idx, IndexData.Entry newEntry) {
            return this.isCurrentChildTailIndex(idx) ? this.setChildTailEntry(newEntry) : this.getEntries().set(idx, newEntry);
        }

        @Override
        public void add(int idx, IndexData.Entry newEntry) {
            this.getEntries().add(idx, newEntry);
        }

        @Override
        public IndexData.Entry remove(int idx) {
            return this.isCurrentChildTailIndex(idx) ? this.setChildTailEntry(null) : this.getEntries().remove(idx);
        }

        public IndexData.Entry setChildTailEntry(IndexData.Entry newEntry) {
            IndexData.Entry old = this._childTailEntry;
            this._childTailEntry = newEntry;
            return old;
        }

        private boolean hasChildTail() {
            return this._childTailEntry != null;
        }

        private boolean isCurrentChildTailIndex(int idx) {
            return idx == this.getEntries().size();
        }

        @Override
        public IndexData.Entry getLast() {
            return this.hasChildTail() ? this._childTailEntry : (!this.getEntries().isEmpty() ? this.getEntries().get(this.getEntries().size() - 1) : null);
        }

        public IndexData.Entry demoteTail() {
            IndexData.Entry tail = this._childTailEntry;
            this._childTailEntry = null;
            this.getEntries().add(tail);
            return tail;
        }

        public IndexData.Entry promoteTail() {
            IndexData.Entry last;
            this._childTailEntry = last = this.getEntries().remove(this.getEntries().size() - 1);
            return last;
        }

        public int find(IndexData.Entry e) {
            return Collections.binarySearch(this, e);
        }
    }

    private static final class CacheDataPage
    extends IndexData.DataPage {
        public final DataPageMain _main;
        public final DataPageExtra _extra;

        private CacheDataPage(DataPageMain dataPage) throws IOException {
            this(dataPage, dataPage.getExtra());
        }

        private CacheDataPage(DataPageMain dataPage, DataPageExtra extra) {
            this._main = dataPage;
            this._extra = extra;
        }

        @Override
        public int getPageNumber() {
            return this._main._pageNumber;
        }

        @Override
        public boolean isLeaf() {
            return this._main._leaf;
        }

        @Override
        public void setLeaf(boolean isLeaf) {
            this._main._leaf = isLeaf;
        }

        @Override
        public int getPrevPageNumber() {
            return this._main._prevPageNumber;
        }

        @Override
        public void setPrevPageNumber(int pageNumber) {
            this._main._prevPageNumber = pageNumber;
        }

        @Override
        public int getNextPageNumber() {
            return this._main._nextPageNumber;
        }

        @Override
        public void setNextPageNumber(int pageNumber) {
            this._main._nextPageNumber = pageNumber;
        }

        @Override
        public int getChildTailPageNumber() {
            return this._main._childTailPageNumber;
        }

        @Override
        public void setChildTailPageNumber(int pageNumber) {
            this._main._childTailPageNumber = pageNumber;
        }

        @Override
        public int getTotalEntrySize() {
            return this._extra._totalEntrySize;
        }

        @Override
        public void setTotalEntrySize(int totalSize) {
            this._extra._totalEntrySize = totalSize;
        }

        @Override
        public byte[] getEntryPrefix() {
            return this._extra._entryPrefix;
        }

        @Override
        public void setEntryPrefix(byte[] entryPrefix) {
            this._extra._entryPrefix = entryPrefix;
        }

        @Override
        public List<IndexData.Entry> getEntries() {
            return this._extra._entries;
        }

        @Override
        public void setEntries(List<IndexData.Entry> entries) {
            this._extra._entries = entries;
        }

        @Override
        public void addEntry(int idx, IndexData.Entry entry) throws IOException {
            this._main.getCache().addEntry(this, idx, entry);
        }

        @Override
        public IndexData.Entry removeEntry(int idx) throws IOException {
            return this._main.getCache().removeEntry(this, idx);
        }
    }

    private static class DataPageExtra {
        public List<IndexData.Entry> _entries;
        public EntryListView _entryView;
        public byte[] _entryPrefix;
        public int _totalEntrySize;
        public boolean _modified;

        private DataPageExtra() {
        }

        public void setEntryView(DataPageMain main) throws IOException {
            this._entryView = new EntryListView(main, this);
        }

        public void updateEntryPrefix() {
            if (this._entryPrefix.length == 0) {
                this._entryPrefix = IndexPageCache.findCommonPrefix(this._entries.get(0), this._entries.get(this._entries.size() - 1));
            }
        }

        public String toString() {
            return CustomToStringStyle.builder("DPExtra").append(null, this._entryView).toString();
        }
    }

    private class DataPageMain {
        public final int _pageNumber;
        public Integer _prevPageNumber;
        public Integer _nextPageNumber;
        public Integer _childTailPageNumber;
        public Integer _parentPageNumber;
        public boolean _leaf;
        public boolean _tail;
        private Reference<DataPageExtra> _extra;

        private DataPageMain(int pageNumber) {
            this._pageNumber = pageNumber;
        }

        public IndexPageCache getCache() {
            return IndexPageCache.this;
        }

        public boolean isRoot() {
            return this == IndexPageCache.this._rootPage;
        }

        public boolean isTail() throws IOException {
            this.resolveParent();
            return this._tail;
        }

        public boolean hasChildTail() {
            return this._childTailPageNumber != 0;
        }

        public boolean isChildTailPageNumber(int pageNumber) {
            return this._childTailPageNumber == pageNumber;
        }

        public DataPageMain getParentPage() throws IOException {
            this.resolveParent();
            return IndexPageCache.this.getDataPage(this._parentPageNumber);
        }

        public void initParentPage(Integer parentPageNumber, boolean isTail) {
            if (this._parentPageNumber == null) {
                this.setParentPage(parentPageNumber, isTail);
            }
        }

        public void setParentPage(Integer parentPageNumber, boolean isTail) {
            this._parentPageNumber = parentPageNumber;
            this._tail = isTail;
        }

        public DataPageMain getPrevPage() throws IOException {
            return IndexPageCache.this.getDataPage(this._prevPageNumber);
        }

        public DataPageMain getNextPage() throws IOException {
            return IndexPageCache.this.getDataPage(this._nextPageNumber);
        }

        public DataPageMain getChildPage(IndexData.Entry e) throws IOException {
            Integer childPageNumber = e.getSubPageNumber();
            return this.getChildPage(childPageNumber, this.isChildTailPageNumber(childPageNumber));
        }

        public DataPageMain getChildTailPage() throws IOException {
            return this.getChildPage(this._childTailPageNumber, true);
        }

        private DataPageMain getChildPage(Integer childPageNumber, boolean isTail) throws IOException {
            DataPageMain child = IndexPageCache.this.getDataPage(childPageNumber);
            if (child != null) {
                child.initParentPage(this._pageNumber, isTail);
            }
            return child;
        }

        public DataPageExtra getExtra() throws IOException {
            DataPageExtra extra = this._extra.get();
            if (extra == null) {
                extra = ((IndexPageCache)IndexPageCache.this).readDataPage((Integer)Integer.valueOf((int)this._pageNumber))._extra;
                this.setExtra(extra);
            }
            return extra;
        }

        public void setExtra(DataPageExtra extra) throws IOException {
            extra.setEntryView(this);
            this._extra = new SoftReference<DataPageExtra>(extra);
        }

        private void resolveParent() throws IOException {
            if (this._parentPageNumber == null) {
                IndexPageCache.this.findCacheDataPage(this.getExtra()._entryView.getLast());
                if (this._parentPageNumber == null) {
                    throw new IllegalStateException(IndexPageCache.this.withErrorContext("Parent was not resolved"));
                }
            }
        }

        public String toString() {
            return (this._leaf ? "Leaf" : "Node") + "DPMain[" + this._pageNumber + "] " + this._prevPageNumber + ", " + this._nextPageNumber + ", (" + this._childTailPageNumber + ")";
        }
    }

    private static enum UpdateType {
        ADD,
        REMOVE,
        REPLACE;

    }
}

