IF(NOT VERBOSE)
  SET(ffmpegExtractOutput OUTPUT_VARIABLE FFMPEG_EXTRACT_OUTPUT)
ENDIF()

IF(EXISTS "${FFMPEG_ROOT_DIR}/${FFMPEG_SOURCE_ARCHIVE}")
  MESSAGE(STATUS "Creating ${FFMPEG_BASE_DIR}")
  FILE(MAKE_DIRECTORY "${FFMPEG_BASE_DIR}")
  IF(NOT EXISTS "${FFMPEG_SOURCE_DIR}/fftools/ffmpeg.c" OR NOT "${LAST_FFMPEG_VERSION}" STREQUAL "${FFMPEG_VERSION}")
    FIND_PACKAGE(Tar)
    MESSAGE(STATUS "Unpacking ffmpeg from ${FFMPEG_ROOT_DIR}/${FFMPEG_SOURCE_ARCHIVE} to ${FFMPEG_BASE_DIR}")

    EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E copy "${FFMPEG_ROOT_DIR}/${FFMPEG_SOURCE_ARCHIVE}" "${FFMPEG_BASE_DIR}")
    IF(VERBOSE)
      SET(TAR_OPTS "xvfj")
    ELSE()
      SET(TAR_OPTS "xfj")
    ENDIF()
    EXECUTE_PROCESS(COMMAND ${TAR_EXECUTABLE} ${TAR_OPTS} "${FFMPEG_SOURCE_ARCHIVE}"
      WORKING_DIRECTORY "${FFMPEG_BASE_DIR}"
      ${ffmpegExtractOutput})

    EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E rename "${FFMPEG_SOURCE_ARCHIVE_DIR}" "source"
      WORKING_DIRECTORY "${FFMPEG_BASE_DIR}")

    SET(FFMPEG_PERFORM_PATCH 1)
    SET(FFMPEG_PERFORM_BUILD 1)
  ENDIF()

  SET(FFMPEG_PREPARED 1)
  SET(LAST_FFMPEG_VERSION "${FFMPEG_VERSION}" CACHE STRING "" FORCE)
ENDIF()
