/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.tagger;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.solr.handler.tagger.TermPrefixCursor;

public class TagLL {
    private final TagLL[] head;
    TagLL prevTag;
    TagLL nextTag;
    private TermPrefixCursor cursor;
    final int startOffset;
    int endOffset;
    Object value;
    boolean mark = false;

    TagLL(TagLL[] head, TermPrefixCursor cursor, int startOffset, int endOffset, Object value) {
        this.head = head;
        this.cursor = cursor;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.value = value;
    }

    boolean advance(BytesRef word, int offset) throws IOException {
        if (!this.isAdvancing()) {
            return false;
        }
        IntsRef iVal = this.cursor.getDocIds();
        if (word != null && this.cursor.advance(word)) {
            if (iVal != null) {
                this.addBeforeLL(new TagLL(this.head, null, this.startOffset, this.endOffset, iVal));
            }
            assert (offset >= this.endOffset);
            this.endOffset = offset;
            return true;
        }
        this.value = iVal;
        this.cursor = null;
        if (iVal == null) {
            this.removeLL();
        }
        return false;
    }

    public void removeLL() {
        if (this.head[0] == this) {
            this.head[0] = this.nextTag;
        }
        if (this.prevTag != null) {
            this.prevTag.nextTag = this.nextTag;
        }
        if (this.nextTag != null) {
            this.nextTag.prevTag = this.prevTag;
        }
    }

    void addBeforeLL(TagLL tag) {
        assert (tag.startOffset <= this.startOffset);
        if (this.prevTag != null) {
            assert (this.prevTag.startOffset <= tag.startOffset);
            this.prevTag.nextTag = tag;
            tag.prevTag = this.prevTag;
        } else {
            assert (this.head[0] == this);
            this.head[0] = tag;
        }
        this.prevTag = tag;
        tag.nextTag = this;
    }

    void addAfterLL(TagLL tag) {
        assert (tag.startOffset >= this.startOffset);
        if (this.nextTag != null) {
            assert (this.nextTag.startOffset >= tag.startOffset);
            this.nextTag.prevTag = tag;
            tag.nextTag = this.nextTag;
        }
        this.nextTag = tag;
        tag.prevTag = this;
    }

    public int charLen() {
        return this.endOffset - this.startOffset;
    }

    public TagLL getNextTag() {
        return this.nextTag;
    }

    public TagLL getPrevTag() {
        return this.prevTag;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean overlaps(TagLL other) {
        if (this.startOffset < other.startOffset) {
            return this.endOffset > other.startOffset;
        }
        return this.startOffset < other.endOffset;
    }

    boolean isAdvancing() {
        return this.cursor != null;
    }

    public String toString() {
        return (this.prevTag != null ? (char)'*' : '-') + "|" + (this.nextTag != null ? (char)'*' : '-') + " " + this.startOffset + " to " + this.endOffset + String.valueOf(this.isAdvancing() ? Character.valueOf('+') : " #" + String.valueOf(this.value));
    }
}

