"""Initial

Revision ID: b4b8a9957556
Revises: 
Create Date: 2024-12-02 16:55:10.509578

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'b4b8a9957556'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('report',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), nullable=True),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('gtl_dq_job_id', sa.Integer(), nullable=True),
    sa.Column('gtl_application_id', sa.Integer(), nullable=True),
    sa.Column('gtl_application_name', sa.String(), nullable=True),
    sa.Column('fc_job_id', sa.String(), nullable=True),
    sa.Column('fc_task_id', sa.String(), nullable=True),
    sa.Column('nsys_source_resolved_gtlfs_uuid', sa.String(), nullable=True),
    sa.Column('nsys_source_resolved_gtlfs_path', sa.String(), nullable=True),
    sa.Column('nsys_source_gtlfs_uuid', sa.String(), nullable=True),
    sa.Column('nsys_source_gtlfs_path', sa.String(), nullable=True),
    sa.Column('nsys_source_sqlite_gtlfs_uuid', sa.String(), nullable=True),
    sa.Column('nsys_source_sqlite_gtlfs_path', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_report_id'), 'report', ['id'], unique=False)
    op.create_table('application_stats',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('process_name', sa.String(), nullable=True),
    sa.Column('total_thread_count', sa.Integer(), nullable=True),
    sa.Column('active_thread_count', sa.Integer(), nullable=True),
    sa.Column('job_thread_count', sa.Integer(), nullable=True),
    sa.Column('serial_thread_count', sa.Integer(), nullable=True),
    sa.Column('concurrency_of_active_threads', sa.Integer(), nullable=True),
    sa.Column('start_time_s', sa.Double(), nullable=True),
    sa.Column('end_time_s', sa.Double(), nullable=True),
    sa.Column('average_cpu_frametime_ms', sa.Double(), nullable=True),
    sa.Column('average_gpu_frametime_ms', sa.Double(), nullable=True),
    sa.Column('cpu_idle_pct', sa.Double(), nullable=True),
    sa.Column('gpu_idle_pct', sa.Double(), nullable=True),
    sa.Column('total_thread_utilisation_pct', sa.Double(), nullable=True),
    sa.Column('busiest_thread_util_pct', sa.Double(), nullable=True),
    sa.Column('median_job_thread_util_pct', sa.Double(), nullable=True),
    sa.Column('serial_work_util_pct', sa.Double(), nullable=True),
    sa.Column('one_thread_active_pct', sa.Double(), nullable=True),
    sa.Column('two_threads_active_pct', sa.Double(), nullable=True),
    sa.Column('report_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['report_id'], ['report.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('report_id', name='application_stats_report_id_key')
    )
    op.create_index(op.f('ix_application_stats_id'), 'application_stats', ['id'], unique=False)
    op.create_table('cpu_info',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('core_count', sa.Integer(), nullable=True),
    sa.Column('p_core_count', sa.Integer(), nullable=True),
    sa.Column('p_smt_core_count', sa.Integer(), nullable=True),
    sa.Column('e_core_count', sa.Integer(), nullable=True),
    sa.Column('e_smt_core_count', sa.Integer(), nullable=True),
    sa.Column('report_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['report_id'], ['report.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('report_id', name='cpu_info_report_id_key')
    )
    op.create_index(op.f('ix_cpu_info_id'), 'cpu_info', ['id'], unique=False)
    op.create_table('health_check',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('metric_value', sa.Double(), nullable=True),
    sa.Column('metric_type', sa.String(), nullable=False),
    sa.Column('warning', sa.String(), nullable=True),
    sa.Column('flag', sa.String(), nullable=False),
    sa.Column('report_id', sa.Integer(), nullable=True),
    sa.CheckConstraint("flag IN ('green', 'yellow', 'red', '')", name='flag_check'),
    sa.CheckConstraint("metric_type IN ('bool', 'pct', 'int', 'float')", name='metric_type_check'),
    sa.ForeignKeyConstraint(['report_id'], ['report.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_health_check_id'), 'health_check', ['id'], unique=False)
    op.create_table('hotspot_analysis',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('process_name', sa.String(), nullable=True),
    sa.Column('process_id', sa.Integer(), nullable=True),
    sa.Column('start_time_s', sa.Double(), nullable=True),
    sa.Column('end_time_s', sa.Double(), nullable=True),
    sa.Column('duration_s', sa.Double(), nullable=True),
    sa.Column('region_description', sa.String(), nullable=True),
    sa.Column('number_of_regions', sa.Integer(), nullable=True),
    sa.Column('fastest_ms', sa.Double(), nullable=True),
    sa.Column('slowest_ms', sa.Double(), nullable=True),
    sa.Column('median_ms', sa.Double(), nullable=True),
    sa.Column('mean_ms', sa.Double(), nullable=True),
    sa.Column('average_micro_stutters_ms', sa.Double(), nullable=True),
    sa.Column('region_count', sa.Integer(), nullable=True),
    sa.Column('app_health_gpu_bound', sa.Boolean(), nullable=True),
    sa.Column('hotspot_range', sa.String(), nullable=True),
    sa.Column('hotspot_report_threading', sa.String(), nullable=True),
    sa.Column('report_id', sa.Integer(), nullable=True),
    sa.Column('custom_chart_title', sa.String(), nullable=True),
    sa.Column('custom_chart_x_axis_name', sa.String(), nullable=True),
    sa.Column('custom_chart_y_axis_name', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['report_id'], ['report.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_hotspot_analysis_id'), 'hotspot_analysis', ['id'], unique=False)
    op.create_table('process_utilisation',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('process', sa.String(), nullable=True),
    sa.Column('utilisation_pct', sa.Double(), nullable=True),
    sa.Column('report_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['report_id'], ['report.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_process_utilisation_id'), 'process_utilisation', ['id'], unique=False)
    op.create_table('thread_concurrency',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('thread_index', sa.Integer(), nullable=True),
    sa.Column('concurrency_time_ms', sa.Double(), nullable=True),
    sa.Column('concurrency_pct', sa.Double(), nullable=True),
    sa.Column('report_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['report_id'], ['report.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_thread_concurrency_id'), 'thread_concurrency', ['id'], unique=False)
    op.create_table('thread_time',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('time_ms', sa.Double(), nullable=True),
    sa.Column('utilisation_pct', sa.Double(), nullable=True),
    sa.Column('report_id', sa.Integer(), nullable=True),
    sa.Column('utilisation_p_core_pct', sa.Double(), nullable=True),
    sa.Column('utilisation_e_core_pct', sa.Double(), nullable=True),
    sa.ForeignKeyConstraint(['report_id'], ['report.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_thread_time_id'), 'thread_time', ['id'], unique=False)
    op.create_table('frame_times',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('frame_index', sa.Integer(), nullable=True),
    sa.Column('start_ns', sa.BigInteger(), nullable=True),
    sa.Column('duration_cpu_ms', sa.Double(), nullable=True),
    sa.Column('duration_gpu_ms', sa.Double(), nullable=True),
    sa.Column('hotspot_analysis_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['hotspot_analysis_id'], ['hotspot_analysis.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_frame_times_id'), 'frame_times', ['id'], unique=False)
    op.create_table('hotspot_analysis_custom_chart_rows',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('row_index', sa.Integer(), nullable=True),
    sa.Column('value', sa.Double(), nullable=True),
    sa.Column('hotspot_analysis_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['hotspot_analysis_id'], ['hotspot_analysis.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_hotspot_analysis_custom_chart_rows_id'), 'hotspot_analysis_custom_chart_rows', ['id'], unique=False)
    op.create_table('hotspot_analysis_custom_fields',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('value', sa.String(), nullable=True),
    sa.Column('hotspot_analysis_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['hotspot_analysis_id'], ['hotspot_analysis.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_hotspot_analysis_custom_fields_id'), 'hotspot_analysis_custom_fields', ['id'], unique=False)
    op.create_table('region',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('region_index', sa.Integer(), nullable=True),
    sa.Column('region_index_global', sa.Integer(), nullable=True),
    sa.Column('region_type', sa.String(), nullable=False),
    sa.Column('region_name', sa.String(), nullable=False),
    sa.Column('duration_ms', sa.Double(), nullable=True),
    sa.Column('start_time_s', sa.Double(), nullable=True),
    sa.Column('summed_metric_value', sa.Integer(), nullable=True),
    sa.Column('threads_count', sa.Integer(), nullable=True),
    sa.Column('is_cpu_bound', sa.Boolean(), nullable=True),
    sa.Column('is_median', sa.Boolean(), nullable=False),
    sa.Column('hotspot_analysis_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['hotspot_analysis_id'], ['hotspot_analysis.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_region_id'), 'region', ['id'], unique=False)
    op.create_table('region_app_dxg_kernel_profile_ranges',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('frame_duration_pct', sa.Double(), nullable=True),
    sa.Column('duration_ms', sa.Double(), nullable=True),
    sa.Column('range_count', sa.Integer(), nullable=True),
    sa.Column('top_dxg_kernel_profile_event_ranges', sa.String(), nullable=True),
    sa.Column('region_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_region_app_dxg_kernel_profile_ranges_id'), 'region_app_dxg_kernel_profile_ranges', ['id'], unique=False)
    op.create_table('region_custom_fields',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('value', sa.String(), nullable=True),
    sa.Column('region_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_region_custom_fields_id'), 'region_custom_fields', ['id'], unique=False)
    op.create_table('region_etw_events',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('count', sa.Integer(), nullable=True),
    sa.Column('pct', sa.Double(), nullable=True),
    sa.Column('type', sa.String(), nullable=True),
    sa.Column('region_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_region_etw_events_id'), 'region_etw_events', ['id'], unique=False)
    op.create_table('region_issues',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('category', sa.String(), nullable=True),
    sa.Column('health_string', sa.String(), nullable=True),
    sa.Column('health_value', sa.Double(), nullable=True),
    sa.Column('sub_category', sa.String(), nullable=True),
    sa.Column('is_priority', sa.Boolean(), nullable=True),
    sa.Column('region_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_region_issues_id'), 'region_issues', ['id'], unique=False)
    op.create_table('region_metrics',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('region_id', sa.Integer(), nullable=True),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('value', sa.Double(), nullable=True),
    sa.Column('unit', sa.String(), nullable=False),
    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_region_metrics_id'), 'region_metrics', ['id'], unique=False)
    op.create_table('region_present_threads',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('thread_id', sa.BigInteger(), nullable=True),
    sa.Column('region_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_region_present_threads_id'), 'region_present_threads', ['id'], unique=False)
    op.create_table('region_submit_threads',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('thread_id', sa.BigInteger(), nullable=True),
    sa.Column('region_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_region_submit_threads_id'), 'region_submit_threads', ['id'], unique=False)
    op.create_table('region_thread',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('thread_id', sa.BigInteger(), nullable=True),
    sa.Column('time_ms', sa.Double(), nullable=True),
    sa.Column('time_pcore_ms', sa.Double(), nullable=True),
    sa.Column('time_ecore_ms', sa.Double(), nullable=True),
    sa.Column('utilization_pct', sa.Double(), nullable=True),
    sa.Column('utilization_pcore_pct', sa.Double(), nullable=True),
    sa.Column('utilization_ecore_pct', sa.Double(), nullable=True),
    sa.Column('has_info', sa.Boolean(), nullable=True),
    sa.Column('region_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['region_id'], ['region.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_region_thread_id'), 'region_thread', ['id'], unique=False)
    op.create_table('thread_callstack',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('callstack_index', sa.Integer(), nullable=True),
    sa.Column('count', sa.Integer(), nullable=True),
    sa.Column('type', sa.String(), nullable=True),
    sa.Column('thread_trace', sa.String(), nullable=True),
    sa.Column('region_thread_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['region_thread_id'], ['region_thread.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_thread_callstack_id'), 'thread_callstack', ['id'], unique=False)
    op.create_table('thread_hotspot_collection',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('type', sa.String(), nullable=True),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('start_time_ns', sa.Double(), nullable=True),
    sa.Column('end_time_ns', sa.Double(), nullable=True),
    sa.Column('raw_total_samples', sa.Integer(), nullable=True),
    sa.Column('raw_total_duration', sa.Double(), nullable=True),
    sa.Column('sample_string', sa.String(), nullable=True),
    sa.Column('start_time_string', sa.String(), nullable=True),
    sa.Column('duration_string', sa.String(), nullable=True),
    sa.Column('unit_string', sa.String(), nullable=True),
    sa.Column('name_string', sa.String(), nullable=True),
    sa.Column('is_duration', sa.Boolean(), nullable=True),
    sa.Column('extra_1_string', sa.String(), nullable=True),
    sa.Column('extra_2_string', sa.String(), nullable=True),
    sa.Column('view_type', sa.String(), nullable=True),
    sa.Column('region_thread_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['region_thread_id'], ['region_thread.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_thread_hotspot_collection_id'), 'thread_hotspot_collection', ['id'], unique=False)
    op.create_table('thread_hotspot_record',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('value', sa.Double(), nullable=True),
    sa.Column('duration', sa.Double(), nullable=True),
    sa.Column('sample_count', sa.Integer(), nullable=True),
    sa.Column('start_time', sa.Double(), nullable=True),
    sa.Column('extra_1', sa.String(), nullable=True),
    sa.Column('extra_2', sa.String(), nullable=True),
    sa.Column('thread_hotspot_collection_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['thread_hotspot_collection_id'], ['thread_hotspot_collection.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_thread_hotspot_record_id'), 'thread_hotspot_record', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_thread_hotspot_record_id'), table_name='thread_hotspot_record')
    op.drop_table('thread_hotspot_record')
    op.drop_index(op.f('ix_thread_hotspot_collection_id'), table_name='thread_hotspot_collection')
    op.drop_table('thread_hotspot_collection')
    op.drop_index(op.f('ix_thread_callstack_id'), table_name='thread_callstack')
    op.drop_table('thread_callstack')
    op.drop_index(op.f('ix_region_thread_id'), table_name='region_thread')
    op.drop_table('region_thread')
    op.drop_index(op.f('ix_region_submit_threads_id'), table_name='region_submit_threads')
    op.drop_table('region_submit_threads')
    op.drop_index(op.f('ix_region_present_threads_id'), table_name='region_present_threads')
    op.drop_table('region_present_threads')
    op.drop_index(op.f('ix_region_metrics_id'), table_name='region_metrics')
    op.drop_table('region_metrics')
    op.drop_index(op.f('ix_region_issues_id'), table_name='region_issues')
    op.drop_table('region_issues')
    op.drop_index(op.f('ix_region_etw_events_id'), table_name='region_etw_events')
    op.drop_table('region_etw_events')
    op.drop_index(op.f('ix_region_custom_fields_id'), table_name='region_custom_fields')
    op.drop_table('region_custom_fields')
    op.drop_index(op.f('ix_region_app_dxg_kernel_profile_ranges_id'), table_name='region_app_dxg_kernel_profile_ranges')
    op.drop_table('region_app_dxg_kernel_profile_ranges')
    op.drop_index(op.f('ix_region_id'), table_name='region')
    op.drop_table('region')
    op.drop_index(op.f('ix_hotspot_analysis_custom_fields_id'), table_name='hotspot_analysis_custom_fields')
    op.drop_table('hotspot_analysis_custom_fields')
    op.drop_index(op.f('ix_hotspot_analysis_custom_chart_rows_id'), table_name='hotspot_analysis_custom_chart_rows')
    op.drop_table('hotspot_analysis_custom_chart_rows')
    op.drop_index(op.f('ix_frame_times_id'), table_name='frame_times')
    op.drop_table('frame_times')
    op.drop_index(op.f('ix_thread_time_id'), table_name='thread_time')
    op.drop_table('thread_time')
    op.drop_index(op.f('ix_thread_concurrency_id'), table_name='thread_concurrency')
    op.drop_table('thread_concurrency')
    op.drop_index(op.f('ix_process_utilisation_id'), table_name='process_utilisation')
    op.drop_table('process_utilisation')
    op.drop_index(op.f('ix_hotspot_analysis_id'), table_name='hotspot_analysis')
    op.drop_table('hotspot_analysis')
    op.drop_index(op.f('ix_health_check_id'), table_name='health_check')
    op.drop_table('health_check')
    op.drop_index(op.f('ix_cpu_info_id'), table_name='cpu_info')
    op.drop_table('cpu_info')
    op.drop_index(op.f('ix_application_stats_id'), table_name='application_stats')
    op.drop_table('application_stats')
    op.drop_index(op.f('ix_report_id'), table_name='report')
    op.drop_table('report')
    # ### end Alembic commands ###
