/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllClassVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.gson.GsonBuilderInvocationFinder;
import proguard.optimize.gson.GsonDeserializationInvocationFinder;
import proguard.optimize.gson.GsonDomainClassFinder;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.GsonSerializationInvocationFinder;

public class GsonContext {
    public ClassPool filteredClasses;
    public ClassPool gsonDomainClassPool;
    public ClassPool instanceCreatorClassPool;
    public ClassPool typeAdapterClassPool;
    public GsonRuntimeSettings gsonRuntimeSettings;

    public void setupFor(ClassPool programClassPool, WarningPrinter notePrinter) {
        this.filteredClasses = new ClassPool();
        programClassPool.classesAccept(new ClassNameFilter("!com/google/gson/**", (ClassVisitor)new ClassPoolFiller(this.filteredClasses)));
        this.gsonRuntimeSettings = new GsonRuntimeSettings();
        this.instanceCreatorClassPool = new ClassPool();
        this.typeAdapterClassPool = new ClassPool();
        GsonBuilderInvocationFinder gsonBuilderInvocationFinder = new GsonBuilderInvocationFinder(programClassPool, this.gsonRuntimeSettings, new ClassPoolFiller(this.instanceCreatorClassPool), new ClassPoolFiller(this.typeAdapterClassPool));
        this.filteredClasses.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(gsonBuilderInvocationFinder))));
        this.gsonDomainClassPool = new ClassPool();
        GsonDomainClassFinder domainClassFinder = new GsonDomainClassFinder(this.typeAdapterClassPool, this.gsonDomainClassPool, notePrinter);
        this.filteredClasses.accept(new AllClassVisitor(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new MultiInstructionVisitor(new GsonSerializationInvocationFinder(programClassPool, domainClassFinder, notePrinter), new GsonDeserializationInvocationFinder(programClassPool, domainClassFinder, notePrinter)))))));
    }
}

