﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws {
namespace Backup {
namespace Model {
enum class MalwareScanner { NOT_SET, GUARDDUTY };

namespace MalwareScannerMapper {
AWS_BACKUP_API MalwareScanner GetMalwareScannerForName(const Aws::String& name);

AWS_BACKUP_API Aws::String GetNameForMalwareScanner(MalwareScanner value);
}  // namespace MalwareScannerMapper
}  // namespace Model
}  // namespace Backup
}  // namespace Aws
