﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bcm-pricing-calculator/BCMPricingCalculatorRequest.h>
#include <aws/bcm-pricing-calculator/BCMPricingCalculator_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace BCMPricingCalculator {
namespace Model {

/**
 */
class BatchDeleteBillScenarioUsageModificationRequest : public BCMPricingCalculatorRequest {
 public:
  AWS_BCMPRICINGCALCULATOR_API BatchDeleteBillScenarioUsageModificationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "BatchDeleteBillScenarioUsageModification"; }

  AWS_BCMPRICINGCALCULATOR_API Aws::String SerializePayload() const override;

  AWS_BCMPRICINGCALCULATOR_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p> The ID of the Bill Scenario for which you want to delete the modeled usage.
   * </p>
   */
  inline const Aws::String& GetBillScenarioId() const { return m_billScenarioId; }
  inline bool BillScenarioIdHasBeenSet() const { return m_billScenarioIdHasBeenSet; }
  template <typename BillScenarioIdT = Aws::String>
  void SetBillScenarioId(BillScenarioIdT&& value) {
    m_billScenarioIdHasBeenSet = true;
    m_billScenarioId = std::forward<BillScenarioIdT>(value);
  }
  template <typename BillScenarioIdT = Aws::String>
  BatchDeleteBillScenarioUsageModificationRequest& WithBillScenarioId(BillScenarioIdT&& value) {
    SetBillScenarioId(std::forward<BillScenarioIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> List of usage that you want to delete from the Bill Scenario. </p>
   */
  inline const Aws::Vector<Aws::String>& GetIds() const { return m_ids; }
  inline bool IdsHasBeenSet() const { return m_idsHasBeenSet; }
  template <typename IdsT = Aws::Vector<Aws::String>>
  void SetIds(IdsT&& value) {
    m_idsHasBeenSet = true;
    m_ids = std::forward<IdsT>(value);
  }
  template <typename IdsT = Aws::Vector<Aws::String>>
  BatchDeleteBillScenarioUsageModificationRequest& WithIds(IdsT&& value) {
    SetIds(std::forward<IdsT>(value));
    return *this;
  }
  template <typename IdsT = Aws::String>
  BatchDeleteBillScenarioUsageModificationRequest& AddIds(IdsT&& value) {
    m_idsHasBeenSet = true;
    m_ids.emplace_back(std::forward<IdsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_billScenarioId;

  Aws::Vector<Aws::String> m_ids;
  bool m_billScenarioIdHasBeenSet = false;
  bool m_idsHasBeenSet = false;
};

}  // namespace Model
}  // namespace BCMPricingCalculator
}  // namespace Aws
