﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/AWSMigrationHub/MigrationHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MigrationHub {
namespace Model {

/**
 * <p>A source resource can be a source server, a migration wave, an application,
 * or any other resource that you track.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/SourceResource">AWS
 * API Reference</a></p>
 */
class SourceResource {
 public:
  AWS_MIGRATIONHUB_API SourceResource() = default;
  AWS_MIGRATIONHUB_API SourceResource(Aws::Utils::Json::JsonView jsonValue);
  AWS_MIGRATIONHUB_API SourceResource& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MIGRATIONHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>This is the name that you want to use to identify the resource. If the
   * resource is an AWS resource, we recommend that you set this parameter to the ARN
   * of the resource.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  SourceResource& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description that can be free-form text to record additional detail about
   * the resource for clarity or later reference.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  SourceResource& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A free-form description of the status of the resource.</p>
   */
  inline const Aws::String& GetStatusDetail() const { return m_statusDetail; }
  inline bool StatusDetailHasBeenSet() const { return m_statusDetailHasBeenSet; }
  template <typename StatusDetailT = Aws::String>
  void SetStatusDetail(StatusDetailT&& value) {
    m_statusDetailHasBeenSet = true;
    m_statusDetail = std::forward<StatusDetailT>(value);
  }
  template <typename StatusDetailT = Aws::String>
  SourceResource& WithStatusDetail(StatusDetailT&& value) {
    SetStatusDetail(std::forward<StatusDetailT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_description;

  Aws::String m_statusDetail;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_statusDetailHasBeenSet = false;
};

}  // namespace Model
}  // namespace MigrationHub
}  // namespace Aws
