// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_VIDEOCHROMA_H
#define _GSTREAMERMM_VIDEOCHROMA_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2015 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/video/video-chroma.h>


namespace Gst
{
  /** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var VideoChromaSite VIDEO_CHROMA_SITE_UNKNOWN
 * Unknown cositing.
 * 
 *  @var VideoChromaSite VIDEO_CHROMA_SITE_NONE
 * No cositing.
 * 
 *  @var VideoChromaSite VIDEO_CHROMA_SITE_H_COSITED
 * Chroma is horizontally cosited.
 * 
 *  @var VideoChromaSite VIDEO_CHROMA_SITE_V_COSITED
 * Chroma is vertically cosited.
 * 
 *  @var VideoChromaSite VIDEO_CHROMA_SITE_ALT_LINE
 * Choma samples are sited on alternate lines.
 * 
 *  @var VideoChromaSite VIDEO_CHROMA_SITE_COSITED
 * Chroma samples cosited with luma samples.
 * 
 *  @var VideoChromaSite VIDEO_CHROMA_SITE_JPEG
 * Jpeg style cositing, also for mpeg1 and mjpeg.
 * 
 *  @var VideoChromaSite VIDEO_CHROMA_SITE_MPEG2
 * Mpeg2 style cositing.
 * 
 *  @var VideoChromaSite VIDEO_CHROMA_SITE_DV
 * DV style cositing.
 * 
 *  @enum VideoChromaSite
 * 
 * Various Chroma sitings.
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%VideoChromaSite operator|(VideoChromaSite, VideoChromaSite)</tt><br>
 * <tt>%VideoChromaSite operator&(VideoChromaSite, VideoChromaSite)</tt><br>
 * <tt>%VideoChromaSite operator^(VideoChromaSite, VideoChromaSite)</tt><br>
 * <tt>%VideoChromaSite operator~(VideoChromaSite)</tt><br>
 * <tt>%VideoChromaSite& operator|=(VideoChromaSite&, VideoChromaSite)</tt><br>
 * <tt>%VideoChromaSite& operator&=(VideoChromaSite&, VideoChromaSite)</tt><br>
 * <tt>%VideoChromaSite& operator^=(VideoChromaSite&, VideoChromaSite)</tt><br>
 */
enum VideoChromaSite
{
  VIDEO_CHROMA_SITE_UNKNOWN = 0x0,
  VIDEO_CHROMA_SITE_NONE = (1 << 0),
  VIDEO_CHROMA_SITE_H_COSITED = (1 << 1),
  VIDEO_CHROMA_SITE_V_COSITED = (1 << 2),
  VIDEO_CHROMA_SITE_ALT_LINE = (1 << 3),
  VIDEO_CHROMA_SITE_COSITED = 0x6,
  VIDEO_CHROMA_SITE_JPEG = 0x1,
  VIDEO_CHROMA_SITE_MPEG2 = 0x2,
  VIDEO_CHROMA_SITE_DV = 0xE
};

/** @ingroup gstreamermmEnums */
inline VideoChromaSite operator|(VideoChromaSite lhs, VideoChromaSite rhs)
  { return static_cast<VideoChromaSite>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoChromaSite operator&(VideoChromaSite lhs, VideoChromaSite rhs)
  { return static_cast<VideoChromaSite>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoChromaSite operator^(VideoChromaSite lhs, VideoChromaSite rhs)
  { return static_cast<VideoChromaSite>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoChromaSite operator~(VideoChromaSite flags)
  { return static_cast<VideoChromaSite>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline VideoChromaSite& operator|=(VideoChromaSite& lhs, VideoChromaSite rhs)
  { return (lhs = static_cast<VideoChromaSite>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline VideoChromaSite& operator&=(VideoChromaSite& lhs, VideoChromaSite rhs)
  { return (lhs = static_cast<VideoChromaSite>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline VideoChromaSite& operator^=(VideoChromaSite& lhs, VideoChromaSite rhs)
  { return (lhs = static_cast<VideoChromaSite>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::VideoChromaSite> : public Glib::Value_Flags<Gst::VideoChromaSite>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

  /** 
 *  @var VideoChromaMethod VIDEO_CHROMA_METHOD_NEAREST
 * Duplicates the chroma samples when
 * upsampling and drops when subsampling.
 * 
 *  @var VideoChromaMethod VIDEO_CHROMA_METHOD_LINEAR
 * Uses linear interpolation to reconstruct
 * missing chroma and averaging to subsample.
 * 
 *  @enum VideoChromaMethod
 * 
 * Different subsampling and upsampling methods
 *
 * @ingroup gstreamermmEnums
 */
enum VideoChromaMethod
{
  VIDEO_CHROMA_METHOD_NEAREST,
  VIDEO_CHROMA_METHOD_LINEAR
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::VideoChromaMethod> : public Glib::Value_Enum<Gst::VideoChromaMethod>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

  /** 
 *  @var VideoChromaFlags VIDEO_CHROMA_FLAG_NONE
 * No flags.
 * 
 *  @var VideoChromaFlags VIDEO_CHROMA_FLAG_INTERLACED
 * The input is interlaced.
 * 
 *  @enum VideoChromaFlags
 * 
 * Extra flags that influence the result from gst_video_chroma_resample_new().
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%VideoChromaFlags operator|(VideoChromaFlags, VideoChromaFlags)</tt><br>
 * <tt>%VideoChromaFlags operator&(VideoChromaFlags, VideoChromaFlags)</tt><br>
 * <tt>%VideoChromaFlags operator^(VideoChromaFlags, VideoChromaFlags)</tt><br>
 * <tt>%VideoChromaFlags operator~(VideoChromaFlags)</tt><br>
 * <tt>%VideoChromaFlags& operator|=(VideoChromaFlags&, VideoChromaFlags)</tt><br>
 * <tt>%VideoChromaFlags& operator&=(VideoChromaFlags&, VideoChromaFlags)</tt><br>
 * <tt>%VideoChromaFlags& operator^=(VideoChromaFlags&, VideoChromaFlags)</tt><br>
 */
enum VideoChromaFlags
{
  VIDEO_CHROMA_FLAG_NONE = 0x0,
  VIDEO_CHROMA_FLAG_INTERLACED = (1 << 0)
};

/** @ingroup gstreamermmEnums */
inline VideoChromaFlags operator|(VideoChromaFlags lhs, VideoChromaFlags rhs)
  { return static_cast<VideoChromaFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoChromaFlags operator&(VideoChromaFlags lhs, VideoChromaFlags rhs)
  { return static_cast<VideoChromaFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoChromaFlags operator^(VideoChromaFlags lhs, VideoChromaFlags rhs)
  { return static_cast<VideoChromaFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline VideoChromaFlags operator~(VideoChromaFlags flags)
  { return static_cast<VideoChromaFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline VideoChromaFlags& operator|=(VideoChromaFlags& lhs, VideoChromaFlags rhs)
  { return (lhs = static_cast<VideoChromaFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline VideoChromaFlags& operator&=(VideoChromaFlags& lhs, VideoChromaFlags rhs)
  { return (lhs = static_cast<VideoChromaFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline VideoChromaFlags& operator^=(VideoChromaFlags& lhs, VideoChromaFlags rhs)
  { return (lhs = static_cast<VideoChromaFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::VideoChromaFlags> : public Glib::Value_Flags<Gst::VideoChromaFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

}

#include <gstreamermm/videoformat.h>

namespace Gst
{

namespace Enums
{
/** Converts @a site to its string representation.
 * @param site A Gst::VideoChromaSite.
 * @return a string describing @a site.
 */
Glib::ustring get_name(VideoChromaSite site);

/** Convert @a s to a Gst::VideoChromaSite.
 * @param s A chromasite string.
 * @return A Gst::VideoChromaSite or Gst::VIDEO_CHROMA_SITE_UNKNOWN when @a s does
 * not contain a valid chroma description.
 */
VideoChromaSite video_chroma_site_from_string(const Glib::ustring& s);
}

class VideoChromaResample
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = VideoChromaResample;
  using BaseObjectType = GstVideoChromaResample;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
  VideoChromaResample(Gst::VideoChromaMethod method, Gst::VideoChromaSite site, Gst::VideoChromaFlags flags,
    Gst::VideoFormat format, gint h_factor, gint v_factor);

  // it takes ownership of castitem
  explicit VideoChromaResample(GstVideoChromaResample* castitem);

  ~VideoChromaResample();

  GstVideoChromaResample*       gobj()       { return gobject_; }
  const GstVideoChromaResample* gobj() const { return gobject_; }

  
  /** The resampler must be fed @a n_lines at a time. The first line should be
   * at @a offset.
   * 
   * @param n_lines The number of input lines.
   * @param offset The first line.
   */
  void get_info(guint& n_lines, gint& offset) const;

protected:
  GstVideoChromaResample* gobject_;


};

}


#endif /* _GSTREAMERMM_VIDEOCHROMA_H */

