// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_TASKPOOL_H
#define _GSTREAMERMM_TASKPOOL_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstTaskPool = struct _GstTaskPool;
using GstTaskPoolClass = struct _GstTaskPoolClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class  TaskPool_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** A class representing a pool of GStreamer streaming threads.
 * This object provides an abstraction for creating threads. The default
 * implementation uses a regular Glib::ThreadPool to start tasks.
 *
 * Subclasses can be made to create custom threads.
 *
 * Last reviewed on 2009-04-23 (0.10.24)
 */

class TaskPool : public Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = TaskPool;
  using CppClassType = TaskPool_Class;
  using BaseObjectType = GstTaskPool;
  using BaseClassType = GstTaskPoolClass;

  // noncopyable
  TaskPool(const TaskPool&) = delete;
  TaskPool& operator=(const TaskPool&) = delete;

private:  friend class TaskPool_Class;
  static CppClassType taskpool_class_;

protected:
  explicit TaskPool(const Glib::ConstructParams& construct_params);
  explicit TaskPool(GstTaskPool* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  TaskPool(TaskPool&& src) noexcept;
  TaskPool& operator=(TaskPool&& src) noexcept;

  ~TaskPool() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstTaskPool*       gobj()       { return reinterpret_cast<GstTaskPool*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstTaskPool* gobj() const { return reinterpret_cast<GstTaskPool*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstTaskPool* gobj_copy();

private:


protected:
  TaskPool();

public:
  /** For example,
   * void on_do_push();.
   */
  typedef sigc::slot<void> SlotPush;

public:
  /** Create a new default task pool. The default task pool will use a regular
   * Glib::ThreadPool for threads.
   * @return A new Gst::TaskPool.
   */
  
  static Glib::RefPtr<TaskPool> create();


  /** @throw Glib::Error.
   */
  void prepare();

  /** Start the execution of a new thread from pool.
   *
   * @param slot The function to call.
   * @return A pointer that should be used for the join() method. This pointer
   * can be 0, you must check error to detect errors.
   * @throw Glib::Error.
   */
  gpointer push(const SlotPush& slot);
  

  /** Join a task and/or return it to the pool. @a id is the id obtained from 
   * push().
   * 
   * @param id The id.
   */
  void join(gpointer id);
  
  /** Wait for all tasks to be stopped. This is mainly used internally
   * to ensure proper cleanup of internal data structures in test suites.
   * 
   * MT safe.
   */
  void cleanup();

  /** Virtual function which prepares the thread pool.
   * @throw Glib::Error.
   */
  virtual void prepare_vfunc();

  /** Virtual function to cleanup the thread pool.
   */
    virtual void cleanup_vfunc();


  /** Virtual function which starts a new thread.
   * @throw Glib::Error.
   */
  virtual gpointer push_vfunc(const SlotPush& slot);

  /** Virtual function to join a thread.
   */
    virtual void join_vfunc(gpointer id);


protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::TaskPool
   */
  
  Glib::RefPtr<Gst::TaskPool> wrap(GstTaskPool* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_TASKPOOL_H */

